/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension.dive_to_the_heart;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import online.kingdomkeys.kingdomkeys.world.dimension.ModDimensions;
import online.kingdomkeys.kingdomkeys.world.utils.BaseTeleporter;

@Mod.EventBusSubscriber
public class DiveToTheHeartDimension {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void renderFog(ViewportEvent.RenderFog event) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null && world.m_46472_().equals(ModDimensions.DIVE_TO_THE_HEART)) {
            RenderSystem.setShaderFogStart((float)0.0f);
            RenderSystem.setShaderFogEnd((float)30.0f);
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        if (event.getEntity() instanceof Player && !((Player)event.getEntity()).m_7500_() && event.getEntity().m_9236_().m_46472_().equals(ModDimensions.DIVE_TO_THE_HEART)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.m_7500_() && event.player.m_9236_().m_46472_().equals(ModDimensions.DIVE_TO_THE_HEART)) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(event.player);
            if (playerData != null && playerData.getSoAState() == SoAState.NONE) {
                playerData.setSoAState(SoAState.CHOICE);
            }
            if (event.player.m_20186_() < 10.0) {
                if (playerData.getSoAState() == SoAState.COMPLETE) {
                    if (!event.player.m_9236_().m_5776_()) {
                        event.player.m_183634_();
                        ServerLevel dimension = event.player.m_9236_().m_7654_().m_129880_(playerData.getReturnDimension());
                        event.player.changeDimension(dimension, (ITeleporter)new BaseTeleporter(playerData.getReturnLocation()));
                    }
                } else {
                    event.player.m_6021_(0.0, 25.0, 0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent event) {
        if (!event.getPlayer().m_7500_() && event.getPlayer().m_9236_().m_46472_().equals(ModDimensions.DIVE_TO_THE_HEART)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void placeBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getEntity().m_7500_() && event.getLevel().m_46472_().equals(ModDimensions.DIVE_TO_THE_HEART)) {
            if (event.getLevel().m_8055_(event.getPos()).m_60734_() == ModBlocks.pedestal.get()) {
                if (event.getEntity().m_6144_()) {
                    event.setCanceled(true);
                }
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void useItem(PlayerInteractEvent.RightClickItem event) {
        if (!event.getEntity().m_7500_() && event.getLevel().m_46472_().equals(ModDimensions.DIVE_TO_THE_HEART)) {
            event.setCanceled(true);
        }
    }
}

