/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import online.kingdomkeys.kingdomkeys.util.Utils;
import online.kingdomkeys.kingdomkeys.world.features.MultipleBlockMatchRuleTest;

public class BloxOreFeatureConfig
implements FeatureConfiguration {
    public static final Codec<BloxOreFeatureConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.list(TargetBlockState.CODEC).fieldOf("targets").forGetter(config -> config.targetStates), (App)Codec.intRange((int)0, (int)64).fieldOf("size").forGetter(config -> config.size), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("discard_chance_on_air_exposure").forGetter(config -> Float.valueOf(config.discardChanceOnAirExposure))).apply((Applicative)builder, BloxOreFeatureConfig::new));
    public final int size;
    public final List<TargetBlockState> targetStates;
    public final float discardChanceOnAirExposure;

    public BloxOreFeatureConfig(List<TargetBlockState> targetStates, int size, float discardChanceOnAirExposure) {
        this.size = size;
        this.discardChanceOnAirExposure = discardChanceOnAirExposure;
        this.targetStates = targetStates;
    }

    public static class TargetBlockState {
        public static final Codec<TargetBlockState> CODEC = RecordCodecBuilder.create(p_161039_ -> p_161039_.group((App)RuleTest.f_74307_.fieldOf("target").forGetter(p_161043_ -> p_161043_.target), (App)BlockState.f_61039_.listOf().fieldOf("states").forGetter(p_161041_ -> p_161041_.states), (App)Codec.INT.listOf().fieldOf("weights").forGetter(targetBlockState -> targetBlockState.weights)).apply((Applicative)p_161039_, TargetBlockState::new));
        public final RuleTest target;
        public final List<BlockState> states;
        public final List<Integer> weights;
        public final Map<BlockState, Integer> weightedStates = new HashMap<BlockState, Integer>();

        TargetBlockState(RuleTest target, List<BlockState> states, List<Integer> weights) {
            this.target = target;
            this.states = states;
            this.weights = weights;
            for (int i = 0; i < states.size(); ++i) {
                if (i < weights.size()) {
                    this.weightedStates.put(states.get(i), weights.get(i));
                    continue;
                }
                this.weightedStates.put(states.get(i), 1);
            }
        }

        public BlockState getState() {
            ArrayList weightAdjustedStates = new ArrayList();
            this.weightedStates.forEach((blockState, integer) -> {
                for (int i = 0; i < integer; ++i) {
                    weightAdjustedStates.add(blockState);
                }
            });
            int value = Utils.randomWithRange(0, weightAdjustedStates.size() - 1);
            return (BlockState)weightAdjustedStates.get(value);
        }
    }

    public static final class FillerBlockType {
        public static final RuleTest END = new BlockMatchTest(Blocks.f_50259_);
        public static final RuleTest OVERWORLD = new MultipleBlockMatchRuleTest(Arrays.asList(Blocks.f_50440_, Blocks.f_50493_, Blocks.f_49992_));
    }
}

