/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.artisttable;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.capability.canvastracker.CanvasTracker;
import me.dantaeusb.zetter.client.gui.ArtistTableScreen;
import me.dantaeusb.zetter.client.gui.artisttable.AbstractArtistTableWidget;
import me.dantaeusb.zetter.client.renderer.CanvasRenderer;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.menu.ArtistTableMenu;
import me.dantaeusb.zetter.storage.CanvasData;
import me.dantaeusb.zetter.storage.DummyCanvasData;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;

public class PreviewWidget
extends AbstractArtistTableWidget
implements Widget,
GuiEventListener {
    private static final Component EMPTY_TITLE = Component.m_237115_((String)"container.zetter.artist_table.combined_canvas.empty");
    private static final Component INVALID_TITLE = Component.m_237115_((String)"container.zetter.artist_table.combined_canvas.invalid");
    private static final Component LOADING_TITLE = Component.m_237115_((String)"container.zetter.artist_table.combined_canvas.loading");
    private static final int size = 64;

    public PreviewWidget(ArtistTableScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 64, 64, (Component)Component.m_237115_((String)"container.zetter.artist_table.combined_canvas"));
    }

    public void render(PoseStack matrixStack) {
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)this.f_93620_, (double)this.f_93621_, 1.0);
        DummyCanvasData canvasData = ((ArtistTableMenu)this.parentScreen.m_6262_()).getAction().getCanvasData();
        this.drawCanvas(matrixStack, canvasData);
        matrixStack.m_85849_();
    }

    private void drawCanvas(PoseStack matrixStack, @Nullable DummyCanvasData canvasData) {
        if (canvasData != null) {
            int scale = PreviewWidget.getScale(canvasData);
            Tuple<Integer, Integer> displacement = PreviewWidget.getDisplacement(canvasData, scale);
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)((Integer)displacement.m_14418_()).intValue(), (double)((Integer)displacement.m_14419_()).intValue(), 1.0);
            matrixStack.m_85841_((float)scale, (float)scale, 1.0f);
            MultiBufferSource.BufferSource renderTypeBufferImpl = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            CanvasRenderer.getInstance().renderCanvas(matrixStack, (MultiBufferSource)renderTypeBufferImpl, "zetter_combined_canvas", canvasData, 0xF000F0);
            renderTypeBufferImpl.m_109911_();
            matrixStack.m_85849_();
        }
    }

    public static Tuple<Integer, Integer> getDisplacement(@Nullable DummyCanvasData canvasData, int scale) {
        if (canvasData != null) {
            int xSize = canvasData.getWidth() / Helper.getResolution().getNumeric() * Helper.getBasicResolution().getNumeric() * scale;
            int ySize = canvasData.getHeight() / Helper.getResolution().getNumeric() * Helper.getBasicResolution().getNumeric() * scale;
            int width = Helper.getBasicResolution().getNumeric() * 4;
            int height = Helper.getBasicResolution().getNumeric() * 4;
            return new Tuple((Object)((width - xSize) / 2), (Object)((height - ySize) / 2));
        }
        return new Tuple((Object)0, (Object)0);
    }

    public static int getScale(@Nullable DummyCanvasData canvasData) {
        if (canvasData != null) {
            int xScale = 4 / (canvasData.getWidth() / Helper.getResolution().getNumeric());
            int yScale = 4 / (canvasData.getHeight() / Helper.getResolution().getNumeric());
            return Math.min(xScale, yScale);
        }
        return 1;
    }

    @Nullable
    public static CanvasData getCanvasData(Level world, String canvasName) {
        CanvasTracker canvasTracker = Helper.getLevelCanvasTracker(world);
        return (CanvasData)((Object)canvasTracker.getCanvasData(canvasName));
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        switch (((ArtistTableMenu)this.parentScreen.m_6262_()).getActionState()) {
            case EMPTY: {
                return EMPTY_TITLE;
            }
            case INVALID: {
                return INVALID_TITLE;
            }
            case NOT_LOADED: {
                return LOADING_TITLE;
            }
        }
        return this.m_6035_();
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }
}

