/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.easel;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.client.gui.EaselScreen;
import me.dantaeusb.zetter.client.gui.easel.AbstractPaintingWidget;
import me.dantaeusb.zetter.client.gui.easel.SliderWidget;
import me.dantaeusb.zetter.core.tools.Color;
import me.dantaeusb.zetter.menu.EaselMenu;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class HsbWidget
extends AbstractPaintingWidget
implements Widget {
    static final int SLIDER_DISTANCE = 5;
    static final int WIDTH = 162;
    static final int HEIGHT = 37;
    private final SliderWidget hueSlider;
    private final SliderWidget saturationSlider;
    private final SliderWidget brightnessSlider;
    private final List<SliderWidget> sliders = new ArrayList<SliderWidget>();

    public HsbWidget(EaselScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 162, 37, (Component)Component.m_237115_((String)"container.zetter.painting.sliders"));
        int sliderOffset = 12;
        this.hueSlider = new SliderWidget(parentScreen, x + 12, y, (Component)Component.m_237115_((String)"container.zetter.painting.sliders.hue"), this::updateHue, null, this::renderHueForeground);
        this.saturationSlider = new SliderWidget(parentScreen, x + 12, y + 9 + 5, (Component)Component.m_237115_((String)"container.zetter.painting.sliders.saturation"), this::updateSaturation, null, this::renderSaturationForeground);
        this.brightnessSlider = new SliderWidget(parentScreen, x + 12, y + 28, (Component)Component.m_237115_((String)"container.zetter.painting.sliders.brightness"), this::updateBrightness, null, this::renderBrightnessForeground);
        this.sliders.add(this.hueSlider);
        this.sliders.add(this.saturationSlider);
        this.sliders.add(this.brightnessSlider);
    }

    public void updateColor(int color) {
        Color newColor = new Color(color);
        float[] hsb = newColor.toHSB();
        this.hueSlider.setSliderState(hsb[0]);
        this.saturationSlider.setSliderState(hsb[1]);
        this.brightnessSlider.setSliderState(hsb[2]);
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean result = this.hueSlider.m_6375_(mouseX, mouseY, button) || this.saturationSlider.m_6375_(mouseX, mouseY, button) || this.brightnessSlider.m_6375_(mouseX, mouseY, button);
        this.m_93692_(result);
        return result;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.hueSlider.m_7979_(mouseX, mouseY, button, dragX, dragY);
        this.saturationSlider.m_7979_(mouseX, mouseY, button, dragX, dragY);
        this.brightnessSlider.m_7979_(mouseX, mouseY, button, dragX, dragY);
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.hueSlider.m_6348_(mouseX, mouseY, button);
        this.saturationSlider.m_6348_(mouseX, mouseY, button);
        this.brightnessSlider.m_6348_(mouseX, mouseY, button);
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void render(PoseStack matrixStack) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractPaintingWidget.PAINTING_WIDGETS_RESOURCE);
        for (SliderWidget slider : this.sliders) {
            slider.render(matrixStack);
        }
    }

    @Override
    public void renderLabels(PoseStack matrixStack, int posX, int posY) {
        int i = 0;
        for (SliderWidget slider : this.sliders) {
            this.parentScreen.getFont().m_92883_(matrixStack, slider.m_6035_().getString().substring(0, 1).concat("."), (float)(this.f_93620_ - this.parentScreen.getGuiLeft()), (float)(this.f_93621_ + 14 * i++ - this.parentScreen.getGuiTop() + 1), Color.DARK_GRAY.getRGB());
        }
    }

    public void updateSlidersWithCurrentColor() {
        Color currentColor = new Color(((EaselMenu)this.parentScreen.m_6262_()).getCurrentColor());
        float[] currentColorHSB = currentColor.toHSB();
    }

    public int renderHueForeground(float percent) {
        return Color.HSBtoRGB(percent, 1.0f, 1.0f);
    }

    public void updateHue(float percent) {
        this.pushColorUpdate();
    }

    public int renderSaturationForeground(float percent) {
        return Color.HSBtoRGB(this.hueSlider.getSliderState(), percent, 1.0f);
    }

    public void updateSaturation(float percent) {
        this.pushColorUpdate();
    }

    public int renderBrightnessForeground(float percent) {
        return Color.HSBtoRGB(this.hueSlider.getSliderState(), this.saturationSlider.getSliderState(), percent);
    }

    public void updateBrightness(float percent) {
        this.pushColorUpdate();
    }

    public void pushColorUpdate() {
        float hue = this.hueSlider.getSliderState();
        float saturation = this.saturationSlider.getSliderState();
        float brightness = this.brightnessSlider.getSliderState();
        ((EaselMenu)this.parentScreen.m_6262_()).setPaletteColor(Color.HSBtoRGB(hue, saturation, brightness));
    }
}

