/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.easel;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.client.gui.EaselScreen;
import me.dantaeusb.zetter.client.gui.easel.AbstractPaintingWidget;
import me.dantaeusb.zetter.menu.EaselMenu;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class PaletteWidget
extends AbstractPaintingWidget
implements Widget {
    static final int PALETTE_SCALE_FACTOR = 10;
    static final int PALETTE_OFFSET = 11;
    static final int PALETTE_COLS = 2;
    static final int WIDTH = 21;
    static final int HEIGHT = 10 + EaselMenu.PALETTE_SLOTS / 2 * 11;
    public static final int SWAP_HOTKEY = 88;

    public PaletteWidget(EaselScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 21, HEIGHT, (Component)Component.m_237115_((String)"container.zetter.painting.palette"));
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int iMouseX = (int)mouseX;
        int iMouseY = (int)mouseY;
        int slotIndex = -1;
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        for (int i = 0; i < EaselMenu.PALETTE_SLOTS; ++i) {
            int slotX = this.f_93620_ + i % 2 * 11;
            int slotY = this.f_93621_ + i / 2 * 11;
            if (!EaselScreen.isInRect(slotX, slotY, 10, 10, iMouseX, iMouseY) || !this.m_7972_(button)) continue;
            slotIndex = i;
            break;
        }
        if (slotIndex == -1) {
            return false;
        }
        ((EaselMenu)this.parentScreen.m_6262_()).setCurrentPaletteSlot(slotIndex);
        return true;
    }

    public void render(PoseStack matrixStack) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractPaintingWidget.PAINTING_WIDGETS_RESOURCE);
        this.drawPalette(matrixStack);
        this.drawPaletteSelector(matrixStack, ((EaselMenu)this.parentScreen.m_6262_()).getCurrentPaletteSlot());
    }

    protected void drawPalette(PoseStack matrixStack) {
        if (!((EaselMenu)this.parentScreen.m_6262_()).isPaletteAvailable()) {
            return;
        }
        for (int i = 0; i < EaselMenu.PALETTE_SLOTS; ++i) {
            int fromX = this.f_93620_ + i % 2 * 11;
            int fromY = this.f_93621_ + i / 2 * 11;
            int color = ((EaselMenu)this.parentScreen.m_6262_()).getPaletteColor(i);
            PaletteWidget.m_93172_((PoseStack)matrixStack, (int)fromX, (int)fromY, (int)(fromX + 10), (int)(fromY + 10), (int)color);
        }
    }

    protected void drawPaletteSelector(PoseStack matrixStack, int currentPaletteSlot) {
        if (!((EaselMenu)this.parentScreen.m_6262_()).isPaletteAvailable()) {
            return;
        }
        int SELECTOR_POSITION_U = 82;
        boolean SELECTOR_POSITION_V = false;
        int PALETTE_BORDER = 3;
        int selectorPositionX = this.f_93620_ + (currentPaletteSlot % 2 != 0 ? 11 : 0) - 3;
        int selectorPositionY = this.f_93621_ + currentPaletteSlot / 2 * 11 - 3;
        this.m_93228_(matrixStack, selectorPositionX, selectorPositionY, 82, 0, 16, 16);
    }
}

