/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.easel;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.client.gui.EaselScreen;
import me.dantaeusb.zetter.client.gui.easel.AbstractPaintingWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SliderWidget
extends AbstractPaintingWidget
implements Widget {
    static final int WIDTH = 150;
    static final int HEIGHT = 9;
    private float sliderState = 0.0f;
    private boolean sliderDragging = false;
    private BackgroundConsumer backgroundLambda;
    private ForegroundColorFunction foregroundLambda;
    private Consumer<Float> positionConsumer;

    public SliderWidget(EaselScreen parentScreen, int x, int y, Component translatableComponent, Consumer<Float> positionConsumer, @Nullable BackgroundConsumer backgroundLambda, @Nullable ForegroundColorFunction foregroundLambda) {
        super(parentScreen, x, y, 150, 9, translatableComponent);
        this.backgroundLambda = backgroundLambda;
        this.foregroundLambda = foregroundLambda;
        this.positionConsumer = positionConsumer;
    }

    public float getSliderState() {
        return this.sliderState;
    }

    public void setSliderState(float percent) {
        this.sliderState = percent;
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int iMouseX = (int)mouseX;
        int iMouseY = (int)mouseY;
        if (this.m_5953_(mouseX, mouseY)) {
            this.handleSliderInteraction(iMouseX, iMouseY);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.sliderDragging) {
            int iMouseX = (int)mouseX;
            int iMouseY = (int)mouseY;
            this.handleSliderInteraction(iMouseX, iMouseY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.sliderDragging) {
            // empty if block
        }
        this.sliderDragging = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void render(PoseStack matrixStack) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractPaintingWidget.PAINTING_WIDGETS_RESOURCE);
        this.drawSliderBackground(matrixStack);
        this.drawSliderForeground(matrixStack);
        this.drawHandler(matrixStack);
    }

    protected void drawSliderBackground(PoseStack matrixStack) {
        int SLIDER_POSITION_U = 5;
        int SLIDER_POSITION_V = 80;
        int sliderV = 80;
        if (this.sliderDragging) {
            sliderV += 9;
        }
        this.m_93228_(matrixStack, this.f_93620_, this.f_93621_, 5, sliderV, 150, 9);
    }

    protected void drawSliderForeground(PoseStack matrixStack) {
        int sliderContentGlobalLeft = this.f_93620_ + 3;
        int sliderContentGlobalTop = this.f_93621_ + 3;
        int sliderContentWidth = 144;
        int sliderContentHeight = 3;
        if (this.sliderDragging) {
            sliderContentGlobalTop -= 2;
            sliderContentHeight += 4;
            if (this.backgroundLambda != null) {
                this.backgroundLambda.accept(matrixStack, sliderContentGlobalLeft, sliderContentGlobalTop, sliderContentWidth, sliderContentHeight);
            }
        } else if (this.backgroundLambda != null) {
            this.backgroundLambda.accept(matrixStack, sliderContentGlobalLeft, sliderContentGlobalTop, sliderContentWidth, sliderContentHeight);
        }
        for (int i = 0; i < sliderContentWidth; ++i) {
            int color = this.foregroundLambda.accept((float)i / (float)sliderContentWidth);
            SliderWidget.m_93172_((PoseStack)matrixStack, (int)(sliderContentGlobalLeft + i), (int)sliderContentGlobalTop, (int)(sliderContentGlobalLeft + i + 1), (int)(sliderContentGlobalTop + sliderContentHeight), (int)color);
        }
    }

    protected void handleSliderInteraction(int mouseX, int mouseY) {
        this.sliderDragging = true;
        float percent = (float)(mouseX - this.f_93620_ - 3) / 143.0f;
        this.sliderState = percent = Mth.m_14036_((float)percent, (float)0.0f, (float)1.0f);
        this.positionConsumer.accept(Float.valueOf(percent));
    }

    protected void drawHandler(PoseStack matrixStack) {
        boolean HANDLER_POSITION_U = false;
        int HANDLER_POSITION_V = 79;
        int HANDLER_WIDTH = 5;
        int HANDLER_HEIGHT = 11;
        int sliderContentWidth = 143;
        int sliderGlobalLeft = this.f_93620_ + (int)((float)sliderContentWidth * this.sliderState) + 3 - 2;
        int sliderGlobalTop = this.f_93621_ - 1;
        int sliderV = 79;
        if (this.sliderDragging) {
            sliderV += 11;
        }
        this.m_93228_(matrixStack, sliderGlobalLeft, sliderGlobalTop, 0, sliderV, 5, 11);
    }

    @FunctionalInterface
    public static interface BackgroundConsumer {
        public void accept(PoseStack var1, int var2, int var3, int var4, int var5);
    }

    @FunctionalInterface
    public static interface ForegroundColorFunction {
        public int accept(float var1);
    }
}

