/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.renderer.entity;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.List;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.capability.canvastracker.CanvasTracker;
import me.dantaeusb.zetter.client.model.EaselModel;
import me.dantaeusb.zetter.client.renderer.CanvasRenderer;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.entity.item.EaselEntity;
import me.dantaeusb.zetter.storage.CanvasData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class EaselRenderer
extends EntityRenderer<EaselEntity> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("zetter", "textures/entity/easel.png");
    public static final ResourceLocation CANVAS_TEXTURE = new ResourceLocation("zetter", "textures/entity/canvas.png");
    protected EaselModel model;
    protected final List<RenderLayer<EaselEntity, EntityModel<EaselEntity>>> layers = Lists.newArrayList();
    protected int canvasRequestTimeout = 0;

    public EaselRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new EaselModel(context.m_174023_(EaselModel.EASEL_BODY_LAYER));
    }

    public final boolean addLayer(RenderLayer<EaselEntity, EntityModel<EaselEntity>> layer) {
        return this.layers.add(layer);
    }

    public void render(EaselEntity easelEntity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Minecraft minecraft = Minecraft.m_91087_();
        VertexConsumer vertexBuilder = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)TEXTURE));
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entityYaw));
        this.model.m_7695_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (easelEntity.hasCanvas()) {
            CanvasData canvasData = EaselRenderer.getCanvasData(easelEntity.f_19853_, easelEntity.getEntityCanvasCode());
            if (canvasData != null) {
                this.renderCanvas(easelEntity, canvasData, partialTicks, poseStack, buffer, packedLight);
            } else {
                CanvasRenderer.getInstance().queueCanvasTextureUpdate(easelEntity.getEntityCanvasCode());
            }
        }
        poseStack.m_85849_();
    }

    private void renderCanvas(EaselEntity easelEntity, CanvasData canvasData, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        float scaleFactor = 0.0625f;
        int canvasBlockWidth = canvasData.getWidth() / canvasData.getResolution().getNumeric();
        int canvasBlockHeight = canvasData.getHeight() / canvasData.getResolution().getNumeric();
        poseStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        poseStack.m_85837_(-8.0, 12.5, -4.0);
        poseStack.m_85845_(Vector3f.f_122223_.m_122270_(0.1745f));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        poseStack.m_85837_(-8.0 - 8.0 * (double)canvasBlockWidth, -16.0 * (double)canvasBlockHeight, 0.0);
        CanvasRenderer.getInstance().renderCanvas(poseStack, buffer, easelEntity.getEntityCanvasCode(), canvasData, packedLight);
        RenderType renderType = RenderType.m_110497_((ResourceLocation)CANVAS_TEXTURE);
        VertexConsumer vertexConsumer = buffer.m_6299_(renderType);
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        this.renderBack(matrix4f, vertexConsumer, canvasBlockWidth, canvasBlockHeight, packedLight);
        this.renderSidesH(matrix4f, vertexConsumer, canvasBlockWidth, canvasBlockHeight, packedLight);
        this.renderSidesV(matrix4f, vertexConsumer, canvasBlockWidth, canvasBlockHeight, packedLight);
    }

    private void renderBack(Matrix4f matrix4f, VertexConsumer vertexConsumer, int canvasBlockWidth, int canvasBlockHeight, int packedLight) {
        for (int x = 0; x < canvasBlockWidth; ++x) {
            for (int y = 0; y < canvasBlockHeight; ++y) {
                float[] uv = this.getUV(x, y, canvasBlockWidth, canvasBlockHeight, Direction.SOUTH);
                this.renderFace(matrix4f, vertexConsumer, (float)x * 16.0f + 16.0f, (float)x * 16.0f, (float)y * 16.0f + 16.0f, (float)y * 16.0f, 1.0f, 1.0f, 1.0f, 1.0f, uv[1], uv[0], uv[2], uv[3], packedLight);
            }
        }
    }

    private void renderSidesH(Matrix4f matrix4f, VertexConsumer vertexConsumer, int canvasBlockWidth, int canvasBlockHeight, int packedLight) {
        float canvasPixelWidth = (float)canvasBlockWidth * 16.0f;
        for (int y = 0; y < canvasBlockHeight; ++y) {
            float[] uvLeft = this.getUV(0, y, canvasBlockWidth, canvasBlockHeight, Direction.EAST);
            this.renderFace(matrix4f, vertexConsumer, 0.0f, 0.0f, (float)y * 16.0f + 16.0f, (float)y * 16.0f, 1.0f, 0.0f, 0.0f, 1.0f, uvLeft[0], uvLeft[1], uvLeft[2], uvLeft[3], packedLight);
            float[] uvRight = this.getUV(canvasBlockWidth - 1, y, canvasBlockWidth, canvasBlockHeight, Direction.WEST);
            this.renderFace(matrix4f, vertexConsumer, canvasPixelWidth, canvasPixelWidth, (float)y * 16.0f + 16.0f, (float)y * 16.0f, 0.0f, 1.0f, 1.0f, 0.0f, uvRight[0], uvRight[1], uvRight[2], uvRight[3], packedLight);
        }
    }

    private void renderSidesV(Matrix4f matrix4f, VertexConsumer vertexConsumer, int canvasBlockWidth, int canvasBlockHeight, int packedLight) {
        float canvasPixelHeight = (float)canvasBlockHeight * 16.0f;
        for (int x = 0; x < canvasBlockWidth; ++x) {
            float[] uvTop = this.getUV(x, 0, canvasBlockWidth, canvasBlockHeight, Direction.UP);
            this.renderFace(matrix4f, vertexConsumer, (float)x * 16.0f, (float)x * 16.0f + 16.0f, canvasPixelHeight, canvasPixelHeight, 1.0f, 1.0f, 0.0f, 0.0f, uvTop[0], uvTop[1], uvTop[2], uvTop[3], packedLight);
            float[] uvBottom = this.getUV(x, canvasBlockHeight - 1, canvasBlockWidth, canvasBlockHeight, Direction.DOWN);
            this.renderFace(matrix4f, vertexConsumer, (float)x * 16.0f, (float)x * 16.0f + 16.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, uvBottom[0], uvBottom[1], uvBottom[2], uvBottom[3], packedLight);
        }
    }

    private void renderFace(Matrix4f matrix4f, VertexConsumer vertexConsumer, float x0, float x1, float y0, float y1, float z0, float z1, float z2, float z3, float u0, float u1, float v0, float v1, int packedLight) {
        vertexConsumer.m_85982_(matrix4f, x0, y0, z0).m_6122_(255, 255, 255, 255).m_7421_(u0, v1).m_85969_(packedLight).m_5752_();
        vertexConsumer.m_85982_(matrix4f, x1, y0, z1).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_85969_(packedLight).m_5752_();
        vertexConsumer.m_85982_(matrix4f, x1, y1, z2).m_6122_(255, 255, 255, 255).m_7421_(u1, v0).m_85969_(packedLight).m_5752_();
        vertexConsumer.m_85982_(matrix4f, x0, y1, z3).m_6122_(255, 255, 255, 255).m_7421_(u0, v0).m_85969_(packedLight).m_5752_();
    }

    private float[] getUV(int x, int y, int width, int height, Direction direction) {
        float textureWidth = 64.0f;
        float textureHeight = 64.0f;
        int uBlock = 0;
        int vBlock = 0;
        if (width > 1) {
            uBlock = x == 0 ? 1 : (x == width - 1 ? 3 : 2);
            if (height > 1) {
                vBlock = y == 0 ? 1 : (y == height - 1 ? 3 : 2);
            }
        } else if (height > 1) {
            vBlock = y == 0 ? 1 : (y == height - 1 ? 3 : 2);
        }
        float uLength = 16.0f;
        float vLength = 16.0f;
        if (direction.m_122434_() == Direction.Axis.X) {
            uLength = 1.0f;
        }
        if (direction.m_122434_() == Direction.Axis.Y) {
            vLength = 1.0f;
        }
        float u0 = (float)uBlock * 16.0f;
        float v0 = (float)vBlock * 16.0f;
        if (direction.m_122421_() == Direction.AxisDirection.NEGATIVE) {
            if (direction.m_122434_() == Direction.Axis.X) {
                u0 = (float)(uBlock + 1) * 16.0f - uLength;
            }
            if (direction.m_122434_() == Direction.Axis.Y) {
                v0 = (float)(vBlock + 1) * 16.0f - vLength;
            }
        }
        float u1 = u0 + uLength;
        float v1 = v0 + vLength;
        return new float[]{u0 / 64.0f, u1 / 64.0f, v0 / 64.0f, v1 / 64.0f};
    }

    @Nullable
    public static CanvasData getCanvasData(Level world, String canvasName) {
        CanvasTracker canvasTracker = Helper.getLevelCanvasTracker(world);
        if (canvasTracker == null) {
            return null;
        }
        return (CanvasData)((Object)canvasTracker.getCanvasData(canvasName));
    }

    public ResourceLocation getTextureLocation(EaselEntity entity) {
        return TEXTURE;
    }
}

