/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.entity.item;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.core.ClientHelper;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ZetterEntities;
import me.dantaeusb.zetter.core.ZetterItems;
import me.dantaeusb.zetter.item.FrameItem;
import me.dantaeusb.zetter.storage.PaintingData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.Validate;

public class PaintingEntity
extends HangingEntity
implements IEntityAdditionalSpawnData {
    public static final String NBT_TAG_FACING = "Facing";
    public static final String NBT_TAG_BLOCK_SIZE = "BlockSize";
    public static final String NBT_TAG_MATERIAL = "Material";
    public static final String NBT_TAG_HAS_PLATE = "HasPlate";
    public static final String NBT_TAG_GENERATION = "Generation";
    protected String paintingCode;
    protected int blockWidth;
    protected int blockHeight;
    protected boolean hasPlate;
    protected int generation;
    protected Materials material;

    public PaintingEntity(EntityType<? extends PaintingEntity> type, Level world) {
        super(type, world);
    }

    public PaintingEntity(Level world, BlockPos pos, Direction facing, Materials material, boolean hasPlate, String canvasCode, int[] blockSize, int generation) {
        super((EntityType)ZetterEntities.FRAMED_PAINTING_ENTITY.get(), world, pos);
        this.material = material;
        this.hasPlate = hasPlate;
        this.paintingCode = canvasCode;
        this.blockWidth = blockSize[0];
        this.blockHeight = blockSize[1];
        this.generation = generation;
        this.m_6022_(facing);
    }

    public String getPaintingCode() {
        if (this.paintingCode == null) {
            return "zetter_fallback_canvas";
        }
        return this.paintingCode;
    }

    public int getBlockWidth() {
        return this.blockWidth;
    }

    public int getBlockHeight() {
        return this.blockHeight;
    }

    public Materials getMaterial() {
        return this.material;
    }

    public boolean hasPlate() {
        return this.hasPlate;
    }

    protected float m_6380_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.0f;
    }

    protected void m_6022_(Direction facingDirectionIn) {
        Validate.notNull((Object)facingDirectionIn);
        this.f_31699_ = facingDirectionIn;
        if (facingDirectionIn.m_122434_().m_122479_()) {
            this.m_146926_(0.0f);
            this.m_146922_(this.f_31699_.m_122416_() * 90);
        } else {
            this.m_146926_(-90 * facingDirectionIn.m_122421_().m_122540_());
            this.m_146922_(0.0f);
        }
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        this.m_7087_();
    }

    protected void m_7087_() {
        if (this.f_31699_ != null) {
            double xCenter = (double)this.f_31698_.m_123341_() + 0.5;
            double yCenter = (double)this.f_31698_.m_123342_() + 0.5;
            double zCenter = (double)this.f_31698_.m_123343_() + 0.5;
            double thicknessOffset = 0.46875;
            double hCenterOffset = this.offs(this.m_7076_());
            double vCenterOffset = this.offs(this.m_7068_());
            xCenter -= (double)this.f_31699_.m_122429_() * thicknessOffset;
            zCenter -= (double)this.f_31699_.m_122431_() * thicknessOffset;
            Direction direction = this.f_31699_.m_122428_();
            this.m_20343_(xCenter += hCenterOffset * (double)direction.m_122429_(), yCenter += vCenterOffset, zCenter += hCenterOffset * (double)direction.m_122431_());
            double xWidth = this.m_7076_();
            double yHeight = this.m_7068_();
            double zWidth = this.m_7076_();
            if (this.f_31699_.m_122434_() == Direction.Axis.Z) {
                zWidth = 1.0;
            } else {
                xWidth = 1.0;
            }
            xWidth = xWidth / 16.0 / 2.0;
            yHeight = yHeight / 16.0 / 2.0;
            zWidth = zWidth / 16.0 / 2.0;
            this.m_20011_(new AABB(xCenter - xWidth, yCenter - yHeight, zCenter - zWidth, xCenter + xWidth, yCenter + yHeight, zCenter + zWidth));
        }
    }

    private double offs(int pixelSize) {
        return pixelSize % (Helper.getResolution().getNumeric() * 2) == 0 ? 0.5 : 0.0;
    }

    public double[] getRenderOffset() {
        double xOffset = (double)this.blockWidth / 2.0;
        double yOffset = (double)this.blockHeight / 2.0;
        return new double[]{xOffset, yOffset};
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!this.hasPlate()) {
            return InteractionResult.PASS;
        }
        if (!player.m_20193_().m_5776_()) {
            return InteractionResult.CONSUME;
        }
        PaintingData paintingData = (PaintingData)((Object)Helper.getLevelCanvasTracker(this.f_19853_).getCanvasData(this.paintingCode));
        if (paintingData == null) {
            return InteractionResult.FAIL;
        }
        ClientHelper.showOverlay(paintingData);
        return InteractionResult.CONSUME;
    }

    public void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128344_(NBT_TAG_FACING, (byte)this.f_31699_.m_122416_());
        compoundTag.m_128359_("PaintingCode", this.paintingCode);
        compoundTag.m_128385_(NBT_TAG_BLOCK_SIZE, new int[]{this.blockWidth, this.blockHeight});
        compoundTag.m_128359_(NBT_TAG_MATERIAL, this.material.toString());
        compoundTag.m_128379_(NBT_TAG_HAS_PLATE, this.hasPlate);
        compoundTag.m_128405_(NBT_TAG_GENERATION, this.generation);
        super.m_7380_(compoundTag);
    }

    public void m_7378_(CompoundTag compound) {
        this.f_31699_ = Direction.m_122407_((int)compound.m_128445_(NBT_TAG_FACING));
        this.paintingCode = compound.m_128461_("PaintingCode");
        if (compound.m_128441_(NBT_TAG_BLOCK_SIZE)) {
            int[] blockSize = compound.m_128465_(NBT_TAG_BLOCK_SIZE);
            this.blockWidth = blockSize[0];
            this.blockHeight = blockSize[1];
        }
        this.material = compound.m_128441_(NBT_TAG_MATERIAL) ? Materials.fromString(compound.m_128461_(NBT_TAG_MATERIAL)) : Materials.OAK;
        this.hasPlate = compound.m_128441_(NBT_TAG_HAS_PLATE) ? compound.m_128471_(NBT_TAG_HAS_PLATE) : false;
        this.generation = compound.m_128441_(NBT_TAG_GENERATION) ? compound.m_128451_(NBT_TAG_GENERATION) : 0;
        super.m_7378_(compound);
        this.m_6022_(this.f_31699_);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.f_31698_);
        buffer.writeByte((int)((byte)this.f_31699_.m_122416_()));
        buffer.m_130072_(this.paintingCode, 64);
        buffer.writeInt(this.blockWidth);
        buffer.writeInt(this.blockHeight);
        buffer.m_130072_(this.material.toString(), 64);
        buffer.writeBoolean(this.hasPlate);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.f_31698_ = buffer.m_130135_();
        this.f_31699_ = Direction.m_122407_((int)buffer.readByte());
        this.paintingCode = buffer.m_130136_(64);
        this.blockWidth = buffer.readInt();
        this.blockHeight = buffer.readInt();
        this.material = Materials.fromString(buffer.m_130136_(64));
        this.hasPlate = buffer.readBoolean();
        this.m_6022_(this.f_31699_);
    }

    public int m_7076_() {
        return this.blockWidth * 16;
    }

    public int m_7068_() {
        return this.blockHeight * 16;
    }

    public boolean m_6783_(double distance) {
        double d0 = 16.0;
        return distance < (d0 = d0 * 64.0 * PaintingEntity.m_20150_()) * d0;
    }

    public void m_5553_(@Nullable Entity brokenEntity) {
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_5496_(SoundEvents.f_12175_, 1.0f, 1.0f);
            ItemStack canvasStack = new ItemStack((ItemLike)ZetterItems.FRAMES.get(Helper.getFrameKey(this.material, this.hasPlate)).get());
            PaintingData paintingData = (PaintingData)((Object)Helper.getLevelCanvasTracker(this.f_19853_).getCanvasData(this.paintingCode));
            FrameItem.storePaintingData(canvasStack, this.paintingCode, paintingData, this.generation);
            this.m_19983_(canvasStack);
        }
    }

    public void m_7678_(double x, double y, double z, float yaw, float pitch) {
        this.m_6034_(x, y, z);
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        BlockPos blockpos = this.f_31698_.m_7637_(x - this.m_20185_(), y - this.m_20186_(), z - this.m_20189_());
        this.m_6034_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_());
    }

    public void m_7084_() {
        this.m_5496_(SoundEvents.f_12176_, 1.0f, 1.0f);
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ZetterItems.FRAMES.get(Helper.getFrameKey(this.getMaterial(), this.hasPlate())).get());
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum Materials {
        ACACIA("acacia", true, true),
        BIRCH("birch", true, true),
        DARK_OAK("dark_oak", true, true),
        JUNGLE("jungle", true, true),
        OAK("oak", true, true),
        SPRUCE("spruce", true, true),
        CRIMSON("crimson", true, true),
        WARPED("warped", true, true),
        IRON("iron", false, false),
        GOLD("gold", true, true),
        MANGROVE("mangrove", true, true);

        private static final Map<String, Materials> LOOKUP;
        private final String text;
        private final boolean canvasOffset;
        private final boolean canHavePlate;

        private Materials(String text, boolean canvasOffset, boolean canHavePlate) {
            this.text = text;
            this.canvasOffset = canvasOffset;
            this.canHavePlate = canHavePlate;
        }

        public String toString() {
            return this.text;
        }

        public boolean hasOffset() {
            return this.canvasOffset;
        }

        public boolean canHavePlate() {
            return this.canHavePlate;
        }

        @Nullable
        public static Materials fromString(String stringValue) {
            return LOOKUP.get(stringValue);
        }

        static {
            LOOKUP = Maps.uniqueIndex(Arrays.asList(Materials.values()), Materials::toString);
        }
    }
}

