/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.entity.item.state;

import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.capability.canvastracker.CanvasServerTracker;
import me.dantaeusb.zetter.client.renderer.CanvasRenderer;
import me.dantaeusb.zetter.core.EaselStateListener;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ZetterNetwork;
import me.dantaeusb.zetter.entity.item.EaselEntity;
import me.dantaeusb.zetter.entity.item.state.representation.CanvasAction;
import me.dantaeusb.zetter.entity.item.state.representation.CanvasSnapshot;
import me.dantaeusb.zetter.item.CanvasItem;
import me.dantaeusb.zetter.network.packet.CCanvasActionPacket;
import me.dantaeusb.zetter.network.packet.CCanvasHistoryActionPacket;
import me.dantaeusb.zetter.network.packet.SCanvasHistoryActionPacket;
import me.dantaeusb.zetter.network.packet.SEaselCanvasInitializationPacket;
import me.dantaeusb.zetter.network.packet.SEaselResetPacket;
import me.dantaeusb.zetter.network.packet.SEaselStateSyncPacket;
import me.dantaeusb.zetter.painting.Tools;
import me.dantaeusb.zetter.painting.parameters.AbstractToolParameters;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;

public class EaselState {
    public static int SNAPSHOT_HISTORY_SIZE = 10;
    public static int ACTION_HISTORY_SIZE = 200;
    public static int FREEZE_TIMEOUT = 1800000;
    private final int MAX_ACTIONS_BEFORE_SNAPSHOT = ACTION_HISTORY_SIZE / SNAPSHOT_HISTORY_SIZE;
    public static int CLIENT_SNAPSHOT_HISTORY_SIZE = 50;
    private static int SYNC_INTERVAL = 1000;
    private static int TICK_INTERVAL = 50;
    private static long MAX_LATENCY = 500L;
    private static long PROCESSING_WINDOW = (long)SYNC_INTERVAL + MAX_LATENCY + 5000L;
    private static int SYNC_TICKS = SYNC_INTERVAL / TICK_INTERVAL;
    private final EaselEntity easel;
    private List<EaselStateListener> listeners;
    private boolean sync = false;
    private int tick;
    private boolean frozen = true;
    private long lastActivity = 0L;
    private final ArrayList<Player> players = new ArrayList();
    private final ArrayList<CanvasAction> actions = new ArrayList(ACTION_HISTORY_SIZE + (int)((float)ACTION_HISTORY_SIZE * 0.1f));
    @Nullable
    private CanvasAction currentClientAction = null;
    private final HashMap<UUID, Integer> playerLastSyncedAction = new HashMap();
    private final HashMap<UUID, Integer> playerLastSyncedSnapshot = new HashMap();
    private final ArrayList<CanvasSnapshot> snapshots;
    private boolean historyDirty = false;

    public EaselState(EaselEntity entity) {
        this.easel = entity;
        if (entity.m_9236_().m_5776_()) {
            this.snapshots = new ArrayList(CLIENT_SNAPSHOT_HISTORY_SIZE + 1);
        } else {
            this.snapshots = new ArrayList(SNAPSHOT_HISTORY_SIZE + 1);
            this.sync = true;
        }
    }

    public void addPlayer(Player player) {
        this.players.add(player);
        this.unfreeze();
        this.updateSnapshots();
        if (!this.easel.m_9236_().m_5776_() && this.getCanvasCode() != null) {
            this.performHistorySyncForServerPlayer(player);
        }
    }

    public void removePlayer(Player player) {
        this.players.remove(player);
        if (this.easel.m_9236_().m_5776_()) {
            this.freeze();
        } else {
            this.playerLastSyncedAction.remove(player.m_20148_());
            this.playerLastSyncedSnapshot.remove(player.m_20148_());
        }
    }

    public void addListener(EaselStateListener listener) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(EaselStateListener listener) {
        this.listeners.remove(listener);
    }

    public void reset(boolean sync) {
        if (this.easel.m_9236_().m_5776_()) {
            this.performHistorySyncClient(true);
        }
        this.actions.clear();
        this.snapshots.clear();
        this.playerLastSyncedAction.clear();
        this.playerLastSyncedSnapshot.clear();
        if (!this.easel.m_9236_().m_5776_() && sync && this.getCanvasData() != null) {
            SEaselResetPacket resetPacket = new SEaselResetPacket(this.easel.m_19879_());
            for (Player player : this.players) {
                ZetterNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)resetPacket);
            }
        }
        this.updateSnapshots();
        this.onStateChanged();
    }

    public void reset() {
        this.reset(true);
    }

    protected void freeze() {
        this.reset();
        this.frozen = true;
    }

    protected void unfreeze() {
        this.frozen = false;
        this.lastActivity = System.currentTimeMillis();
    }

    public void tick() {
        if (this.frozen) {
            return;
        }
        ++this.tick;
        if (this.players.isEmpty() && System.currentTimeMillis() - this.lastActivity > (long)FREEZE_TIMEOUT) {
            this.freeze();
        }
        if (this.easel.m_9236_().m_5776_()) {
            if (this.tick % SYNC_TICKS == 0) {
                this.performHistorySyncClient(false);
            }
        } else {
            if (this.players.size() == 0 || this.getCanvasCode() == null) {
                return;
            }
            if (this.tick % (SYNC_TICKS * 5) == 0) {
                this.updateSnapshots();
            }
            if (this.tick % SYNC_TICKS == 0) {
                this.performHistorySyncServer();
            }
        }
    }

    private CanvasData getCanvasData() {
        if (this.easel.getEaselContainer().getCanvas() == null) {
            return null;
        }
        return (CanvasData)((Object)this.easel.getEaselContainer().getCanvas().data);
    }

    private String getCanvasCode() {
        if (this.easel.getEaselContainer().getCanvas() == null) {
            return null;
        }
        return this.easel.getEaselContainer().getCanvas().code;
    }

    public void useTool(Player player, Tools tool, float posX, float posY, int color, AbstractToolParameters parameters) {
        CanvasAction.CanvasSubAction lastSubAction;
        ItemStack paletteStack = this.easel.getEaselContainer().getPaletteStack();
        if (paletteStack.m_41619_() || !player.m_7500_() && paletteStack.m_41773_() >= paletteStack.m_41776_() - 1) {
            return;
        }
        if (this.getCanvasData() == null) {
            return;
        }
        CanvasAction lastAction = this.getLastActionOfCanceledState(false);
        Float lastX = null;
        Float lastY = null;
        if (lastAction != null && lastAction.tool == tool && !lastAction.isCommitted() && (lastSubAction = lastAction.getLastAction()) != null) {
            lastX = Float.valueOf(lastSubAction.posX);
            lastY = Float.valueOf(lastSubAction.posY);
        }
        if (tool.getTool().shouldAddAction(this.getCanvasData(), parameters, posX, posY, lastX, lastY)) {
            this.wipeCanceledActionsAndDiscardSnapshots();
            this.cleanupActionHistory();
            if (tool.getTool().hasEffect()) {
                this.unfreeze();
                boolean initialized = this.isCanvasInitialized();
                if (initialized) {
                    int damage = tool.getTool().apply(this.getCanvasData(), parameters, color, posX, posY);
                    if (!player.m_7500_()) {
                        this.easel.getEaselContainer().damagePalette(damage);
                    }
                    CanvasRenderer.getInstance().updateCanvasTexture(this.getCanvasCode(), this.getCanvasData());
                }
                this.recordAction(player.m_20148_(), tool, color, parameters, posX, posY);
                if (!initialized) {
                    this.performHistorySyncClient(true);
                }
            } else {
                tool.getTool().apply(this.getCanvasData(), parameters, color, posX, posY);
            }
        }
    }

    private void wipeCanceledActionsAndDiscardSnapshots() {
        if (!this.historyDirty) {
            return;
        }
        ListIterator<CanvasAction> actionsIterator = this.getActionsEndIterator();
        CanvasAction firstRemovedAction = null;
        CanvasAction firstNonRemovedAction = null;
        while (actionsIterator.hasPrevious()) {
            CanvasAction action = actionsIterator.previous();
            if (action.isCanceled()) {
                firstRemovedAction = action;
                actionsIterator.remove();
                continue;
            }
            firstNonRemovedAction = action;
            break;
        }
        if (firstRemovedAction == null) {
            this.historyDirty = false;
            return;
        }
        if (!this.easel.m_9236_().m_5776_()) {
            if (firstNonRemovedAction != null) {
                List<UUID> playersNeedToUpdateLastSyncedAction = this.playerLastSyncedAction.entrySet().stream().filter(lastSyncedActionEntry -> this.actions.stream().noneMatch(canvasAction -> canvasAction.id == (Integer)lastSyncedActionEntry.getValue())).map(Map.Entry::getKey).toList();
                for (UUID playerUuid : playersNeedToUpdateLastSyncedAction) {
                    this.playerLastSyncedAction.put(playerUuid, firstNonRemovedAction.id);
                }
            } else {
                this.playerLastSyncedAction.clear();
            }
        }
        ListIterator<CanvasSnapshot> snapshotIterator = this.getSnapshotsEndIterator();
        CanvasSnapshot firstRemovedSnapshot = null;
        CanvasSnapshot firstNonRemovedSnapshot = null;
        while (snapshotIterator.hasPrevious()) {
            CanvasSnapshot snapshot = snapshotIterator.previous();
            if (snapshot.timestamp > firstRemovedAction.getStartTime()) {
                firstRemovedSnapshot = snapshot;
                snapshotIterator.remove();
                continue;
            }
            firstNonRemovedSnapshot = snapshot;
            break;
        }
        if (firstRemovedSnapshot == null) {
            this.historyDirty = false;
            return;
        }
        if (!this.easel.m_9236_().m_5776_()) {
            if (firstNonRemovedSnapshot != null) {
                List<UUID> playersNeedToUpdateLastSyncedSnapshot = this.playerLastSyncedSnapshot.entrySet().stream().filter(lastSyncedSnapshotEntry -> this.snapshots.stream().noneMatch(canvasAction -> canvasAction.id == (Integer)lastSyncedSnapshotEntry.getValue())).map(Map.Entry::getKey).toList();
                for (UUID playerUuid : playersNeedToUpdateLastSyncedSnapshot) {
                    this.playerLastSyncedSnapshot.put(playerUuid, firstNonRemovedSnapshot.id);
                }
            } else {
                Zetter.LOG.warn("Removed all snapshots, that should not be happening!");
                this.playerLastSyncedSnapshot.clear();
                this.makeSnapshot();
            }
        }
        this.historyDirty = false;
    }

    private void recordAction(UUID playerId, Tools tool, int color, AbstractToolParameters parameters, float posX, float posY) {
        if (this.currentClientAction == null || this.currentClientAction.isCommitted()) {
            this.currentClientAction = this.createAction(playerId, tool, color, parameters);
        } else if (!this.currentClientAction.canContinue(playerId, tool, color, parameters)) {
            this.currentClientAction.commit();
            this.currentClientAction = this.createAction(playerId, tool, color, parameters);
        }
        this.currentClientAction.addFrame(posX, posY);
    }

    private CanvasAction createAction(UUID playerId, Tools tool, int color, AbstractToolParameters parameters) {
        CanvasAction newAction;
        if (!tool.getTool().hasEffect()) {
            throw new IllegalStateException("Cannot create non-publishable action");
        }
        try {
            newAction = new CanvasAction(playerId, tool, color, parameters.clone());
            this.actions.add(newAction);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot copy parameters for action: " + e.getMessage());
        }
        this.onStateChanged();
        return newAction;
    }

    public boolean isCanvasInitialized() {
        ItemStack canvasStack = this.easel.getEaselContainer().getCanvasStack();
        if (canvasStack == null) {
            throw new IllegalStateException("Cannot check canvas initialization: no item in container");
        }
        String canvasCode = CanvasItem.getCanvasCode(canvasStack);
        return canvasCode != null;
    }

    public boolean initializeCanvas(long timestamp) {
        ItemStack canvasStack = this.easel.getEaselContainer().getCanvasStack();
        if (canvasStack == null) {
            throw new IllegalStateException("Cannot initialize canvas: no item in container");
        }
        String canvasCode = CanvasItem.getCanvasCode(canvasStack);
        if (canvasCode != null) {
            return false;
        }
        if (this.listeners != null) {
            for (EaselStateListener listener : this.listeners) {
                listener.stateCanvasInitializationStart(this);
            }
        }
        int resolution = CanvasItem.getResolution(canvasStack);
        int[] size = CanvasItem.getBlockSize(canvasStack);
        assert (size != null && size.length == 2);
        CanvasData canvasData = CanvasItem.createEmpty(canvasStack, AbstractCanvasData.Resolution.get(resolution), size[0], size[1], this.easel.m_9236_());
        canvasCode = CanvasItem.getCanvasCode(canvasStack);
        SEaselCanvasInitializationPacket initPacket = new SEaselCanvasInitializationPacket(this.easel.m_19879_(), canvasCode, canvasData, System.currentTimeMillis());
        for (Player player : this.easel.getPlayersUsing()) {
            ZetterNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)initPacket);
        }
        this.reset(false);
        this.snapshots.add(CanvasSnapshot.createServerSnapshot(canvasData.getColorData(), timestamp - MAX_LATENCY - 1L));
        if (this.listeners != null) {
            for (EaselStateListener listener : this.listeners) {
                listener.stateCanvasInitializationEnd(this);
            }
        }
        this.easel.getEaselContainer().handleCanvasChange(canvasCode);
        this.easel.getEaselContainer().changed();
        return true;
    }

    private boolean applyHistoryTraversing(CanvasAction tillAction, boolean cancel) {
        boolean changedState = false;
        if (cancel) {
            actionsIterator = this.getActionsEndIterator();
            while (actionsIterator.hasPrevious()) {
                currentAction = actionsIterator.previous();
                if (!currentAction.isCanceled()) {
                    currentAction.setCanceled(true);
                    changedState = true;
                }
                if (currentAction.id != tillAction.id) continue;
                break;
            }
        } else {
            actionsIterator = this.actions.listIterator();
            while (actionsIterator.hasNext()) {
                currentAction = actionsIterator.next();
                if (currentAction.isCanceled()) {
                    currentAction.setCanceled(false);
                    changedState = true;
                }
                if (currentAction.id != tillAction.id) continue;
                break;
            }
        }
        if (!changedState) {
            return false;
        }
        this.recollectPaintingData();
        this.onStateChanged();
        if (this.easel.m_9236_().m_5776_()) {
            if (tillAction.isSent()) {
                CCanvasHistoryActionPacket historyPacket = new CCanvasHistoryActionPacket(this.easel.m_19879_(), tillAction.id, cancel);
                ZetterNetwork.simpleChannel.sendToServer((Object)historyPacket);
            }
        } else {
            for (Player player : this.players) {
                if (!this.playerLastSyncedAction.containsKey(player.m_20148_())) continue;
                int lastSyncedActionUuid = this.playerLastSyncedAction.get(player.m_20148_());
                ListIterator<CanvasAction> actionsIterator = this.getActionsEndIterator();
                boolean found = false;
                while (actionsIterator.hasPrevious()) {
                    CanvasAction action = actionsIterator.previous();
                    if (lastSyncedActionUuid == tillAction.id) {
                        found = true;
                        break;
                    }
                    if (action.id != tillAction.id) continue;
                    break;
                }
                if (!found) continue;
                SCanvasHistoryActionPacket historyPacket = new SCanvasHistoryActionPacket(this.easel.m_19879_(), tillAction.id, cancel);
                ZetterNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)historyPacket);
            }
        }
        this.historyDirty = true;
        this.unfreeze();
        return true;
    }

    @Nullable
    private CanvasAction getLastActionOfCanceledState(boolean canceled) {
        return this.getLastActionOfCanceledState(canceled, null);
    }

    @Nullable
    private CanvasAction getLastActionOfCanceledState(boolean canceled, @Nullable UUID playerId) {
        return this.getActionOfCanceledState(canceled, true, playerId);
    }

    @Nullable
    private CanvasAction getFirstActionOfCanceledState(boolean canceled) {
        return this.getFirstActionOfCanceledState(canceled, null);
    }

    @Nullable
    private CanvasAction getFirstActionOfCanceledState(boolean canceled, @Nullable UUID playerId) {
        return this.getActionOfCanceledState(canceled, false, playerId);
    }

    @Nullable
    private CanvasAction getActionOfCanceledState(boolean canceled, boolean fromEnd, @Nullable UUID playerId) {
        CanvasAction stateAction = null;
        if (fromEnd) {
            ListIterator<CanvasAction> actionsIterator = this.getActionsEndIterator();
            while (actionsIterator.hasPrevious()) {
                CanvasAction currentAction = actionsIterator.previous();
                boolean differentPlayer = playerId != null && currentAction.getAuthorUUID() != null && !currentAction.getAuthorUUID().equals(playerId);
                if (differentPlayer || currentAction.isCanceled() != canceled) continue;
                stateAction = currentAction;
                break;
            }
        } else {
            ListIterator<CanvasAction> actionsIterator = this.actions.listIterator();
            while (actionsIterator.hasNext()) {
                CanvasAction currentAction = actionsIterator.next();
                boolean differentPlayer = playerId != null && currentAction.getAuthorUUID() != null && !currentAction.getAuthorUUID().equals(playerId);
                if (differentPlayer || currentAction.isCanceled() != canceled) continue;
                stateAction = currentAction;
                break;
            }
        }
        return stateAction;
    }

    public boolean canUndo() {
        return this.getLastActionOfCanceledState(false) != null;
    }

    public boolean canRedo() {
        return this.getLastActionOfCanceledState(true) != null;
    }

    public boolean undo() {
        CanvasAction lastNonCanceledAction = this.getLastActionOfCanceledState(false);
        if (lastNonCanceledAction == null) {
            return false;
        }
        return this.undo(lastNonCanceledAction);
    }

    public boolean undo(int tillActionId) {
        CanvasAction tillAction = this.findAction(tillActionId);
        if (tillAction != null) {
            return this.undo(tillAction);
        }
        return false;
    }

    public boolean undo(CanvasAction tillAction) {
        return this.applyHistoryTraversing(tillAction, true);
    }

    public boolean redo() {
        CanvasAction firstCanceledAction = this.getFirstActionOfCanceledState(true);
        if (firstCanceledAction == null) {
            return false;
        }
        return this.redo(firstCanceledAction);
    }

    public boolean redo(int tillActionUuid) {
        CanvasAction tillAction = this.findAction(tillActionUuid);
        if (tillAction != null) {
            return this.redo(tillAction);
        }
        return false;
    }

    public boolean redo(CanvasAction tillAction) {
        return this.applyHistoryTraversing(tillAction, false);
    }

    @Nullable
    private CanvasAction findAndReplaceAction(int actionId, CanvasAction action) {
        ListIterator<CanvasAction> actionsIterator = this.getActionsEndIterator();
        CanvasAction tillAction = null;
        while (actionsIterator.hasPrevious()) {
            CanvasAction currentAction = actionsIterator.previous();
            if (currentAction.id != actionId) continue;
            tillAction = currentAction;
            actionsIterator.set(action);
            break;
        }
        return tillAction;
    }

    @Nullable
    private CanvasAction findAction(int actionId) {
        ListIterator<CanvasAction> actionsIterator = this.getActionsEndIterator();
        CanvasAction tillAction = null;
        while (actionsIterator.hasPrevious()) {
            CanvasAction currentAction = actionsIterator.previous();
            if (currentAction.id != actionId) continue;
            tillAction = currentAction;
            break;
        }
        return tillAction;
    }

    public void recollectPaintingData(long timestamp) {
        CanvasAction firstCanceledAction = this.getFirstActionOfCanceledState(true);
        CanvasSnapshot latestSnapshot = firstCanceledAction != null ? this.getSnapshotBefore(Math.min(timestamp, firstCanceledAction.getStartTime())) : this.getSnapshotBefore(timestamp);
        if (latestSnapshot == null) {
            Zetter.LOG.error("Unable to find snapshot before first canceled action");
            return;
        }
        this.applySnapshot(latestSnapshot);
        ListIterator<CanvasAction> actionBufferIterator = this.getActionsEndIterator();
        boolean foundCanceled = firstCanceledAction == null;
        boolean foundLastBeforeSnapshot = false;
        while (actionBufferIterator.hasPrevious()) {
            CanvasAction action = actionBufferIterator.previous();
            if (!foundCanceled) {
                boolean bl = foundCanceled = action.id == firstCanceledAction.id;
            }
            if (!foundLastBeforeSnapshot) {
                boolean bl = foundLastBeforeSnapshot = action.isCommitted() && action.getCommitTime() < latestSnapshot.timestamp;
            }
            if ((!foundCanceled || !foundLastBeforeSnapshot) && actionBufferIterator.hasPrevious()) continue;
            while (actionBufferIterator.hasNext()) {
                action = actionBufferIterator.next();
                if (action.isCanceled() || action.isCommitted() && action.isSent() && action.getCommitTime() <= latestSnapshot.timestamp) continue;
                this.applyAction(action, false);
            }
            break block0;
        }
        if (this.easel.m_9236_().m_5776_()) {
            CanvasRenderer.getInstance().updateCanvasTexture(this.getCanvasCode(), this.getCanvasData());
        }
        this.markDesync();
    }

    public void recollectPaintingData() {
        this.recollectPaintingData(System.currentTimeMillis());
    }

    @Nullable
    protected CanvasSnapshot getSnapshotBefore(Long timestamp) {
        ListIterator<CanvasSnapshot> snapshotIterator = this.getSnapshotsEndIterator();
        while (snapshotIterator.hasPrevious()) {
            CanvasSnapshot snapshot = snapshotIterator.previous();
            if (snapshot.timestamp >= timestamp) continue;
            return snapshot;
        }
        return null;
    }

    protected void applySnapshot(CanvasSnapshot snapshot) {
        this.getCanvasData().updateColorData(snapshot.colors);
    }

    protected void updateSnapshots() {
        if (this.getCanvasData() == null) {
            return;
        }
        if (this.easel.m_9236_().m_5776_()) {
            if (this.snapshots.isEmpty()) {
                this.makeSnapshot();
            }
        } else if (this.needSnapshot()) {
            this.cleanupSnapshotHistory();
            this.makeSnapshot();
        }
    }

    private boolean needSnapshot() {
        CanvasAction paintingActionBuffer;
        if (this.snapshots.isEmpty()) {
            return true;
        }
        long authoritativeTimestamp = System.currentTimeMillis() - PROCESSING_WINDOW;
        CanvasSnapshot lastSnapshot = this.getLastSnapshot();
        assert (lastSnapshot != null);
        int actionsSinceSnapshot = 0;
        ListIterator<CanvasAction> actionsIterator = this.getActionsEndIterator();
        while (actionsIterator.hasPrevious() && (paintingActionBuffer = actionsIterator.previous()).getStartTime() >= lastSnapshot.timestamp) {
            if (paintingActionBuffer.getStartTime() > authoritativeTimestamp) continue;
            ++actionsSinceSnapshot;
        }
        return actionsSinceSnapshot >= this.MAX_ACTIONS_BEFORE_SNAPSHOT;
    }

    private void makeSnapshot() {
        assert (this.getCanvasData() != null);
        if (this.easel.m_9236_().m_5776_()) {
            this.snapshots.add(CanvasSnapshot.createWeakSnapshot(this.getCanvasData().getColorData(), System.currentTimeMillis()));
        } else if (this.snapshots.isEmpty()) {
            this.snapshots.add(CanvasSnapshot.createServerSnapshot(this.getCanvasData().getColorData(), System.currentTimeMillis()));
        } else {
            long authoritativeTimestamp = System.currentTimeMillis() - PROCESSING_WINDOW;
            this.recollectPaintingData(authoritativeTimestamp);
            this.snapshots.add(CanvasSnapshot.createServerSnapshot(this.getCanvasData().getColorData(), authoritativeTimestamp));
            this.recollectPaintingData();
        }
    }

    private void cleanupSnapshotHistory() {
        int maxSize = SNAPSHOT_HISTORY_SIZE;
        if (this.easel.f_19853_.f_46443_) {
            maxSize = CLIENT_SNAPSHOT_HISTORY_SIZE;
        }
        if (this.snapshots.size() > maxSize) {
            int i = 0;
            ListIterator<CanvasSnapshot> canvasSnapshotIterator = this.snapshots.listIterator();
            while (canvasSnapshotIterator.hasPrevious()) {
                canvasSnapshotIterator.previous();
                if (i++ <= maxSize - 1) continue;
                canvasSnapshotIterator.remove();
            }
        }
    }

    private void cleanupActionHistory() {
        int maxSize = ACTION_HISTORY_SIZE;
        if (this.actions.size() > maxSize) {
            int i = 0;
            ListIterator<CanvasAction> canvasActionIterator = this.getActionsEndIterator();
            while (canvasActionIterator.hasPrevious()) {
                canvasActionIterator.previous();
                if (i++ <= maxSize - 1) continue;
                canvasActionIterator.remove();
            }
        }
    }

    public void performHistorySyncClient(boolean forceCommit) {
        ArrayDeque<CanvasAction> unsentActions = new ArrayDeque<CanvasAction>();
        ListIterator<CanvasAction> actionsIterator = this.getActionsEndIterator();
        while (actionsIterator.hasPrevious()) {
            CanvasAction paintingActionBuffer = actionsIterator.previous();
            if (!paintingActionBuffer.isCommitted()) {
                if (!forceCommit && !paintingActionBuffer.shouldCommit()) continue;
                paintingActionBuffer.commit();
                this.onStateChanged();
            }
            if (paintingActionBuffer.isSent()) break;
            unsentActions.add(paintingActionBuffer);
        }
        if (!unsentActions.isEmpty()) {
            ArrayDeque<CanvasAction> unsentActionsInOrder = new ArrayDeque<CanvasAction>();
            Iterator descendingIterator = unsentActions.descendingIterator();
            while (descendingIterator.hasNext()) {
                unsentActionsInOrder.add((CanvasAction)descendingIterator.next());
            }
            CCanvasActionPacket paintingFrameBufferPacket = new CCanvasActionPacket(this.easel.m_19879_(), unsentActionsInOrder);
            ZetterNetwork.simpleChannel.sendToServer((Object)paintingFrameBufferPacket);
            for (CanvasAction unsentAction : unsentActions) {
                unsentAction.setSent();
            }
        }
    }

    public void performHistorySyncServer() {
        for (Player player : this.players) {
            this.performHistorySyncForServerPlayer(player);
        }
    }

    public void performHistorySyncForServerPlayer(Player player) {
        boolean hasUnsyncedSnapshot;
        if (this.getCanvasCode() == null) {
            Zetter.LOG.error("Trying to perform sync with unavailable canvas code");
            return;
        }
        ArrayList<CanvasAction> unsyncedActions = this.getUnsyncedActionsForPlayer(player);
        boolean hasUnsyncedActions = unsyncedActions != null && !unsyncedActions.isEmpty();
        CanvasSnapshot unsyncedSnapshot = this.getFirstUnsyncedSnapshotForPlayer(player);
        boolean bl = hasUnsyncedSnapshot = unsyncedSnapshot != null;
        if (!hasUnsyncedActions && !hasUnsyncedSnapshot) {
            return;
        }
        boolean actionsSync = !hasUnsyncedActions || unsyncedActions.get((int)(unsyncedActions.size() - 1)).id == this.getLastAction().id;
        boolean snapshotsSync = !hasUnsyncedSnapshot || unsyncedSnapshot.id == this.getLastSnapshot().id;
        SEaselStateSyncPacket syncMessage = new SEaselStateSyncPacket(this.easel.m_19879_(), this.getCanvasCode(), actionsSync && snapshotsSync, unsyncedSnapshot, unsyncedActions);
        ZetterNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)syncMessage);
        if (hasUnsyncedActions) {
            this.playerLastSyncedAction.put(player.m_20148_(), unsyncedActions.get((int)(unsyncedActions.size() - 1)).id);
        }
        if (hasUnsyncedSnapshot) {
            this.playerLastSyncedSnapshot.put(player.m_20148_(), unsyncedSnapshot.id);
        }
    }

    @Nullable
    private ArrayList<CanvasAction> getUnsyncedActionsForPlayer(Player player) {
        if (!this.playerLastSyncedAction.containsKey(player.m_20148_())) {
            return this.actions;
        }
        int lastSyncedActionId = this.playerLastSyncedAction.get(player.m_20148_());
        ListIterator<CanvasAction> actionBufferIterator = this.getActionsEndIterator();
        ArrayList<CanvasAction> unsyncedActions = new ArrayList<CanvasAction>();
        while (actionBufferIterator.hasPrevious()) {
            CanvasAction action = actionBufferIterator.previous();
            if (action.id != lastSyncedActionId) continue;
            while (actionBufferIterator.hasNext() && unsyncedActions.size() < 50) {
                action = actionBufferIterator.next();
                unsyncedActions.add(action);
            }
            break block0;
        }
        if (unsyncedActions.size() == 1 && unsyncedActions.get((int)0).id == lastSyncedActionId) {
            return null;
        }
        return unsyncedActions;
    }

    @Nullable
    private CanvasSnapshot getFirstUnsyncedSnapshotForPlayer(Player player) {
        if (this.snapshots.isEmpty()) {
            return null;
        }
        if (!this.playerLastSyncedSnapshot.containsKey(player.m_20148_())) {
            return this.snapshots.get(0);
        }
        int lastSyncedSnapshotId = this.playerLastSyncedSnapshot.get(player.m_20148_());
        ListIterator<CanvasSnapshot> snapshotIterator = this.snapshots.listIterator();
        boolean foundLastSynced = false;
        while (snapshotIterator.hasNext()) {
            CanvasSnapshot snapshot = snapshotIterator.next();
            if (foundLastSynced) {
                return snapshot;
            }
            if (snapshot.id != lastSyncedSnapshotId) continue;
            foundLastSynced = true;
        }
        return null;
    }

    public void processActionServer(Queue<CanvasAction> newActions) {
        if (this.easel.getCanvasStack().m_41619_()) {
            Zetter.LOG.warn("Got action buffer but no canvas found on easel");
            return;
        }
        if (!this.isCanvasInitialized()) {
            this.initializeCanvas(newActions.peek().getStartTime());
        }
        long processingAfterTimestamp = System.currentTimeMillis() - PROCESSING_WINDOW;
        this.wipeCanceledActionsAndDiscardSnapshots();
        Iterator newActionsIterator = newActions.iterator();
        ListIterator<CanvasAction> existingActionsIterator = this.actions.listIterator();
        CanvasAction newAction = (CanvasAction)newActionsIterator.next();
        while (existingActionsIterator.hasNext() && newAction != null) {
            CanvasAction existingAction = existingActionsIterator.next();
            if (newAction.getStartTime().equals(existingAction.getStartTime())) {
                Zetter.LOG.warn("Two actions have the same timestamp, weird!");
                if (newAction.id == existingAction.id) {
                    Zetter.LOG.warn("Got already synced action, ignoring");
                }
                existingActionsIterator.add(newAction);
                if (newAction.isCanceled()) {
                    this.historyDirty = true;
                }
                newAction = newActionsIterator.hasNext() ? (CanvasAction)newActionsIterator.next() : null;
                continue;
            }
            if (existingAction.getStartTime() <= newAction.getStartTime()) continue;
            if (newAction.getStartTime() < processingAfterTimestamp) {
                Zetter.LOG.warn("Got action that is too old, ignoring");
                newAction = newActionsIterator.hasNext() ? (CanvasAction)newActionsIterator.next() : null;
                continue;
            }
            existingActionsIterator.previous();
            existingActionsIterator.add(newAction);
            if (newAction.isCanceled()) {
                this.historyDirty = true;
            }
            existingActionsIterator.next();
            newAction = newActionsIterator.hasNext() ? (CanvasAction)newActionsIterator.next() : null;
        }
        if (newAction != null) {
            existingActionsIterator.add(newAction);
            if (newAction.isCanceled()) {
                this.historyDirty = true;
            }
        }
        while (newActionsIterator.hasNext()) {
            newAction = (CanvasAction)newActionsIterator.next();
            existingActionsIterator.add(newAction);
            if (!newAction.isCanceled()) continue;
            this.historyDirty = true;
        }
        this.unfreeze();
        this.cleanupActionHistory();
        this.recollectPaintingData();
        this.onStateChanged();
        this.markDesync();
    }

    public void applyAction(CanvasAction action, boolean doDamageClient) {
        boolean client = this.easel.m_9236_().m_5776_();
        action.getSubActionStream().forEach(subAction -> {
            Optional<Player> author;
            int damage = action.tool.getTool().apply(this.getCanvasData(), action.parameters, action.color, subAction.posX, subAction.posY);
            if (client) {
                if (doDamageClient) {
                    this.easel.getEaselContainer().damagePalette(damage);
                }
            } else if (!(action.isSync() || !(author = this.players.stream().filter(player -> player.m_20148_().equals(action.getAuthorUUID())).findFirst()).isEmpty() && author.get().m_7500_())) {
                this.easel.getEaselContainer().damagePalette(damage);
            }
        });
        if (!client) {
            action.setSync();
        }
        this.unfreeze();
    }

    public void processHistorySyncClient(String canvasCode, boolean sync, @Nullable CanvasSnapshot snapshot, @Nullable ArrayList<CanvasAction> actions) {
        if (!canvasCode.equals(this.getCanvasCode())) {
            Zetter.LOG.error("Different canvas code in history sync packet, ignoring");
            return;
        }
        if (snapshot != null) {
            if (this.getLastSnapshot() == null) {
                this.insertSnapshot(snapshot);
            } else if (this.getLastSnapshot().id != snapshot.id) {
                if (this.snapshots.size() >= SNAPSHOT_HISTORY_SIZE) {
                    this.snapshots.remove(0);
                }
                this.insertSnapshot(snapshot);
            }
        }
        if (actions == null || actions.isEmpty()) {
            this.sync = sync;
            this.recollectPaintingData();
            return;
        }
        Iterator<CanvasAction> unsyncedIterator = actions.iterator();
        ListIterator<CanvasAction> actionsIterator = this.actions.listIterator();
        CanvasAction clientAction = actionsIterator.hasNext() ? actionsIterator.next() : null;
        int fastForwards = 0;
        int addedActions = 0;
        do {
            CanvasAction unsyncedAction = unsyncedIterator.next();
            if (clientAction == null) {
                this.actions.add(unsyncedAction);
                ++addedActions;
                continue;
            }
            if (unsyncedAction.getStartTime() > clientAction.getStartTime()) {
                if (++fastForwards > 1) {
                    Zetter.LOG.warn("Fast-forwarding actions without mark sync! Some actions were lost?");
                }
                while (actionsIterator.hasNext()) {
                    clientAction = actionsIterator.next();
                    if (unsyncedAction.getStartTime() > clientAction.getStartTime()) continue;
                }
            }
            if (clientAction.id == unsyncedAction.id) {
                clientAction.setSync();
            } else {
                if (this.findAndReplaceAction(unsyncedAction.id, unsyncedAction) != null) {
                    Zetter.LOG.warn("Duplicating action! Replacing.");
                    clientAction = actionsIterator.hasNext() ? actionsIterator.next() : null;
                    continue;
                }
                if (unsyncedAction.isCanceled() && !clientAction.isCanceled()) {
                    Zetter.LOG.debug("Skipping received canceled action, as client has newer non-canceled action");
                    clientAction = actionsIterator.hasNext() ? actionsIterator.next() : null;
                    continue;
                }
                actionsIterator.previous();
                actionsIterator.add(unsyncedAction);
                ++addedActions;
            }
            CanvasAction canvasAction = clientAction = actionsIterator.hasNext() ? actionsIterator.next() : null;
        } while (unsyncedIterator.hasNext());
        this.unfreeze();
        if (addedActions > 0) {
            this.wipeCanceledActionsAndDiscardSnapshots();
            this.cleanupActionHistory();
        }
        this.sync = sync;
        this.recollectPaintingData();
        this.onStateChanged();
    }

    private void insertSnapshot(CanvasSnapshot addedSnapshot) {
        ListIterator<CanvasSnapshot> canvasSnapshotIterator = this.getSnapshotsEndIterator();
        while (canvasSnapshotIterator.hasPrevious()) {
            CanvasSnapshot currentSnapshot = canvasSnapshotIterator.previous();
            if (addedSnapshot.timestamp.equals(currentSnapshot.timestamp) && addedSnapshot.id == currentSnapshot.id) {
                Zetter.LOG.error("This snapshot already exists, ignoring");
                return;
            }
            if (addedSnapshot.timestamp <= currentSnapshot.timestamp) continue;
            canvasSnapshotIterator.next();
            canvasSnapshotIterator.add(addedSnapshot);
            this.cleanupSnapshotHistory();
            return;
        }
        canvasSnapshotIterator.add(addedSnapshot);
    }

    private void markDesync() {
        if (!this.easel.m_9236_().m_5776_()) {
            ((CanvasServerTracker)Helper.getLevelCanvasTracker(this.easel.m_9236_())).markCanvasDesync(this.getCanvasCode());
        }
    }

    protected void onStateChanged() {
        if (this.listeners != null) {
            for (EaselStateListener listener : this.listeners) {
                listener.stateChanged(this);
            }
        }
    }

    private ListIterator<CanvasAction> getActionsEndIterator() {
        if (this.actions.isEmpty()) {
            return this.actions.listIterator();
        }
        return this.actions.listIterator(this.actions.size());
    }

    @Nullable
    private CanvasAction getCurrentAction() {
        if (this.actions.isEmpty()) {
            return null;
        }
        return this.currentClientAction;
    }

    @Nullable
    private CanvasAction getLastAction() {
        if (this.actions.isEmpty()) {
            return null;
        }
        return this.actions.get(this.actions.size() - 1);
    }

    private ListIterator<CanvasSnapshot> getSnapshotsEndIterator() {
        if (this.snapshots.isEmpty()) {
            return this.snapshots.listIterator();
        }
        return this.snapshots.listIterator(this.snapshots.size());
    }

    @Nullable
    private CanvasSnapshot getLastSnapshot() {
        if (this.snapshots.isEmpty()) {
            return null;
        }
        return this.snapshots.get(this.snapshots.size() - 1);
    }

    private void logActions() {
        Zetter.LOG.debug("= Start actions =");
        this.actions.stream().forEach(action -> Zetter.LOG.debug(action.id + ": " + (action.isCommitted() ? (char)'M' : (char)'_') + (action.isCanceled() ? (char)'C' : (char)'_') + (action.isSent() ? (char)'S' : (char)'_') + (action.isSync() ? (char)'Y' : (char)'_')));
        Zetter.LOG.debug("= End actions =");
    }
}

