/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.menu;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.block.entity.container.ArtistTableGridContainer;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ItemStackHandlerListener;
import me.dantaeusb.zetter.core.ZetterContainerMenus;
import me.dantaeusb.zetter.core.ZetterItems;
import me.dantaeusb.zetter.core.ZetterNetwork;
import me.dantaeusb.zetter.menu.artisttable.AbstractCanvasAction;
import me.dantaeusb.zetter.menu.artisttable.CanvasCombinationAction;
import me.dantaeusb.zetter.menu.artisttable.CanvasSplitAction;
import me.dantaeusb.zetter.network.packet.CArtistTableModeChangePacket;
import me.dantaeusb.zetter.network.packet.SArtistTableMenuCreatePacket;
import me.dantaeusb.zetter.storage.CanvasData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ArtistTableMenu
extends AbstractContainerMenu
implements ItemStackHandlerListener,
ContainerListener {
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    public static final int CANVAS_ROW_COUNT = 4;
    public static final int CANVAS_COLUMN_COUNT = 4;
    public static final int CANVAS_SLOT_COUNT = 16;
    private final Player player;
    private final Level level;
    private final ArrayList<Slot> combinationSlots = new ArrayList(16);
    private final ArrayList<Slot> splitSlots = new ArrayList(16);
    private final Slot combinedSlot;
    private AbstractCanvasAction action;
    private final ContainerLevelAccess access;
    private final ArtistTableGridContainer combinationHandler;
    private final ItemStackHandler combinedHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            ArtistTableMenu.this.combinedSlotChanged(this);
            super.onContentsChanged(slot);
        }
    };
    private final ItemStackHandler splitHandler = new ItemStackHandler(16){

        protected void onContentsChanged(int slot) {
            ArtistTableMenu.this.splitSlotChanged(this);
            super.onContentsChanged(slot);
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.validateSlotIndex(slot);
            this.stacks.set(slot, (Object)stack);
            this.onContentsChanged(slot);
        }
    };
    private final ContainerData containerData;
    public static final int PLAYER_INVENTORY_XPOS = 36;
    public static final int PLAYER_INVENTORY_YPOS = 110;
    public static final int COMBINATION_SLOTS_COMBINE_X = 14;
    public static final int COMBINATION_SLOTS_COMBINE_Y = 20;
    public static final int COMBINATION_SLOTS_SPLIT_X = 144;
    public static final int COMBINATION_SLOTS_SPLIT_Y = 20;
    public static final int COMBINED_SLOT_X = 107;
    public static final int COMBINED_SLOT_Y = 67;
    final int SLOT_X_SPACING = 18;
    final int SLOT_Y_SPACING = 18;

    public ArtistTableMenu(int windowID, Inventory invPlayer, ArtistTableGridContainer artistTableContainer, ContainerData containerData, ContainerLevelAccess access) {
        super((MenuType)ZetterContainerMenus.ARTIST_TABLE.get(), windowID);
        int ypos;
        int xpos;
        int slotNumber;
        int x;
        int y;
        this.player = invPlayer.f_35978_;
        this.level = invPlayer.f_35978_.m_9236_();
        this.access = access;
        this.combinationHandler = artistTableContainer;
        this.combinationHandler.addListener(this);
        this.containerData = containerData;
        int HOTBAR_XPOS = 36;
        int HOTBAR_YPOS = 168;
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 4; ++x) {
                slotNumber = y * 4 + x;
                xpos = 14 + x * 18;
                ypos = 20 + y * 18;
                SlotCombinationGrid combinationSlot = new SlotCombinationGrid(this.combinationHandler, slotNumber, xpos, ypos);
                this.m_38897_((Slot)combinationSlot);
                this.combinationSlots.add((Slot)combinationSlot);
            }
        }
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 4; ++x) {
                slotNumber = y * 4 + x;
                xpos = 144 + x * 18;
                ypos = 20 + y * 18;
                SlotSplitGrid splitSlot = new SlotSplitGrid(this.splitHandler, slotNumber, xpos, ypos);
                this.m_38897_((Slot)splitSlot);
                this.splitSlots.add((Slot)splitSlot);
            }
        }
        SlotCombined combinedSlot = new SlotCombined(this.combinedHandler, 0, 107, 67);
        this.m_38897_((Slot)combinedSlot);
        this.combinedSlot = combinedSlot;
        for (int y2 = 0; y2 < 3; ++y2) {
            for (int x2 = 0; x2 < 9; ++x2) {
                int slotNumber2 = 9 + y2 * 9 + x2;
                int xpos2 = 36 + x2 * 18;
                int ypos2 = 110 + y2 * 18;
                this.m_38897_(new Slot((Container)invPlayer, slotNumber2, xpos2, ypos2));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)invPlayer, x, 36 + 18 * x, 168));
        }
        this.m_38884_(this.containerData);
        this.m_38893_(this);
        if (this.getMode() == Mode.COMBINE) {
            this.action = new CanvasCombinationAction(this, this.level);
        } else if (this.getMode() == Mode.SPLIT) {
            this.action = new CanvasSplitAction(this, this.level);
        }
    }

    public static ArtistTableMenu createMenuServerSide(int windowID, Inventory playerInventory, ArtistTableGridContainer artistTableContainer, ContainerData containerData, ContainerLevelAccess access) {
        return new ArtistTableMenu(windowID, playerInventory, artistTableContainer, containerData, access);
    }

    public static ArtistTableMenu createMenuClientSide(int windowID, Inventory playerInventory, FriendlyByteBuf networkBuffer) {
        SArtistTableMenuCreatePacket packet = SArtistTableMenuCreatePacket.readPacketData(networkBuffer);
        ArtistTableGridContainer artistTableContainer = new ArtistTableGridContainer();
        SimpleContainerData clientData = new SimpleContainerData(1);
        clientData.m_8050_(0, (int)packet.getMode().getId());
        return new ArtistTableMenu(windowID, playerInventory, artistTableContainer, (ContainerData)clientData, ContainerLevelAccess.f_39287_);
    }

    public ItemStackHandler getCombinationHandler() {
        return this.combinationHandler;
    }

    public ItemStackHandler getCombinedHandler() {
        return this.combinedHandler;
    }

    public ItemStackHandler getSplitHandler() {
        return this.splitHandler;
    }

    public Mode getMode() {
        return Mode.getById((byte)this.containerData.m_6413_(0));
    }

    public void setMode(Mode mode) {
        if (this.getMode().equals((Object)mode)) {
            return;
        }
        if (!this.canChangeMode()) {
            return;
        }
        this.m_7511_(0, mode.getId());
        if (this.player.m_9236_().m_5776_()) {
            CArtistTableModeChangePacket unloadPacket = new CArtistTableModeChangePacket(this.f_38840_, mode);
            ZetterNetwork.simpleChannel.sendToServer((Object)unloadPacket);
        }
    }

    public boolean canChangeMode() {
        if (this.getMode() == Mode.COMBINE) {
            return this.isCombinationGridEmpty();
        }
        return this.isCombinedSlotEmpty();
    }

    public boolean isCombinationGridEmpty() {
        for (Slot combinationSlot : this.combinationSlots) {
            if (!combinationSlot.m_6657_()) continue;
            return false;
        }
        return true;
    }

    public boolean isSplitGridEmpty() {
        for (Slot combinationSlot : this.splitSlots) {
            if (!combinationSlot.m_6657_()) continue;
            return false;
        }
        return true;
    }

    public boolean isCombinedSlotEmpty() {
        return !this.combinedSlot.m_6657_();
    }

    @Override
    public void containerChanged(ItemStackHandler container, int slot) {
        this.getAction().onChangedCombination(container);
    }

    public void combinedSlotChanged(ItemStackHandler combinedHandler) {
        this.getAction().onChangedCombined(combinedHandler);
    }

    public void splitSlotChanged(ItemStackHandler combinedHandler) {
        this.getAction().onChangedSplit(combinedHandler);
    }

    public AbstractCanvasAction getAction() {
        return this.action;
    }

    public AbstractCanvasAction.State getActionState() {
        return this.action.state;
    }

    public boolean handleCanvasSync(String canvasCode, CanvasData canvasData, long timestamp) {
        this.action.handleCanvasSync(canvasCode, canvasData, timestamp);
        return false;
    }

    public void m_7934_(AbstractContainerMenu containerMenu, int slotInd, ItemStack stack) {
    }

    public void m_142153_(AbstractContainerMenu containerMenu, int dataSlotIndex, int value) {
        if (dataSlotIndex == 0) {
            if (this.getMode() == Mode.COMBINE && !(this.action instanceof CanvasCombinationAction)) {
                if (this.action != null) {
                    this.action.discard(this.combinedHandler, this.splitHandler, this.player);
                }
                this.action = new CanvasCombinationAction(this, this.level);
            }
            if (this.getMode() == Mode.SPLIT && !(this.action instanceof CanvasSplitAction)) {
                if (this.action != null) {
                    this.action.discard(this.combinationHandler, this.combinedHandler, this.player);
                }
                this.action = new CanvasSplitAction(this, this.level);
            }
        }
    }

    public void m_7511_(int pId, int pData) {
        super.m_7511_(pId, pData);
        this.m_38946_();
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.combinationHandler.removeListener(this);
        if (this.getMode().equals((Object)Mode.SPLIT)) {
            this.action.discard(this.combinedHandler, this.splitHandler, player);
        } else {
            this.action.discard(this.combinationHandler, this.combinedHandler, player);
        }
        if (this.level.m_5776_()) {
            Helper.getLevelCanvasTracker(this.level).unregisterCanvasData("zetter_combined_canvas");
        }
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return super.m_5882_(stack, slotIn);
    }

    public ItemStack m_7648_(Player playerIn, int sourceSlotIndex) {
        int COMBINATION_SLOTS_TO = 16;
        int SPLIT_SLOTS_TO = 32;
        int COMBINED_SLOT_TO = 33;
        int INVENTORY_SLOTS_TO = 60;
        int HOTBAR_SLOTS_TO = 69;
        ItemStack outStack = ItemStack.f_41583_;
        Slot sourceSlot = (Slot)this.f_38839_.get(sourceSlotIndex);
        if (sourceSlot.m_6657_()) {
            ItemStack sourceStack = sourceSlot.m_7993_();
            outStack = sourceStack.m_41777_();
            if (sourceSlotIndex >= 0 && sourceSlotIndex < 33 && sourceStack.m_41720_().equals(ZetterItems.CANVAS.get())) {
                ((Slot)this.f_38839_.get(sourceSlotIndex)).m_142406_(playerIn, sourceStack);
                if (!this.m_38903_(sourceStack, 33, 69, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (this.getMode().equals((Object)Mode.COMBINE) && this.combinationSlots.get(0).m_5857_(sourceStack) ? !this.m_38903_(sourceStack, 0, 16, false) : (this.combinedSlot.m_5857_(sourceStack) ? !this.m_38903_(sourceStack, 32, 33, false) : (sourceSlotIndex >= 33 && sourceSlotIndex < 60 ? !this.m_38903_(sourceStack, 60, 69, false) : sourceSlotIndex >= 60 && sourceSlotIndex < 69 && !this.m_38903_(sourceStack, 33, 60, false)))) {
                return ItemStack.f_41583_;
            }
            if (sourceStack.m_41619_()) {
                sourceSlot.m_5852_(ItemStack.f_41583_);
            } else {
                sourceSlot.m_6654_();
            }
            if (sourceStack.m_41613_() == outStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            sourceSlot.m_142406_(playerIn, sourceStack);
        }
        return outStack;
    }

    public boolean m_6875_(Player player) {
        return this.combinationHandler.stillValid(player);
    }

    public Level getLevel() {
        return this.level;
    }

    public class SlotCombinationGrid
    extends SlotItemHandler {
        public SlotCombinationGrid(ItemStackHandler stackHandler, int index, int xPosition, int yPosition) {
            super((IItemHandler)stackHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return ArtistTableMenu.this.getMode().equals((Object)Mode.COMBINE) && ArtistTableMenu.this.combinationHandler.isItemValid(this.getSlotIndex(), stack);
        }

        public boolean m_6659_() {
            return ArtistTableMenu.this.getMode().equals((Object)Mode.COMBINE);
        }

        public void m_142406_(Player player, ItemStack stack) {
            ArtistTableMenu.this.getAction().onTakeCombination(player, stack);
        }
    }

    public class SlotSplitGrid
    extends SlotItemHandler {
        public SlotSplitGrid(ItemStackHandler stackHandler, int index, int xPosition, int yPosition) {
            super((IItemHandler)stackHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public boolean m_6659_() {
            return ArtistTableMenu.this.getMode().equals((Object)Mode.SPLIT);
        }

        public void m_142406_(Player player, ItemStack stack) {
            ArtistTableMenu.this.getAction().onTakeSplit(player, stack);
        }
    }

    public class SlotCombined
    extends SlotItemHandler {
        public SlotCombined(ItemStackHandler stackHandler, int index, int xPosition, int yPosition) {
            super((IItemHandler)stackHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return ArtistTableMenu.this.getAction().mayPlaceCombined(stack);
        }

        public void m_142406_(Player player, ItemStack stack) {
            ArtistTableMenu.this.getAction().onTakeCombined(player, stack);
        }
    }

    public static enum Mode {
        COMBINE(0),
        SPLIT(1);

        private final byte id;

        private Mode(int id) {
            this.id = (byte)id;
        }

        public byte getId() {
            return this.id;
        }

        @Nullable
        public static Mode getById(byte id) {
            for (Mode mode : Mode.values()) {
                if (mode.id != id) continue;
                return mode;
            }
            return null;
        }
    }
}

