/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.menu.artisttable;

import java.nio.ByteBuffer;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.capability.canvastracker.CanvasServerTracker;
import me.dantaeusb.zetter.capability.canvastracker.CanvasTracker;
import me.dantaeusb.zetter.client.renderer.CanvasRenderer;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ZetterCanvasTypes;
import me.dantaeusb.zetter.core.ZetterItems;
import me.dantaeusb.zetter.item.CanvasItem;
import me.dantaeusb.zetter.menu.ArtistTableMenu;
import me.dantaeusb.zetter.menu.artisttable.AbstractCanvasAction;
import me.dantaeusb.zetter.storage.CanvasData;
import me.dantaeusb.zetter.storage.CanvasDataType;
import me.dantaeusb.zetter.storage.DummyCanvasData;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemStackHandler;

public class CanvasCombinationAction
extends AbstractCanvasAction {
    public static final int[][] paintingShapes = new int[][]{{1, 1}, {1, 2}, {1, 3}, {2, 1}, {2, 2}, {2, 3}, {2, 4}, {3, 1}, {3, 2}, {3, 3}, {3, 4}, {4, 2}, {4, 3}, {4, 4}};
    public Rectangle rectangle;
    private boolean hasColorData = false;

    public CanvasCombinationAction(ArtistTableMenu menu, Level level) {
        super(menu, level);
        this.updateCanvasData(menu.getCombinationHandler());
    }

    public void updateCanvasData(ItemStackHandler combinationContainer) {
        Tuple min = null;
        Tuple max = null;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                if (combinationContainer.getStackInSlot(y * 4 + x) == ItemStack.f_41583_) continue;
                if (min == null) {
                    min = new Tuple((Object)x, (Object)y);
                }
                if (max == null) {
                    max = new Tuple((Object)x, (Object)y);
                    continue;
                }
                if ((Integer)max.m_14418_() < x) {
                    max = new Tuple((Object)x, (Object)((Integer)max.m_14419_()));
                }
                if ((Integer)max.m_14419_() >= y) continue;
                max = new Tuple((Object)((Integer)max.m_14418_()), (Object)y);
            }
        }
        if (min == null) {
            this.state = AbstractCanvasAction.State.EMPTY;
            this.rectangle = CanvasCombinationAction.getZeroRect();
            this.canvasData = null;
            return;
        }
        boolean canvasesReady = true;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                ItemStack currentStack = combinationContainer.getStackInSlot(y * 4 + x);
                if (currentStack == ItemStack.f_41583_) {
                    if (x < (Integer)min.m_14418_() || x > (Integer)max.m_14418_() || y < (Integer)min.m_14419_() || y > (Integer)max.m_14419_()) continue;
                    this.state = AbstractCanvasAction.State.INVALID;
                    this.rectangle = CanvasCombinationAction.getZeroRect();
                    this.canvasData = null;
                    return;
                }
                if (currentStack.m_41720_() != ZetterItems.CANVAS.get()) continue;
                if (x < (Integer)min.m_14418_() || x > (Integer)max.m_14418_() || y < (Integer)min.m_14419_() || y > (Integer)max.m_14419_()) {
                    this.state = AbstractCanvasAction.State.INVALID;
                    this.rectangle = CanvasCombinationAction.getZeroRect();
                    this.canvasData = null;
                    return;
                }
                if (!this.level.m_5776_() || CanvasItem.getCanvasCode(currentStack) == null || CanvasItem.getCanvasData(currentStack, this.level) != null) continue;
                CanvasRenderer.getInstance().queueCanvasTextureUpdate(CanvasItem.getCanvasCode(currentStack));
                canvasesReady = false;
            }
        }
        Rectangle rectangle = CanvasCombinationAction.getRect(min, max);
        if (rectangle.height == 1 && rectangle.width == 1) {
            this.state = AbstractCanvasAction.State.EMPTY;
            this.rectangle = CanvasCombinationAction.getZeroRect();
            this.canvasData = null;
            return;
        }
        if (!canvasesReady) {
            this.state = AbstractCanvasAction.State.NOT_LOADED;
            this.rectangle = CanvasCombinationAction.getZeroRect();
            this.canvasData = null;
            return;
        }
        boolean shapeAvailable = false;
        for (int[] shape : paintingShapes) {
            if (rectangle.width != shape[0] || rectangle.height != shape[1]) continue;
            shapeAvailable = true;
            break;
        }
        if (!shapeAvailable) {
            this.state = AbstractCanvasAction.State.INVALID;
            this.rectangle = CanvasCombinationAction.getZeroRect();
            this.canvasData = null;
            return;
        }
        this.state = AbstractCanvasAction.State.READY;
        this.rectangle = rectangle;
        this.canvasData = this.createCanvasData(combinationContainer, rectangle, this.level);
    }

    private DummyCanvasData createCanvasData(ItemStackHandler artistTableContainer, Rectangle rectangle, Level world) {
        int pixelWidth = rectangle.width * Helper.getResolution().getNumeric();
        int pixelHeight = rectangle.height * Helper.getResolution().getNumeric();
        this.hasColorData = false;
        for (int i = 0; i < artistTableContainer.getSlots(); ++i) {
            if (CanvasItem.getCanvasData(artistTableContainer.getStackInSlot(i), world) == null) continue;
            this.hasColorData = true;
            break;
        }
        if (!this.hasColorData) {
            int resolutionPixels = Helper.getResolution().getNumeric();
            byte[] color = new byte[rectangle.width * resolutionPixels * rectangle.height * resolutionPixels * 4];
            ByteBuffer defaultColorBuffer = ByteBuffer.wrap(color);
            for (int x = 0; x < rectangle.width * resolutionPixels * rectangle.height * resolutionPixels; ++x) {
                defaultColorBuffer.putInt(x * 4, -2041138);
            }
            DummyCanvasData combinedCanvasData = (DummyCanvasData)((Object)((CanvasDataType)ZetterCanvasTypes.DUMMY.get()).createWrap(Helper.getResolution(), rectangle.width * resolutionPixels, rectangle.height * resolutionPixels, color));
            if (world.m_5776_()) {
                Helper.getLevelCanvasTracker(world).registerCanvasData("zetter_combined_canvas", combinedCanvasData);
            }
            return combinedCanvasData;
        }
        ByteBuffer color = ByteBuffer.allocate(pixelWidth * pixelHeight * 4);
        for (int slotY = rectangle.y; slotY < rectangle.y + rectangle.height; ++slotY) {
            for (int slotX = rectangle.x; slotX < rectangle.x + rectangle.width; ++slotX) {
                int colorIndex;
                int bigY;
                int bigX;
                int smallX;
                int smallY;
                ItemStack canvasStack = artistTableContainer.getStackInSlot(slotY * 4 + slotX);
                CanvasData smallCanvasData = CanvasItem.getCanvasData(canvasStack, world);
                int relativeX = slotX - rectangle.x;
                int relativeY = slotY - rectangle.y;
                if (smallCanvasData != null) {
                    for (smallY = 0; smallY < smallCanvasData.getHeight(); ++smallY) {
                        for (smallX = 0; smallX < smallCanvasData.getWidth(); ++smallX) {
                            bigX = relativeX * Helper.getResolution().getNumeric() + smallX;
                            bigY = relativeY * Helper.getResolution().getNumeric() + smallY;
                            colorIndex = (bigY * pixelWidth + bigX) * 4;
                            color.putInt(colorIndex, smallCanvasData.getColorAt(smallX, smallY));
                        }
                    }
                    continue;
                }
                for (smallY = 0; smallY < Helper.getResolution().getNumeric(); ++smallY) {
                    for (smallX = 0; smallX < Helper.getResolution().getNumeric(); ++smallX) {
                        bigX = relativeX * Helper.getResolution().getNumeric() + smallX;
                        bigY = relativeY * Helper.getResolution().getNumeric() + smallY;
                        colorIndex = (bigY * pixelWidth + bigX) * 4;
                        color.putInt(colorIndex, -2041138);
                    }
                }
            }
        }
        DummyCanvasData combinedCanvasData = (DummyCanvasData)((Object)((CanvasDataType)ZetterCanvasTypes.DUMMY.get()).createWrap(Helper.getResolution(), pixelWidth, pixelHeight, color.array()));
        if (world.m_5776_()) {
            Helper.getLevelCanvasTracker(world).registerCanvasData("zetter_combined_canvas", combinedCanvasData);
        }
        return combinedCanvasData;
    }

    @Override
    public void onChangedCombination(ItemStackHandler container) {
        if (this.isInTransaction()) {
            return;
        }
        this.updateCanvasData(container);
        ItemStack combinedStack = this.menu.getCombinedHandler().getStackInSlot(0);
        if (this.isReady()) {
            if (combinedStack.m_41619_()) {
                combinedStack = new ItemStack((ItemLike)ZetterItems.CANVAS.get());
                CanvasItem.setBlockSize(combinedStack, this.rectangle.width, this.rectangle.height);
            }
        } else {
            combinedStack = ItemStack.f_41583_;
        }
        this.menu.getCombinedHandler().setStackInSlot(0, combinedStack);
    }

    @Override
    public void onTakeCombined(Player player, ItemStack stack) {
        if (this.canvasData == null || !this.isReady()) {
            Zetter.LOG.error("Cannot find combined canvas data");
            return;
        }
        this.startTransaction(player);
        if (!player.m_9236_().m_5776_()) {
            CanvasServerTracker canvasTracker = (CanvasServerTracker)Helper.getLevelCanvasTracker(player.m_9236_());
            if (this.hasColorData) {
                CanvasData combinedCanvasData = CanvasData.BUILDER.createWrap(this.canvasData.getResolution(), this.canvasData.getWidth(), this.canvasData.getHeight(), this.canvasData.getColorData());
                int newId = canvasTracker.getFreeCanvasId();
                String newCode = CanvasData.getCanvasCode(newId);
                canvasTracker.registerCanvasData(newCode, combinedCanvasData);
                CanvasItem.storeCanvasData(stack, newCode, combinedCanvasData);
            } else {
                CanvasItem.setBlockSize(stack, this.rectangle.width, this.rectangle.height);
            }
        }
        this.endTransaction(player);
    }

    @Override
    public void endTransaction(Player player) {
        CanvasTracker canvasTracker = Helper.getLevelCanvasTracker(player.m_9236_());
        for (int i = 0; i < this.menu.getCombinationHandler().getSlots(); ++i) {
            ItemStack combinationStack = this.menu.getCombinationHandler().extractItem(i, 64, false);
            if (combinationStack.m_41619_()) continue;
            String canvasCode = CanvasItem.getCanvasCode(combinationStack);
            if (canvasCode != null) {
                canvasTracker.unregisterCanvasData(canvasCode);
            }
            this.menu.getCombinationHandler().setStackInSlot(i, ItemStack.f_41583_);
        }
        this.updateCanvasData(this.menu.getCombinationHandler());
        super.endTransaction(player);
    }

    @Override
    public void handleCanvasSync(String canvasCode, CanvasData canvasData, long timestamp) {
        this.onChangedCombination(this.menu.getCombinationHandler());
    }

    public boolean isReady() {
        return this.state == AbstractCanvasAction.State.READY;
    }

    public static Rectangle getRect(Tuple<Integer, Integer> min, Tuple<Integer, Integer> max) {
        int width = (Integer)max.m_14418_() + 1 - (Integer)min.m_14418_();
        int height = (Integer)max.m_14419_() + 1 - (Integer)min.m_14419_();
        return new Rectangle((Integer)min.m_14418_(), (Integer)min.m_14419_(), width, height);
    }

    public static Rectangle getZeroRect() {
        return new Rectangle(0, 0, 0, 0);
    }

    private static class Rectangle {
        public final int x;
        public final int y;
        public final int width;
        public final int height;

        Rectangle(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }
}

