/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.menu.artisttable;

import java.nio.ByteBuffer;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.capability.canvastracker.CanvasServerTracker;
import me.dantaeusb.zetter.capability.canvastracker.CanvasTracker;
import me.dantaeusb.zetter.client.renderer.CanvasRenderer;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ZetterCanvasTypes;
import me.dantaeusb.zetter.core.ZetterItems;
import me.dantaeusb.zetter.item.CanvasItem;
import me.dantaeusb.zetter.menu.ArtistTableMenu;
import me.dantaeusb.zetter.menu.artisttable.AbstractCanvasAction;
import me.dantaeusb.zetter.storage.CanvasData;
import me.dantaeusb.zetter.storage.CanvasDataType;
import me.dantaeusb.zetter.storage.DummyCanvasData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemStackHandler;

public class CanvasSplitAction
extends AbstractCanvasAction {
    private final boolean[][] realCanvases = new boolean[][]{{false, false, false, false}, {false, false, false, false}, {false, false, false, false}, {false, false, false, false}};

    public CanvasSplitAction(ArtistTableMenu artistTableMenu, Level level) {
        super(artistTableMenu, level);
    }

    @Override
    public boolean mayPlaceCombined(ItemStack stack) {
        if (stack.m_150930_((Item)ZetterItems.CANVAS.get())) {
            if (!CanvasItem.isCompound(stack)) {
                return false;
            }
            return this.noRealCanvases() && this.menu.isSplitGridEmpty();
        }
        return false;
    }

    public boolean noRealCanvases() {
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                if (!this.realCanvases[y][x]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isReady() {
        return this.state == AbstractCanvasAction.State.READY;
    }

    @Override
    public void onChangedCombined(ItemStackHandler combinedHandler) {
        if (this.isInTransaction()) {
            return;
        }
        this.updateCanvasData(combinedHandler);
        ItemStack combinedStack = combinedHandler.getStackInSlot(0);
        if (this.isReady()) {
            int[] compoundCanvasSize = CanvasItem.getBlockSize(combinedStack);
            assert (compoundCanvasSize != null);
            int compoundCanvasWidth = compoundCanvasSize[0];
            int compoundCanvasHeight = compoundCanvasSize[1];
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 4; ++x) {
                    int slotNumber = y * 4 + x;
                    if (this.realCanvases[y][x]) continue;
                    if (x < compoundCanvasWidth && y < compoundCanvasHeight) {
                        this.menu.getSplitHandler().setStackInSlot(slotNumber, new ItemStack((ItemLike)ZetterItems.CANVAS.get()));
                        continue;
                    }
                    if (this.menu.getSplitHandler().getStackInSlot(slotNumber).m_150930_((Item)ZetterItems.CANVAS.get())) {
                        Zetter.LOG.error("Found an canvas in split slot that is not supposed to be there when updating combined slot!");
                        continue;
                    }
                    this.menu.getSplitHandler().setStackInSlot(slotNumber, ItemStack.f_41583_);
                }
            }
        } else {
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 4; ++x) {
                    int slotNumber = y * 4 + x;
                    if (this.realCanvases[y][x]) continue;
                    this.menu.getSplitHandler().setStackInSlot(slotNumber, ItemStack.f_41583_);
                }
            }
        }
    }

    public void updateCanvasData(ItemStackHandler combinedHandler) {
        ItemStack combinedStack = combinedHandler.getStackInSlot(0);
        if (combinedStack.m_41619_() || !combinedStack.m_150930_((Item)ZetterItems.CANVAS.get()) || !CanvasItem.isCompound(combinedStack)) {
            this.canvasData = null;
            this.state = AbstractCanvasAction.State.EMPTY;
            return;
        }
        String combinedStackCanvasCode = CanvasItem.getCanvasCode(combinedStack);
        if (combinedStackCanvasCode == null) {
            int[] size = CanvasItem.getBlockSize(combinedStack);
            assert (size != null && size.length == 2);
            int resolutionPixels = Helper.getResolution().getNumeric();
            byte[] color = new byte[size[0] * resolutionPixels * size[1] * resolutionPixels * 4];
            ByteBuffer defaultColorBuffer = ByteBuffer.wrap(color);
            for (int x = 0; x < size[0] * resolutionPixels * size[1] * resolutionPixels; ++x) {
                defaultColorBuffer.putInt(x * 4, -2041138);
            }
            this.canvasData = (DummyCanvasData)((Object)((CanvasDataType)ZetterCanvasTypes.DUMMY.get()).createWrap(Helper.getResolution(), size[0] * Helper.getResolution().getNumeric(), size[1] * Helper.getResolution().getNumeric(), color));
            if (this.level.m_5776_()) {
                Helper.getLevelCanvasTracker(this.level).registerCanvasData("zetter_combined_canvas", this.canvasData);
            }
            this.state = AbstractCanvasAction.State.READY;
            return;
        }
        CanvasData combinedStackCanvasData = CanvasItem.getCanvasData(combinedStack, this.level);
        if (combinedStackCanvasData != null) {
            this.canvasData = (DummyCanvasData)((Object)((CanvasDataType)ZetterCanvasTypes.DUMMY.get()).createWrap(combinedStackCanvasData.getResolution(), combinedStackCanvasData.getWidth(), combinedStackCanvasData.getHeight(), combinedStackCanvasData.getColorData()));
            if (this.level.m_5776_()) {
                Helper.getLevelCanvasTracker(this.level).registerCanvasData("zetter_combined_canvas", this.canvasData);
            }
            this.state = AbstractCanvasAction.State.READY;
        } else {
            CanvasRenderer.getInstance().queueCanvasTextureUpdate(CanvasItem.getCanvasCode(combinedStack));
            this.state = AbstractCanvasAction.State.NOT_LOADED;
        }
    }

    @Override
    public void onTakeSplit(Player player, ItemStack takenStack) {
        ItemStack combinedStack = this.menu.getCombinedHandler().getStackInSlot(0);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                int slotNumber = y * 4 + x;
                ItemStack splitStack = this.menu.getSplitHandler().getStackInSlot(slotNumber);
                if (!this.realCanvases[y][x]) continue;
                this.realCanvases[y][x] = !splitStack.m_41619_();
            }
        }
        if (!combinedStack.m_150930_((Item)ZetterItems.CANVAS.get()) || !CanvasItem.isCompound(combinedStack)) {
            return;
        }
        if (!this.noRealCanvases()) {
            Zetter.LOG.error("Cannot take split canvas when there are still real canvases on the grid");
            return;
        }
        this.startTransaction(player);
        int[] compoundCanvasSize = CanvasItem.getBlockSize(combinedStack);
        assert (compoundCanvasSize != null);
        int compoundCanvasWidth = compoundCanvasSize[0];
        int compoundCanvasHeight = compoundCanvasSize[1];
        int numericResolution = CanvasItem.getResolution(combinedStack);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                int slotNumber = y * 4 + x;
                ItemStack splitStack = this.menu.getSplitHandler().getStackInSlot(slotNumber);
                if (x >= compoundCanvasWidth || y >= compoundCanvasHeight) continue;
                this.realCanvases[y][x] = !splitStack.m_41619_();
            }
        }
        if (!this.level.m_5776_()) {
            CanvasTracker canvasTracker = Helper.getLevelCanvasTracker(player.m_9236_());
            CanvasData combinedCanvasData = CanvasItem.getCanvasData(combinedStack, this.level);
            if (combinedCanvasData != null) {
                int missingX = 0;
                int missingY = 0;
                for (int y = 0; y < 4; ++y) {
                    for (int x = 0; x < 4; ++x) {
                        int slotNumber = y * 4 + x;
                        ItemStack splitStack = this.menu.getSplitHandler().getStackInSlot(slotNumber);
                        if (x >= compoundCanvasWidth || y >= compoundCanvasHeight) continue;
                        if (splitStack.m_41619_()) {
                            missingX = x;
                            missingY = y;
                            continue;
                        }
                        this.realCanvases[y][x] = true;
                        CanvasData itemData = CanvasData.BUILDER.createWrap(combinedCanvasData.getResolution(), numericResolution, numericResolution, CanvasSplitAction.getPartialColorData(combinedCanvasData.getColorData(), numericResolution, x, y, compoundCanvasWidth, compoundCanvasHeight));
                        String canvasCode = CanvasData.getCanvasCode(((CanvasServerTracker)canvasTracker).getFreeCanvasId());
                        canvasTracker.registerCanvasData(canvasCode, itemData);
                        CanvasItem.storeCanvasData(splitStack, canvasCode, itemData);
                    }
                }
                CanvasData itemData = CanvasData.BUILDER.createWrap(combinedCanvasData.getResolution(), numericResolution, numericResolution, CanvasSplitAction.getPartialColorData(combinedCanvasData.getColorData(), numericResolution, missingX, missingY, compoundCanvasWidth, compoundCanvasHeight));
                String canvasCode = CanvasData.getCanvasCode(((CanvasServerTracker)canvasTracker).getFreeCanvasId());
                canvasTracker.registerCanvasData(canvasCode, itemData);
                CanvasItem.storeCanvasData(takenStack, canvasCode, itemData);
            }
        }
        this.endTransaction(player);
    }

    @Override
    public void endTransaction(Player player) {
        ItemStack combinedStack = this.menu.getCombinedHandler().getStackInSlot(0);
        CanvasTracker canvasTracker = Helper.getLevelCanvasTracker(player.m_9236_());
        String canvasCode = CanvasItem.getCanvasCode(combinedStack);
        if (canvasCode != null) {
            canvasTracker.unregisterCanvasData(canvasCode);
        }
        this.menu.getCombinedHandler().setStackInSlot(0, ItemStack.f_41583_);
        this.updateCanvasData(this.menu.getCombinedHandler());
        super.endTransaction(player);
    }

    @Override
    public void handleCanvasSync(String canvasCode, CanvasData canvasData, long timestamp) {
        this.onChangedCombined(this.menu.getCombinedHandler());
    }

    private boolean isCanvasReal(int index) {
        return this.isCanvasReal(index % 4, index / 4);
    }

    private boolean isCanvasReal(int x, int y) {
        return this.realCanvases[y][x];
    }

    @Override
    public void discard(ItemStackHandler from, ItemStackHandler to, Player player) {
        block5: {
            ItemStack combinedStack;
            block4: {
                combinedStack = from.extractItem(0, from.getSlotLimit(0), false);
                if (player.m_6084_() && (!(player instanceof ServerPlayer) || !((ServerPlayer)player).m_9232_())) break block4;
                if (!combinedStack.m_41619_()) {
                    player.m_36176_(combinedStack, false);
                }
                for (int i = 0; i < to.getSlots(); ++i) {
                    ItemStack extractedStack = to.extractItem(i, to.getSlotLimit(i), false);
                    if (extractedStack.m_41619_() || !this.isCanvasReal(i)) continue;
                    player.m_36176_(extractedStack, false);
                }
                break block5;
            }
            if (!(player instanceof ServerPlayer)) break block5;
            Inventory inventory = player.m_150109_();
            if (!combinedStack.m_41619_()) {
                inventory.m_150079_(combinedStack);
            }
            for (int i = 0; i < to.getSlots(); ++i) {
                ItemStack extractedStack = to.extractItem(i, to.getSlotLimit(i), false);
                if (extractedStack.m_41619_() || !this.isCanvasReal(i)) continue;
                inventory.m_150079_(extractedStack);
            }
        }
    }

    private static byte[] getPartialColorData(byte[] colorData, int resolution, int blockX, int blockY, int blockWidth, int blockHeight) {
        byte[] destinationColor = new byte[resolution * resolution * 4];
        ByteBuffer colorBuffer = ByteBuffer.wrap(colorData);
        int offset = (blockWidth * resolution * blockY * resolution + blockX * resolution) * 4;
        for (int y = 0; y < resolution; ++y) {
            colorBuffer.get(offset + blockWidth * resolution * y * 4, destinationColor, y * resolution * 4, resolution * 4);
        }
        return destinationColor;
    }
}

