/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network.packet;

import java.util.function.Supplier;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.network.ServerHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class CCanvasRequestPacket {
    public final String canvasName;

    public CCanvasRequestPacket(String canvasName) {
        this.canvasName = canvasName;
    }

    public static CCanvasRequestPacket readPacketData(FriendlyByteBuf buf) {
        String canvasName = buf.m_130136_(64);
        return new CCanvasRequestPacket(canvasName);
    }

    public void writePacketData(FriendlyByteBuf buf) {
        buf.m_130072_(this.canvasName, 64);
    }

    public static void handle(CCanvasRequestPacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.setPacketHandled(true);
        ServerPlayer sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            Zetter.LOG.warn("EntityPlayerMP was null when CRequestSyncPacket was received");
        }
        ctx.enqueueWork(() -> ServerHandler.processCanvasRequest(packetIn, sendingPlayer));
    }
}

