/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network.packet;

import java.util.Optional;
import java.util.function.Supplier;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.network.ClientHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public record SCanvasRemovalPacket(String canvasCode, long timestamp) {
    public static SCanvasRemovalPacket readPacketData(FriendlyByteBuf networkBuffer) {
        try {
            String canvasCode = networkBuffer.m_130136_(128);
            long timestamp = networkBuffer.readLong();
            return new SCanvasRemovalPacket(canvasCode, timestamp);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Zetter.LOG.warn("Exception while reading SCanvasSyncMessage: " + e);
            return null;
        }
    }

    public void writePacketData(FriendlyByteBuf networkBuffer) {
        networkBuffer.m_130072_(this.canvasCode, 128);
        networkBuffer.writeLong(this.timestamp);
    }

    public static void handle(SCanvasRemovalPacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (clientWorld.isEmpty()) {
            Zetter.LOG.error("SCanvasRemovalMessage context could not provide a ClientWorld.");
            return;
        }
        ctx.enqueueWork(() -> ClientHandler.processCanvasRemoval(packetIn, (Level)clientWorld.get()));
    }

    @Override
    public String toString() {
        return "SCanvasRemovalMessage[canvas=" + this.canvasCode + ",timestamp=" + this.timestamp + "]";
    }
}

