/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network.packet;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.network.ClientHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SCanvasSyncExportErrorPacket {
    public final String errorCode;
    public final String errorMessage;

    public SCanvasSyncExportErrorPacket(String errorCode, @Nullable String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public static SCanvasSyncExportErrorPacket readPacketData(FriendlyByteBuf networkBuffer) {
        try {
            String errorCode = networkBuffer.m_130136_(Short.MAX_VALUE);
            String errorMessage = null;
            if (networkBuffer.readBoolean()) {
                errorMessage = networkBuffer.m_130136_(Short.MAX_VALUE);
            }
            return new SCanvasSyncExportErrorPacket(errorCode, errorMessage);
        }
        catch (Exception e) {
            Zetter.LOG.warn("Exception while reading SCanvasSyncExportErrorPacket: " + e);
            return null;
        }
    }

    public void writePacketData(FriendlyByteBuf networkBuffer) {
        networkBuffer.m_130072_(this.errorCode, Short.MAX_VALUE);
        networkBuffer.writeBoolean(this.errorMessage != null);
        if (this.errorMessage != null) {
            networkBuffer.m_130072_(this.errorMessage, Short.MAX_VALUE);
        }
    }

    public static void handle(SCanvasSyncExportErrorPacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            Zetter.LOG.warn("SCanvasSyncExportErrorPacket context could not provide a ClientWorld.");
            return;
        }
        ctx.enqueueWork(() -> ClientHandler.processCanvasSyncExportError(packetIn, (Level)clientWorld.get()));
    }

    public String toString() {
        return "SCanvasSyncViewMessage[errorCode=" + this.errorCode + "]";
    }
}

