/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.storage;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.UUID;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ZetterCanvasTypes;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasDataBuilder;
import me.dantaeusb.zetter.storage.CanvasDataType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;

public class PaintingData
extends AbstractCanvasData {
    public static final String TYPE = "painting";
    public static final String CODE_PREFIX = "zetter_painting_";
    public static final ResourceLocation OVERLAY_KEY = new ResourceLocation("zetter", "painting_info");
    public static final CanvasDataBuilder<PaintingData> BUILDER = new PaintingDataBuilder();
    public static final int MAX_GENERATION = 2;
    public static final UUID FALLBACK_UUID = new UUID(0L, 0L);
    protected static final String NBT_TAG_AUTHOR_NAME = "author_name";
    protected static final String NBT_TAG_AUTHOR_UUID = "AuthorUuid";
    protected static final String NBT_TAG_NAME = "title";
    protected static final String NBT_TAG_BANNED = "Banned";
    protected UUID authorUuid;
    protected String authorName;
    protected String name;
    protected boolean banned = false;

    protected PaintingData() {
    }

    public static String getCanvasCode(int canvasId) {
        return CODE_PREFIX + canvasId;
    }

    public void setMetaProperties(UUID authorUuid, String authorName, String name) {
        this.authorUuid = authorUuid;
        this.authorName = authorName;
        this.name = name;
    }

    public String getPaintingName() {
        return this.name;
    }

    public UUID getAuthorUuid() {
        return this.authorUuid;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public static String getPaintingCode(int paintingId) {
        return CODE_PREFIX + paintingId;
    }

    public boolean isBanned() {
        return this.banned;
    }

    @Override
    public boolean isRenderable() {
        return true;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public ResourceLocation getOverlay() {
        return OVERLAY_KEY;
    }

    public CanvasDataType<? extends PaintingData> getType() {
        return (CanvasDataType)ZetterCanvasTypes.PAINTING.get();
    }

    @Override
    public void correctData(ServerLevel level) {
        if (this.authorUuid == null || this.authorUuid.equals(FALLBACK_UUID)) {
            UUID authorUuid = Helper.tryToRestoreAuthorUuid(level, this.authorName);
            if (authorUuid != null) {
                this.authorUuid = authorUuid;
            } else {
                Zetter.LOG.warn("Cannot restore author UUID for player " + this.authorName);
                this.authorUuid = FALLBACK_UUID;
            }
            this.m_77762_();
        }
    }

    @Override
    public CompoundTag m_7176_(CompoundTag compoundTag) {
        super.m_7176_(compoundTag);
        compoundTag.m_128362_(NBT_TAG_AUTHOR_UUID, this.authorUuid);
        compoundTag.m_128359_(NBT_TAG_AUTHOR_NAME, this.authorName);
        compoundTag.m_128359_(NBT_TAG_NAME, this.name);
        compoundTag.m_128379_(NBT_TAG_BANNED, this.banned);
        return compoundTag;
    }

    private static class PaintingDataBuilder
    implements CanvasDataBuilder<PaintingData> {
        private PaintingDataBuilder() {
        }

        @Override
        public PaintingData createFresh(AbstractCanvasData.Resolution resolution, int width, int height) {
            PaintingData newPainting = new PaintingData();
            byte[] color = new byte[width * height * 4];
            ByteBuffer defaultColorBuffer = ByteBuffer.wrap(color);
            for (int x = 0; x < width * height; ++x) {
                defaultColorBuffer.putInt(x * 4, -2041138);
            }
            newPainting.wrapData(resolution, width, height, color);
            return newPainting;
        }

        @Override
        public PaintingData createWrap(AbstractCanvasData.Resolution resolution, int width, int height, byte[] color) {
            PaintingData newPainting = new PaintingData();
            newPainting.wrapData(resolution, width, height, color);
            return newPainting;
        }

        @Override
        public PaintingData load(CompoundTag compoundTag) {
            PaintingData newPainting = new PaintingData();
            newPainting.width = compoundTag.m_128451_("width");
            newPainting.height = compoundTag.m_128451_("height");
            int resolutionOrdinal = compoundTag.m_128451_("resolution");
            newPainting.resolution = AbstractCanvasData.Resolution.values()[resolutionOrdinal];
            newPainting.updateColorData(compoundTag.m_128463_("color"));
            newPainting.authorUuid = compoundTag.m_128441_(PaintingData.NBT_TAG_AUTHOR_UUID) ? compoundTag.m_128342_(PaintingData.NBT_TAG_AUTHOR_UUID) : null;
            newPainting.authorName = compoundTag.m_128461_(PaintingData.NBT_TAG_AUTHOR_NAME);
            newPainting.name = compoundTag.m_128461_(PaintingData.NBT_TAG_NAME);
            newPainting.banned = compoundTag.m_128471_(PaintingData.NBT_TAG_BANNED);
            return newPainting;
        }

        @Override
        public PaintingData readPacketData(FriendlyByteBuf networkBuffer) {
            PaintingData newPainting = new PaintingData();
            byte resolutionOrdinal = networkBuffer.readByte();
            AbstractCanvasData.Resolution resolution = AbstractCanvasData.Resolution.values()[resolutionOrdinal];
            int width = networkBuffer.readInt();
            int height = networkBuffer.readInt();
            int colorDataSize = networkBuffer.readInt();
            ByteBuffer colorData = networkBuffer.readBytes(colorDataSize).nioBuffer();
            byte[] unwrappedColorData = new byte[width * height * 4];
            colorData.get(unwrappedColorData);
            newPainting.wrapData(resolution, width, height, unwrappedColorData);
            UUID authorUuid = networkBuffer.m_130259_();
            String authorName = networkBuffer.m_130136_(64);
            String name = networkBuffer.m_130136_(32);
            newPainting.setMetaProperties(authorUuid, authorName, name);
            return newPainting;
        }

        @Override
        public void writePacketData(PaintingData canvasData, FriendlyByteBuf networkBuffer) {
            networkBuffer.writeByte(canvasData.resolution.ordinal());
            networkBuffer.writeInt(canvasData.width);
            networkBuffer.writeInt(canvasData.height);
            networkBuffer.writeInt(canvasData.getColorDataBuffer().remaining());
            networkBuffer.writeBytes(canvasData.getColorDataBuffer());
            networkBuffer.m_130077_(Objects.requireNonNullElse(canvasData.authorUuid, FALLBACK_UUID));
            networkBuffer.m_130072_(canvasData.authorName, 64);
            networkBuffer.m_130072_(canvasData.name, 32);
        }
    }
}

