/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.api;

import com.blackgear.vanillabackport.client.api.color.LeafColors;
import com.blackgear.vanillabackport.client.registries.ModParticles;
import com.blackgear.vanillabackport.core.VanillaBackport;
import com.blackgear.vanillabackport.core.data.tags.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FallingLeavesModule {
    public void makeFallingLeavesParticles(Level level, BlockPos pos, RandomSource random, BlockState state, BlockPos offset) {
        if ((double)random.nextFloat() < (Double)VanillaBackport.CLIENT_CONFIG.fallingLeavesFrequency.get() && !Block.isFaceFull((VoxelShape)state.getCollisionShape((BlockGetter)level, offset), (Direction)Direction.UP)) {
            this.spawnFallingLeavesParticle(level, pos, random);
        }
    }

    private void spawnFallingLeavesParticle(Level level, BlockPos pos, RandomSource random) {
        BlockState state = level.getBlockState(pos);
        if (((Boolean)VanillaBackport.CLIENT_CONFIG.hasFallingLeaves.get()).booleanValue()) {
            ParticleType<ColorParticleOption> particle = null;
            if (state.is(ModBlockTags.SPAWN_FALLING_LEAVES)) {
                particle = ModParticles.TINTED_LEAVES.get();
            } else if (state.is(ModBlockTags.SPAWN_FALLING_NEEDLES)) {
                particle = ModParticles.TINTED_NEEDLES.get();
            }
            if (particle != null) {
                ColorParticleOption option = ColorParticleOption.create(particle, (int)LeafColors.getClientLeafTintColor(pos));
                ParticleUtils.spawnParticleBelow((Level)level, (BlockPos)pos, (RandomSource)random, (ParticleOptions)option);
            }
        }
    }
}

