/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.api.leash;

import com.blackgear.vanillabackport.common.api.leash.LeashExtension;
import com.blackgear.vanillabackport.common.api.leash.LeashState;
import com.blackgear.vanillabackport.core.mixin.access.EntityRendererAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class LeashRenderer<T extends Entity> {
    private final EntityRenderDispatcher dispatcher;
    @Nullable
    private List<LeashState> leashStates;

    public LeashRenderer(EntityRenderDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public boolean shouldRender(T entity, Frustum camera, boolean isVisible, boolean fallback) {
        if (!isVisible) {
            Leashable leashable;
            Entity holder;
            AABB entityBox = entity.getBoundingBoxForCulling().inflate(0.5);
            if (entityBox.hasNaN() || entityBox.getSize() == 0.0) {
                entityBox = new AABB(entity.getX() - 2.0, entity.getY() - 2.0, entity.getZ() - 2.0, entity.getX() + 2.0, entity.getY() + 2.0, entity.getZ() + 2.0);
            }
            if (camera.isVisible(entityBox)) {
                return true;
            }
            if (entity instanceof Leashable && (holder = (leashable = (Leashable)entity).getLeashHolder()) != null) {
                AABB holderBox = holder.getBoundingBoxForCulling();
                return camera.isVisible(holderBox) || camera.isVisible(entityBox.minmax(holderBox));
            }
        }
        return fallback;
    }

    public boolean shouldRender(T entity, Frustum camera, boolean isVisible) {
        return this.shouldRender(entity, camera, isVisible, isVisible);
    }

    public void render(T entity, float partialTick, PoseStack poseStack, MultiBufferSource buffer) {
        this.setupLeashRendering(entity, partialTick);
        if (this.leashStates != null) {
            for (LeashState state : this.leashStates) {
                this.renderLeash(poseStack, buffer, state);
            }
        }
    }

    private void renderLeash(PoseStack stack, MultiBufferSource buffer, LeashState state) {
        int segment;
        float deltaX = (float)(state.end.x - state.start.x);
        float deltaY = (float)(state.end.y - state.start.y);
        float deltaZ = (float)(state.end.z - state.start.z);
        float scaleFactor = Mth.invSqrt((float)(deltaX * deltaX + deltaZ * deltaZ)) * 0.05f / 2.0f;
        float offsetZ = deltaZ * scaleFactor;
        float offsetX = deltaX * scaleFactor;
        stack.pushPose();
        stack.translate(state.offset.x, state.offset.y, state.offset.z);
        VertexConsumer vertices = buffer.getBuffer(RenderType.leash());
        Matrix4f matrices = stack.last().pose();
        for (segment = 0; segment <= 24; ++segment) {
            LeashRenderer.addVertexPair(vertices, matrices, deltaX, deltaY, deltaZ, 0.05f, 0.05f, offsetZ, offsetX, segment, false, state);
        }
        for (segment = 24; segment >= 0; --segment) {
            LeashRenderer.addVertexPair(vertices, matrices, deltaX, deltaY, deltaZ, 0.05f, 0.0f, offsetZ, offsetX, segment, true, state);
        }
        stack.popPose();
    }

    private static void addVertexPair(VertexConsumer vertices, Matrix4f matrices, float deltaX, float deltaY, float deltaZ, float thickness1, float thickness2, float offsetZ, float offsetX, int segment, boolean isInnerFace, LeashState state) {
        float progress = (float)segment / 24.0f;
        int blockLight = (int)Mth.lerp((float)progress, (float)state.startBlockLight, (float)state.endBlockLight);
        int skyLight = (int)Mth.lerp((float)progress, (float)state.startSkyLight, (float)state.endSkyLight);
        int packedLight = LightTexture.pack((int)blockLight, (int)skyLight);
        float colorModifier = segment % 2 == (isInnerFace ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * colorModifier;
        float green = 0.4f * colorModifier;
        float blue = 0.3f * colorModifier;
        float posX = deltaX * progress;
        float posZ = deltaZ * progress;
        float posY = state.slack ? (deltaY > 0.0f ? deltaY * progress * progress : deltaY - deltaY * (1.0f - progress) * (1.0f - progress)) : deltaY * progress;
        vertices.addVertex(matrices, posX - offsetZ, posY + thickness2, posZ + offsetX).setColor(red, green, blue, 1.0f).setLight(packedLight);
        vertices.addVertex(matrices, posX + offsetZ, posY + thickness1 - thickness2, posZ - offsetX).setColor(red, green, blue, 1.0f).setLight(packedLight);
    }

    private void setupLeashRendering(T entity, float partialTicks) {
        if (!(entity instanceof Leashable)) {
            this.leashStates = null;
            return;
        }
        Leashable leashable = (Leashable)entity;
        LeashExtension extension = (LeashExtension)leashable;
        Entity leashHolder = leashable.getLeashHolder();
        if (leashHolder != null) {
            int leashCount;
            LeashExtension ext;
            float entityRotation = LeashExtension.vb$getPreciseBodyRotation(entity, partialTicks) * ((float)Math.PI / 180);
            Vec3 leashOffset = entity.getLeashOffset(partialTicks);
            BlockPos entityPos = BlockPos.containing((Position)entity.getEyePosition(partialTicks));
            BlockPos holderPos = BlockPos.containing((Position)leashHolder.getEyePosition(partialTicks));
            int entityBlockLight = this.getBlockLightLevel((Entity)entity, entityPos);
            int holderBlockLight = this.getBlockLightLevel(leashHolder, holderPos);
            int entitySkyLight = entity.level().getBrightness(LightLayer.SKY, entityPos);
            int holderSkyLight = entity.level().getBrightness(LightLayer.SKY, holderPos);
            boolean handleHolderQuadLeash = leashHolder instanceof LeashExtension && (ext = (LeashExtension)leashHolder).vb$supportQuadLeashAsHolder();
            boolean handleQuadLeash = extension.vb$supportQuadLeash();
            boolean useQuadLeash = handleHolderQuadLeash && handleQuadLeash;
            int n = leashCount = useQuadLeash ? 4 : 1;
            if (this.leashStates == null || this.leashStates.size() != leashCount) {
                this.leashStates = new ArrayList<LeashState>(leashCount);
                for (int i = 0; i < leashCount; ++i) {
                    this.leashStates.add(new LeashState());
                }
            }
            if (useQuadLeash) {
                float holderRotation = LeashExtension.vb$getPreciseBodyRotation(leashHolder, partialTicks) * ((float)Math.PI / 180);
                Vec3 holderPosition = leashHolder.getPosition(partialTicks);
                Vec3[] entityOffsets = extension.vb$getQuadLeashOffsets();
                Vec3[] holderOffsets = ((LeashExtension)leashHolder).vb$getQuadLeashHolderOffsets();
                for (int i = 0; i < leashCount; ++i) {
                    LeashState leashState = this.leashStates.get(i);
                    leashState.offset = entityOffsets[i].yRot(-entityRotation);
                    leashState.start = entity.getPosition(partialTicks).add(leashState.offset);
                    leashState.end = holderPosition.add(holderOffsets[i].yRot(-holderRotation));
                    leashState.startBlockLight = entityBlockLight;
                    leashState.endBlockLight = holderBlockLight;
                    leashState.startSkyLight = entitySkyLight;
                    leashState.endSkyLight = holderSkyLight;
                    leashState.slack = false;
                }
            } else {
                Vec3 rotatedOffset = leashOffset.yRot(-entityRotation);
                LeashState leashState = this.leashStates.getFirst();
                leashState.offset = rotatedOffset;
                leashState.start = entity.getPosition(partialTicks).add(rotatedOffset);
                leashState.end = leashHolder.getRopeHoldPosition(partialTicks);
                leashState.startBlockLight = entityBlockLight;
                leashState.endBlockLight = holderBlockLight;
                leashState.startSkyLight = entitySkyLight;
                leashState.endSkyLight = holderSkyLight;
            }
        } else {
            this.leashStates = null;
        }
    }

    private int getBlockLightLevel(Entity entity, BlockPos pos) {
        return ((EntityRendererAccessor)this.dispatcher.getRenderer(entity)).callGetBlockLightLevel(entity, pos);
    }
}

