/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.blocks;

import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.level.entities.happyghast.HappyGhast;
import com.blackgear.vanillabackport.common.registries.ModBlockStateProperties;
import com.blackgear.vanillabackport.common.registries.ModEntities;
import com.blackgear.vanillabackport.core.data.tags.ModBlockTags;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DriedGhastBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<DriedGhastBlock> CODEC = DriedGhastBlock.simpleCodec(DriedGhastBlock::new);
    public static final int MAX_HYDRATION_LEVEL = 3;
    public static final IntegerProperty HYDRATION_LEVEL = ModBlockStateProperties.HYDRATION_LEVEL;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final int HYDRATION_TICK_DELAY = 5000;
    private static final VoxelShape SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);

    public MapCodec<DriedGhastBlock> codec() {
        return CODEC;
    }

    public DriedGhastBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)HYDRATION_LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HYDRATION_LEVEL, WATERLOGGED});
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public int getHydrationLevel(BlockState state) {
        return (Integer)state.getValue((Property)HYDRATION_LEVEL);
    }

    private boolean isReadyToSpawn(BlockState state) {
        return this.getHydrationLevel(state) == 3;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            this.tickWaterlogged(state, level, pos, random);
        } else {
            int hydrationLevel = this.getHydrationLevel(state);
            if (hydrationLevel > 0) {
                level.setBlock(pos, (BlockState)state.setValue((Property)HYDRATION_LEVEL, (Comparable)Integer.valueOf(hydrationLevel - 1)), 2);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
            }
        }
    }

    private void tickWaterlogged(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.isReadyToSpawn(state)) {
            level.playSound(null, pos, ModSoundEvents.DRIED_GHAST_TRANSITION.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            level.setBlock(pos, (BlockState)state.setValue((Property)HYDRATION_LEVEL, (Comparable)Integer.valueOf(this.getHydrationLevel(state) + 1)), 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
        } else {
            this.spawnGhastling(level, pos, state);
        }
    }

    private void spawnGhastling(ServerLevel level, BlockPos pos, BlockState state) {
        level.removeBlock(pos, false);
        HappyGhast ghast = (HappyGhast)ModEntities.HAPPY_GHAST.get().create((Level)level);
        if (ghast != null) {
            Vec3 center = Vec3.atBottomCenterOf((Vec3i)pos);
            ghast.setBaby(true);
            float yRot = DriedGhastBlock.getYRot((Direction)state.getValue((Property)FACING));
            ghast.setYHeadRot(yRot);
            ghast.setPosRaw(center.x(), center.y(), center.z());
            ghast.setYRot(yRot);
            ghast.setXRot(0.0f);
            ghast.setOldPosAndRot();
            ghast.setPos(ghast.position().x(), ghast.position().y(), ghast.position().z());
            level.addFreshEntity((Entity)ghast);
            level.playSound(null, (Entity)ghast, ModSoundEvents.GHASTLING_SPAWN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static float getYRot(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> 180.0f;
            case Direction.SOUTH -> 0.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> -90.0f;
            default -> throw new IllegalStateException("No y-Rot for vertical axis: " + String.valueOf(direction));
        };
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.5;
        double z = (double)pos.getZ() + 0.5;
        if (!((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            if (random.nextInt(40) == 0 && level.getBlockState(pos.below()).is(ModBlockTags.TRIGGERS_AMBIENT_DRIED_GHAST_BLOCK_SOUNDS)) {
                level.playLocalSound(x, y, z, ModSoundEvents.DRIED_GHAST_AMBIENT.get(), SoundSource.AMBIENT, 1.0f, 1.0f, false);
            }
            if (random.nextInt(6) == 0) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.02, 0.0);
            }
        } else {
            if (random.nextInt(40) == 0) {
                level.playLocalSound(x, y, z, ModSoundEvents.DRIED_GHAST_AMBIENT_WATER.get(), SoundSource.AMBIENT, 1.0f, 1.0f, false);
            }
            if (random.nextInt(6) == 0) {
                level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, x + (double)((random.nextFloat() * 2.0f - 1.0f) / 3.0f), y + 0.4, z + (double)((random.nextFloat() * 2.0f - 1.0f) / 3.0f), 0.0, (double)random.nextFloat(), 0.0);
            }
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if ((((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() || (Integer)state.getValue((Property)HYDRATION_LEVEL) > 0) && !level.getBlockTicks().hasScheduledTick(pos, (Object)this)) {
            level.scheduleTick(pos, (Block)this, 5000);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState state = context.getLevel().getFluidState(context.getClickedPos());
        boolean isWaterlogged = state.is(FluidTags.WATER) && state.getAmount() == 8;
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() || fluidState.getType() != Fluids.WATER) {
            return false;
        }
        if (!level.isClientSide()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
            level.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)level));
            level.playSound(null, pos, ModSoundEvents.DRIED_GHAST_PLACE_IN_WATER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        level.playSound(null, pos, (Boolean)state.getValue((Property)WATERLOGGED) != false ? ModSoundEvents.DRIED_GHAST_PLACE_IN_WATER.get() : ModSoundEvents.DRIED_GHAST_PLACE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

