/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.worldgen.features;

import com.blackgear.platform.common.worldgen.WorldGenRegistry;
import com.blackgear.vanillabackport.common.level.features.FallenTreeConfiguration;
import com.blackgear.vanillabackport.common.registries.ModBlocks;
import com.blackgear.vanillabackport.common.registries.ModFeatures;
import com.blackgear.vanillabackport.common.worldgen.treedecorators.AttachedToLogsDecorator;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TrunkVineDecorator;

public class SpringToLifeFeatures {
    public static final WorldGenRegistry<ConfiguredFeature<?, ?>> FEATURES = WorldGenRegistry.of((ResourceKey)Registries.CONFIGURED_FEATURE, (String)"minecraft");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_BUSH = FEATURES.create("patch_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_FIREFLY_BUSH = FEATURES.create("patch_firefly_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILDFLOWERS_BIRCH_FOREST = FEATURES.create("wildflowers_birch_forest");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILDFLOWERS_MEADOW = FEATURES.create("wildflowers_meadow");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_DRY_GRASS = FEATURES.create("patch_dry_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_LEAF_LITTER = FEATURES.create("patch_leaf_litter");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LEAF_LITTER = FEATURES.create("leaf_litter");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_OAK_TREE = FEATURES.create("fallen_oak_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_BIRCH_TREE = FEATURES.create("fallen_birch_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_SUPER_BIRCH_TREE = FEATURES.create("fallen_super_birch_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_JUNGLE_TREE = FEATURES.create("fallen_jungle_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_SPRUCE_TREE = FEATURES.create("fallen_spruce_tree");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        FEATURES.register(context, PATCH_BUSH, Feature.RANDOM_PATCH, (FeatureConfiguration)new RandomPatchConfiguration(25, 5, 3, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)ModBlocks.BUSH.get())))));
        FEATURES.register(context, PATCH_FIREFLY_BUSH, Feature.RANDOM_PATCH, (FeatureConfiguration)new RandomPatchConfiguration(20, 4, 3, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)ModBlocks.FIREFLY_BUSH.get())))));
        FEATURES.register(context, WILDFLOWERS_BIRCH_FOREST, Feature.FLOWER, (FeatureConfiguration)new RandomPatchConfiguration(64, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SpringToLifeFeatures.flowerBedPatchBuilder(ModBlocks.WILDFLOWERS.get()))))));
        FEATURES.register(context, WILDFLOWERS_MEADOW, Feature.FLOWER, (FeatureConfiguration)new RandomPatchConfiguration(8, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SpringToLifeFeatures.flowerBedPatchBuilder(ModBlocks.WILDFLOWERS.get()))))));
        FEATURES.register(context, PATCH_DRY_GRASS, Feature.RANDOM_PATCH, (FeatureConfiguration)SpringToLifeFeatures.grassPatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)ModBlocks.SHORT_DRY_GRASS.get().defaultBlockState(), 1).add((Object)ModBlocks.TALL_DRY_GRASS.get().defaultBlockState(), 1).build()), 64));
        FEATURES.register(context, PATCH_LEAF_LITTER, Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simpleRandomPatchConfiguration((int)32, (Holder)PlacementUtils.filtered((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SpringToLifeFeatures.leafLitterPatchBuilder(1, 3))), (BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{Blocks.GRASS_BLOCK})))));
        FEATURES.register(context, FALLEN_OAK_TREE, ModFeatures.FALLEN_TREE.get(), (FeatureConfiguration)SpringToLifeFeatures.createFallenOak().build());
        FEATURES.register(context, FALLEN_BIRCH_TREE, ModFeatures.FALLEN_TREE.get(), (FeatureConfiguration)SpringToLifeFeatures.createFallenBirch(8).build());
        FEATURES.register(context, FALLEN_SUPER_BIRCH_TREE, ModFeatures.FALLEN_TREE.get(), (FeatureConfiguration)SpringToLifeFeatures.createFallenBirch(15).build());
        FEATURES.register(context, FALLEN_JUNGLE_TREE, ModFeatures.FALLEN_TREE.get(), (FeatureConfiguration)SpringToLifeFeatures.createFallenJungle().build());
        FEATURES.register(context, FALLEN_SPRUCE_TREE, ModFeatures.FALLEN_TREE.get(), (FeatureConfiguration)SpringToLifeFeatures.createFallenSpruce().build());
        FEATURES.register(context, LEAF_LITTER, ModFeatures.LEAF_LITTER.get(), (FeatureConfiguration)FeatureConfiguration.NONE);
    }

    private static RandomPatchConfiguration grassPatch(BlockStateProvider provider, int tries) {
        return FeatureUtils.simpleRandomPatchConfiguration((int)tries, (Holder)PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration(provider)));
    }

    private static SimpleWeightedRandomList.Builder<BlockState> flowerBedPatchBuilder(Block block) {
        return SpringToLifeFeatures.segmentedBlockPatchBuilder(block, 1, 4, PinkPetalsBlock.AMOUNT, (EnumProperty<Direction>)PinkPetalsBlock.FACING);
    }

    private static SimpleWeightedRandomList.Builder<BlockState> leafLitterPatchBuilder(int min, int max) {
        return SpringToLifeFeatures.segmentedBlockPatchBuilder(ModBlocks.LEAF_LITTER.get(), min, max, PinkPetalsBlock.AMOUNT, (EnumProperty<Direction>)PinkPetalsBlock.FACING);
    }

    private static SimpleWeightedRandomList.Builder<BlockState> segmentedBlockPatchBuilder(Block block, int min, int max, IntegerProperty amount, EnumProperty<Direction> facing) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.builder();
        for (int i = min; i <= max; ++i) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                builder.add((Object)((BlockState)((BlockState)block.defaultBlockState().setValue((Property)amount, (Comparable)Integer.valueOf(i))).setValue(facing, (Comparable)direction)), 1);
            }
        }
        return builder;
    }

    private static FallenTreeConfiguration.FallenTreeConfigurationBuilder createFallenOak() {
        return SpringToLifeFeatures.createFallenTrees(Blocks.OAK_LOG, 4, 7).stumpDecorators((List<TreeDecorator>)ImmutableList.of((Object)TrunkVineDecorator.INSTANCE));
    }

    private static FallenTreeConfiguration.FallenTreeConfigurationBuilder createFallenBirch(int i) {
        return SpringToLifeFeatures.createFallenTrees(Blocks.BIRCH_LOG, 5, i);
    }

    private static FallenTreeConfiguration.FallenTreeConfigurationBuilder createFallenJungle() {
        return SpringToLifeFeatures.createFallenTrees(Blocks.JUNGLE_LOG, 4, 11).stumpDecorators((List<TreeDecorator>)ImmutableList.of((Object)TrunkVineDecorator.INSTANCE));
    }

    private static FallenTreeConfiguration.FallenTreeConfigurationBuilder createFallenSpruce() {
        return SpringToLifeFeatures.createFallenTrees(Blocks.SPRUCE_LOG, 6, 10);
    }

    private static FallenTreeConfiguration.FallenTreeConfigurationBuilder createFallenTrees(Block block, int minLength, int maxLength) {
        return new FallenTreeConfiguration.FallenTreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)block), (IntProvider)UniformInt.of((int)minLength, (int)maxLength)).logDecorators((List<TreeDecorator>)ImmutableList.of((Object)((Object)new AttachedToLogsDecorator(0.1f, (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)Blocks.RED_MUSHROOM.defaultBlockState(), 2).add((Object)Blocks.BROWN_MUSHROOM.defaultBlockState(), 1)), List.of(Direction.UP)))));
    }
}

