/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.api.bundle;

import com.blackgear.platform.client.event.screen.HudInteractions;
import com.blackgear.platform.core.networking.PayloadDistributor;
import com.blackgear.platform.core.util.event.CancellableResult;
import com.blackgear.vanillabackport.client.api.bundle.ItemSlotMouseAction;
import com.blackgear.vanillabackport.client.api.bundle.ScrollWheelHandler;
import com.blackgear.vanillabackport.common.api.bundle.BundleFeatures;
import com.blackgear.vanillabackport.core.data.tags.ModItemTags;
import com.blackgear.vanillabackport.core.network.ServerboundSelectBundleItemPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_465;
import net.minecraft.class_8710;
import org.joml.Vector2i;

@Environment(value=EnvType.CLIENT)
public class BundleMouseActions
implements ItemSlotMouseAction {
    public static final BundleMouseActions INSTANCE = new BundleMouseActions();
    private final ScrollWheelHandler scrollWheelHandler = new ScrollWheelHandler();

    public static void bootstrap() {
        HudInteractions.SCROLLING_PRE.register((minecraft, screen, mouseX, mouseY, deltaX, deltaY) -> {
            if (screen instanceof class_465) {
                BundleMouseActions action;
                class_465 container = (class_465)screen;
                class_1735 slot = container.field_2787;
                if (slot != null && slot.method_7681() && (action = INSTANCE).matches(slot) && action.onMouseScrolled(deltaY, slot.field_7874, slot.method_7677())) {
                    if (!BundleFeatures.onBundleUpdate()) {
                        return CancellableResult.PASS;
                    }
                    return CancellableResult.CANCEL;
                }
            }
            return CancellableResult.PASS;
        });
        HudInteractions.STOP_HOVERING.register((minecraft, screen, slot) -> {
            BundleMouseActions action;
            if (slot != null && slot.method_7681() && (action = INSTANCE).matches(slot)) {
                if (!BundleFeatures.onBundleUpdate()) {
                    return;
                }
                action.onStopHovering(slot);
            }
        });
        HudInteractions.SLOT_CLICK.register((minecraft, screen, slot, clickType) -> {
            BundleMouseActions action;
            if (slot != null && slot.method_7681() && (action = INSTANCE).matches(slot)) {
                if (!BundleFeatures.onBundleUpdate()) {
                    return;
                }
                action.onSlotClicked(slot, clickType);
            }
        });
    }

    @Override
    public boolean matches(class_1735 slot) {
        return slot.method_7677().method_31573(ModItemTags.BUNDLES);
    }

    @Override
    public boolean onMouseScrolled(double scrollDelta, int slotId, class_1799 stack) {
        int selectedItemIndex;
        int selectedItem;
        int delta;
        int itemsToShow = BundleFeatures.getNumberOfItemsToShow(stack);
        if (itemsToShow == 0) {
            return false;
        }
        Vector2i scroll = this.scrollWheelHandler.onMouseScroll(scrollDelta);
        int n = delta = scroll.y == 0 ? -scroll.x : scroll.y;
        if (delta != 0 && (selectedItem = BundleFeatures.getSelectedItem(stack)) != (selectedItemIndex = ScrollWheelHandler.getNextScrollWheelSelection(delta, selectedItem, itemsToShow))) {
            this.toggleSelectedBundleItem(stack, slotId, selectedItemIndex);
        }
        return true;
    }

    @Override
    public void onStopHovering(class_1735 slot) {
        this.unselectedBundleItem(slot.method_7677(), slot.field_7874);
    }

    @Override
    public void onSlotClicked(class_1735 slot, class_1713 clickType) {
        if (clickType == class_1713.field_7794 || clickType == class_1713.field_7791) {
            this.unselectedBundleItem(slot.method_7677(), slot.field_7874);
        }
    }

    private void toggleSelectedBundleItem(class_1799 stack, int slotId, int selectedItemIndex) {
        if (selectedItemIndex < BundleFeatures.getNumberOfItemsToShow(stack)) {
            BundleFeatures.toggleSelectedItem(stack, selectedItemIndex);
            PayloadDistributor.sendToServer((class_8710)new ServerboundSelectBundleItemPacket(slotId, selectedItemIndex));
        }
    }

    public void unselectedBundleItem(class_1799 stack, int slotId) {
        this.toggleSelectedBundleItem(stack, slotId, -1);
    }
}

