/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.level.entities.model;

import com.blackgear.vanillabackport.common.level.entities.happyghast.HappyGhast;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HappyGhastModel<T extends HappyGhast>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart[] tentacles = new ModelPart[9];

    public HappyGhastModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body");
        for (int i = 0; i < this.tentacles.length; ++i) {
            this.tentacles[i] = this.body.m_171324_(HappyGhastModel.createTentacleName(i));
        }
    }

    private static String createTentacleName(int index) {
        return "tentacle" + index;
    }

    public static LayerDefinition createBodyLayer(boolean isBaby, CubeDeformation deformation) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f, deformation), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)0.0f));
        if (isBaby) {
            body.m_171599_("inner_body", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-8.0f, -16.0f, -8.0f, 16.0f, 16.0f, 16.0f, deformation.m_171469_(-0.5f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        }
        body.m_171599_(HappyGhastModel.createTentacleName(0), CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, deformation), PartPose.m_171419_((float)-3.75f, (float)7.0f, (float)-5.0f));
        body.m_171599_(HappyGhastModel.createTentacleName(1), CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, deformation), PartPose.m_171419_((float)1.25f, (float)7.0f, (float)-5.0f));
        body.m_171599_(HappyGhastModel.createTentacleName(2), CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, deformation), PartPose.m_171419_((float)6.25f, (float)7.0f, (float)-5.0f));
        body.m_171599_(HappyGhastModel.createTentacleName(3), CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, deformation), PartPose.m_171419_((float)-6.25f, (float)7.0f, (float)0.0f));
        body.m_171599_(HappyGhastModel.createTentacleName(4), CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, deformation), PartPose.m_171419_((float)-1.25f, (float)7.0f, (float)0.0f));
        body.m_171599_(HappyGhastModel.createTentacleName(5), CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, deformation), PartPose.m_171419_((float)3.75f, (float)7.0f, (float)0.0f));
        body.m_171599_(HappyGhastModel.createTentacleName(6), CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, deformation), PartPose.m_171419_((float)-3.75f, (float)7.0f, (float)5.0f));
        body.m_171599_(HappyGhastModel.createTentacleName(7), CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, deformation), PartPose.m_171419_((float)1.25f, (float)7.0f, (float)5.0f));
        body.m_171599_(HappyGhastModel.createTentacleName(8), CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, deformation), PartPose.m_171419_((float)6.25f, (float)7.0f, (float)5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.m_21033_(EquipmentSlot.CHEST)) {
            this.body.f_233553_ = 0.9375f;
            this.body.f_233554_ = 0.9375f;
            this.body.f_233555_ = 0.9375f;
        }
        for (int i = 0; i < this.tentacles.length; ++i) {
            this.tentacles[i].f_104203_ = 0.2f * Mth.m_14031_((float)(ageInTicks * 0.3f + (float)i)) + 0.4f;
        }
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

