/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.api;

import com.blackgear.vanillabackport.client.api.color.LeafColors;
import com.blackgear.vanillabackport.client.level.particles.particleoptions.ColorParticleOption;
import com.blackgear.vanillabackport.client.registries.ModParticles;
import com.blackgear.vanillabackport.core.VanillaBackport;
import com.blackgear.vanillabackport.core.data.tags.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FallingLeavesModule {
    public void makeFallingLeavesParticles(Level level, BlockPos pos, RandomSource random, BlockState state, BlockPos offset) {
        if ((double)random.m_188501_() < (Double)VanillaBackport.CLIENT_CONFIG.fallingLeavesFrequency.get() && !Block.m_49918_((VoxelShape)state.m_60812_((BlockGetter)level, offset), (Direction)Direction.UP)) {
            this.spawnFallingLeavesParticle(level, pos, random);
        }
    }

    private void spawnFallingLeavesParticle(Level level, BlockPos pos, RandomSource random) {
        BlockState state = level.m_8055_(pos);
        if (((Boolean)VanillaBackport.CLIENT_CONFIG.hasFallingLeaves.get()).booleanValue()) {
            ParticleType<ColorParticleOption> particle = null;
            if (state.m_204336_(ModBlockTags.SPAWN_FALLING_LEAVES)) {
                particle = ModParticles.TINTED_LEAVES.get();
            } else if (state.m_204336_(ModBlockTags.SPAWN_FALLING_NEEDLES)) {
                particle = ModParticles.TINTED_NEEDLES.get();
            }
            if (particle != null) {
                ColorParticleOption option = ColorParticleOption.create(particle, LeafColors.getClientLeafTintColor(pos));
                ParticleUtils.m_272037_((Level)level, (BlockPos)pos, (RandomSource)random, (ParticleOptions)option);
            }
        }
    }
}

