/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.api.leash;

import com.blackgear.vanillabackport.core.mixin.access.EntityAccessor;
import com.blackgear.vanillabackport.core.mixin.access.PathfinderMobAccessor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface Leashable {
    public static final Map<Predicate<Entity>, Function<Entity, Vec3[]>> QUAD_LEASH_OFFSETS = (Map)Util.m_137537_(() -> {
        ImmutableMap.Builder offsets = new ImmutableMap.Builder();
        offsets.put(entity -> entity instanceof Camel, entity -> Leashable.vb$createQuadLeashOffsets(entity, 0.02, 0.48, 0.25, 0.82));
        offsets.put(entity -> entity instanceof AbstractHorse, entity -> Leashable.vb$createQuadLeashOffsets(entity, 0.04, 0.52, 0.23, 0.87));
        offsets.put(entity -> entity instanceof AbstractChestedHorse, entity -> Leashable.vb$createQuadLeashOffsets(entity, 0.04, 0.41, 0.18, 0.73));
        offsets.put(entity -> entity instanceof Sniffer, entity -> Leashable.vb$createQuadLeashOffsets(entity, -0.01, 0.63, 0.38, 1.15));
        return offsets.build();
    });
    public static final Vec3 AXIS_SPECIFIC_ELASTICITY = new Vec3(0.8, 0.2, 0.8);
    public static final List<Vec3> ENTITY_ATTACHMENT_POINT = ImmutableList.of((Object)new Vec3(0.0, 0.5, 0.5));
    public static final List<Vec3> LEASHER_ATTACHMENT_POINT = ImmutableList.of((Object)new Vec3(0.0, 0.5, 0.0));
    public static final List<Vec3> SHARED_QUAD_ATTACHMENT_POINTS = ImmutableList.of((Object)new Vec3(-0.5, 0.5, 0.5), (Object)new Vec3(-0.5, 0.5, -0.5), (Object)new Vec3(0.5, 0.5, -0.5), (Object)new Vec3(0.5, 0.5, 0.5));

    default public boolean vb$isLeashed() {
        Leashable leashable = this;
        if (leashable instanceof Mob) {
            Mob mob = (Mob)leashable;
            return mob.m_21523_();
        }
        return false;
    }

    default public boolean vb$canHaveALeashAttachedTo(Entity target) {
        Player player;
        if (this == target) {
            return false;
        }
        return this.vb$leashDistanceTo(target) <= this.vb$leashSnapDistance() && this.vb$canBeLeashed(target instanceof Player ? (player = (Player)target) : null);
    }

    default public void vb$setLeashedTo(Entity entity, boolean sendAttachPacket) {
        Leashable leashable = this;
        if (leashable instanceof Mob) {
            Mob mob = (Mob)leashable;
            mob.m_21463_(entity, sendAttachPacket);
        }
    }

    default public double vb$leashDistanceTo(Entity entity) {
        return entity.m_20191_().m_82399_().m_82554_(((Entity)this).m_20191_().m_82399_());
    }

    default public boolean vb$canBeLeashed(Player entity) {
        Leashable leashable = this;
        if (leashable instanceof Mob) {
            Mob mob = (Mob)leashable;
            return mob.m_6573_(entity);
        }
        return true;
    }

    default public void vb$dropLeash(boolean broadcast, boolean dropItem) {
        Leashable leashable = this;
        if (leashable instanceof Mob) {
            Mob mob = (Mob)leashable;
            mob.m_21455_(broadcast, dropItem);
        }
    }

    public static <E extends Entity> void vb$onTickLeash(E entity) {
        Entity holder = ((Leashable)entity).vb$getLeashHolder();
        if (holder != null && holder.m_9236_() == entity.m_9236_()) {
            TamableAnimal pet;
            double leashDistance = ((Leashable)entity).vb$leashDistanceTo(holder);
            if (entity instanceof TamableAnimal && (pet = (TamableAnimal)entity).m_21825_()) {
                if (leashDistance > ((Leashable)entity).vb$leashSnapDistance()) {
                    ((Leashable)entity).vb$dropLeash(true, true);
                }
                return;
            }
            ((Leashable)entity).vb$whenLeashedTo(holder);
            if (leashDistance > ((Leashable)entity).vb$leashSnapDistance()) {
                entity.m_9236_().m_6269_(null, holder, SoundEvents.f_12033_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                ((Leashable)entity).vb$leashTooFarBehaviour();
            } else if (leashDistance > ((Leashable)entity).vb$leashElasticDistance() - (double)holder.m_20205_() - (double)entity.m_20205_() && ((Leashable)entity).vb$checkElasticInteractions(holder)) {
                ((Leashable)entity).vb$onElasticLeashPull(holder);
            } else {
                ((Leashable)entity).vb$closeRangeLeashBehavior(holder);
            }
            entity.m_146922_((float)((double)entity.m_146908_() - ((Leashable)entity).vb$angularMomentum()));
            ((Leashable)entity).vb$setAngularMomentum(((Leashable)entity).vb$angularMomentum() * (double)Leashable.vb$angularFriction(entity));
        }
    }

    default public void vb$onElasticLeashPull(Entity entity) {
        Leashable leashable = this;
        if (leashable instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)leashable;
            ((PathfinderMobAccessor)((Object)this)).callOnLeashDistance(mob.m_20270_(entity));
        }
        ((Entity)this).m_245125_();
    }

    default public double vb$leashSnapDistance() {
        return 12.0;
    }

    default public double vb$leashElasticDistance() {
        return 6.0;
    }

    public static <E extends Entity> float vb$angularFriction(E entity) {
        if (entity.m_20096_()) {
            return entity.m_9236_().m_8055_(((EntityAccessor)entity).callGetBlockPosBelowThatAffectsMyMovement()).m_60734_().m_49958_() * 0.91f;
        }
        return entity.m_20069_() || entity.m_20077_() ? 0.8f : 0.91f;
    }

    default public void vb$whenLeashedTo(Entity entity) {
        Leashable leashable = this;
        if (leashable instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)leashable;
            mob.m_21446_(entity.m_20183_(), (int)this.vb$leashElasticDistance() - 1);
        }
        if (entity instanceof Leashable) {
            Leashable ext = (Leashable)entity;
            ext.vb$notifyLeashHolder(this);
        }
    }

    default public void vb$notifyLeashHolder(Leashable entity) {
    }

    default public void vb$leashTooFarBehaviour() {
        Leashable leashable = this;
        if (leashable instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)leashable;
            mob.f_21345_.m_25355_(Goal.Flag.MOVE);
        }
        this.vb$dropLeash(true, true);
    }

    default public void vb$closeRangeLeashBehavior(Entity entity) {
        Leashable leashable = this;
        if (leashable instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)leashable;
            if (((PathfinderMobAccessor)((Object)this)).callShouldStayCloseToLeashHolder()) {
                mob.f_21345_.m_25374_(Goal.Flag.MOVE);
                float distanceFromHolder = mob.m_20270_(entity);
                Vec3 movement = new Vec3(entity.m_20185_() - mob.m_20185_(), entity.m_20186_() - mob.m_20186_(), entity.m_20189_() - mob.m_20189_()).m_82541_().m_82490_((double)Math.max(distanceFromHolder - 2.0f, 0.0f));
                mob.m_21573_().m_26519_(mob.m_20185_() + movement.f_82479_, mob.m_20186_() + movement.f_82480_, mob.m_20189_() + movement.f_82481_, ((PathfinderMobAccessor)((Object)this)).callFollowLeashSpeed());
            }
        }
    }

    default public boolean vb$checkElasticInteractions(Entity entity) {
        Leashable holder;
        if (((Entity)this).m_6688_() instanceof Player) {
            return false;
        }
        boolean supportQuadLeash = entity instanceof Leashable && (holder = (Leashable)entity).vb$supportQuadLeashAsHolder() && this.vb$supportQuadLeash();
        List<Wrench> wrenches = Leashable.vb$computeElasticInteraction((Entity)this, entity, supportQuadLeash ? SHARED_QUAD_ATTACHMENT_POINTS : ENTITY_ATTACHMENT_POINT, supportQuadLeash ? SHARED_QUAD_ATTACHMENT_POINTS : LEASHER_ATTACHMENT_POINT);
        if (wrenches.isEmpty()) {
            return false;
        }
        Wrench wrench = Wrench.accumulate(wrenches).scale(supportQuadLeash ? 0.25 : 1.0);
        this.vb$setAngularMomentum(this.vb$angularMomentum() + 10.0 * wrench.torque());
        Vec3 offset = Leashable.vb$getHolderMovement(entity).m_82546_(Leashable.vb$getKnownMovement((Entity)this));
        ((Entity)this).m_246865_(wrench.force().m_82559_(AXIS_SPECIFIC_ELASTICITY).m_82549_(offset.m_82490_(0.11)));
        return true;
    }

    public static Vec3 vb$getHolderMovement(Entity entity) {
        Mob mob;
        return entity instanceof Mob && (mob = (Mob)entity).m_21525_() ? Vec3.f_82478_ : Leashable.vb$getKnownMovement(entity);
    }

    public static Vec3 vb$getKnownMovement(Entity entity) {
        LivingEntity passenger = entity.m_6688_();
        if (passenger instanceof Player) {
            Player player = (Player)passenger;
            if (entity.m_6084_()) {
                return player.m_20184_();
            }
        }
        return entity.m_20184_();
    }

    public static <E extends Entity> List<Wrench> vb$computeElasticInteraction(E entity, Entity holder, List<Vec3> attachmentPoints, List<Vec3> holderAttachmentPoints) {
        double elasticDistance = ((Leashable)entity).vb$leashElasticDistance();
        Vec3 entityMovement = Leashable.vb$getHolderMovement(entity);
        float entityYaw = entity.m_146908_() * ((float)Math.PI / 180);
        Vec3 entityDimensions = new Vec3((double)entity.m_20205_(), (double)entity.m_20206_(), (double)entity.m_20205_());
        float holderYaw = holder.m_146908_() * ((float)Math.PI / 180);
        Vec3 holderDimensions = new Vec3((double)holder.m_20205_(), (double)holder.m_20206_(), (double)holder.m_20205_());
        ArrayList<Wrench> wrenches = new ArrayList<Wrench>();
        for (int i = 0; i < attachmentPoints.size(); ++i) {
            Vec3 entityOffset = attachmentPoints.get(i).m_82559_(entityDimensions).m_82524_(-entityYaw);
            Vec3 entityPosition = entity.m_20182_().m_82549_(entityOffset);
            Vec3 holderOffset = holderAttachmentPoints.get(i).m_82559_(holderDimensions).m_82524_(-holderYaw);
            Vec3 holderPosition = holder.m_20182_().m_82549_(holderOffset);
            Leashable.vb$computeDampenedSpringInteraction(holderPosition, entityPosition, elasticDistance, entityMovement, entityOffset).ifPresent(wrenches::add);
        }
        return wrenches;
    }

    private static Optional<Wrench> vb$computeDampenedSpringInteraction(Vec3 holderPos, Vec3 entityPos, double threshold, Vec3 movement, Vec3 offset) {
        boolean movingWithForce;
        double distance = entityPos.m_82554_(holderPos);
        if (distance < threshold) {
            return Optional.empty();
        }
        Vec3 force = holderPos.m_82546_(entityPos).m_82541_().m_82490_(distance - threshold);
        double torque = Wrench.torqueFromForce(offset, force);
        boolean bl = movingWithForce = movement.m_82526_(force) >= 0.0;
        if (movingWithForce) {
            force = force.m_82490_((double)0.3f);
        }
        return Optional.of(new Wrench(force, torque));
    }

    default public boolean vb$supportQuadLeash() {
        Entity entity = (Entity)this;
        for (Predicate<Entity> filter : QUAD_LEASH_OFFSETS.keySet()) {
            if (!filter.test(entity)) continue;
            return true;
        }
        return false;
    }

    default public boolean vb$supportQuadLeashAsHolder() {
        return false;
    }

    default public Vec3[] vb$getQuadLeashOffsets() {
        Entity entity = (Entity)this;
        for (Predicate<Entity> filter : QUAD_LEASH_OFFSETS.keySet()) {
            if (!filter.test(entity)) continue;
            return QUAD_LEASH_OFFSETS.get(filter).apply(entity);
        }
        return Leashable.vb$createQuadLeashOffsets((Entity)this, 0.0, 0.5, 0.5, 0.5);
    }

    default public Vec3[] vb$getQuadLeashHolderOffsets() {
        return Leashable.vb$createQuadLeashOffsets((Entity)this, 0.0, 0.5, 0.5, 0.0);
    }

    public static Vec3[] vb$createQuadLeashOffsets(Entity entity, double forwardOffset, double sideOffset, double widthOffset, double heightOffset) {
        float entityWidth = entity.m_20205_();
        double forward = forwardOffset * (double)entityWidth;
        double side = sideOffset * (double)entityWidth;
        double width = widthOffset * (double)entityWidth;
        double height = heightOffset * (double)entity.m_20206_();
        return new Vec3[]{new Vec3(-width, height, side + forward), new Vec3(-width, height, -side + forward), new Vec3(width, height, -side + forward), new Vec3(width, height, side + forward)};
    }

    default public Entity vb$getLeashHolder() {
        Leashable leashable = this;
        if (leashable instanceof Mob) {
            Mob mob = (Mob)leashable;
            return mob.m_21524_();
        }
        return null;
    }

    public static List<Leashable> vb$leashableLeashedTo(Entity entity) {
        return Leashable.vb$leashableInArea(entity, leashable -> leashable.vb$getLeashHolder() == entity);
    }

    public static List<Leashable> vb$leashableInArea(Entity entity, Predicate<Leashable> filter) {
        return Leashable.vb$leashableInArea(entity.m_9236_(), entity.m_20191_().m_82399_(), filter);
    }

    public static List<Leashable> vb$leashableInArea(Level level, Vec3 pos, Predicate<Leashable> filter) {
        AABB area = AABB.m_165882_((Vec3)pos, (double)32.0, (double)32.0, (double)32.0);
        return level.m_6443_(Entity.class, area, entity -> {
            Leashable leashable;
            return entity instanceof Leashable && filter.test(leashable = (Leashable)entity);
        }).stream().map(Leashable.class::cast).toList();
    }

    default public void vb$setBoatDelayedLeashHolderId(int leashHolderId) {
    }

    default public double vb$angularMomentum() {
        return 0.0;
    }

    default public void vb$setAngularMomentum(double angularMomentum) {
    }

    public static float vb$getPreciseBodyRotation(Entity entity, float partialTicks) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return Mth.m_14179_((float)partialTicks, (float)living.f_20884_, (float)living.f_20883_);
        }
        return Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_());
    }

    public record Wrench(Vec3 force, double torque) {
        static final Wrench ZERO = new Wrench(Vec3.f_82478_, 0.0);

        static double torqueFromForce(Vec3 position, Vec3 force) {
            return position.f_82481_ * force.f_82479_ - position.f_82479_ * force.f_82481_;
        }

        public static Wrench accumulate(List<Wrench> wrenches) {
            if (wrenches.isEmpty()) {
                return ZERO;
            }
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            double torque = 0.0;
            for (Wrench wrench : wrenches) {
                Vec3 force = wrench.force;
                x += force.f_82479_;
                y += force.f_82480_;
                z += force.f_82481_;
                torque += wrench.torque;
            }
            return new Wrench(new Vec3(x, y, z), torque);
        }

        public Wrench scale(double factor) {
            return new Wrench(this.force.m_82490_(factor), this.torque * factor);
        }
    }
}

