/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.entities.creaking;

import com.blackgear.vanillabackport.common.level.entities.creaking.Creaking;
import com.blackgear.vanillabackport.common.level.entities.creaking.CreakingMeleeAttack;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class CreakingAi {
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Creaking>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_);
    protected static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_148206_, (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26373_);

    static void initCoreActivity(Brain<Creaking> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f){

            protected boolean m_6114_(ServerLevel level, Mob owner) {
                Creaking creaking;
                if (owner instanceof Creaking && (creaking = (Creaking)owner).canMove()) {
                    return super.m_6114_(level, owner);
                }
                return false;
            }
        }, (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    static void initIdleActivity(Brain<Creaking> brain) {
        brain.m_21891_(Activity.f_37979_, 10, ImmutableList.of((Object)StartAttacking.m_257741_(Creaking::isActive, creaking -> creaking.m_6274_().m_21952_(MemoryModuleType.f_148206_)), (Object)SetEntityLookTargetSometimes.m_257458_((float)8.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60)), (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)0.3f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)0.3f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)))));
    }

    static void initFightActivity(Brain<Creaking> brain) {
        brain.m_21895_(Activity.f_37988_, 10, ImmutableList.of((Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)1.0f), CreakingMeleeAttack.create(Creaking::canMove, 40), (Object)StopAttackingIfTargetInvalid.m_257822_()), MemoryModuleType.f_26372_);
    }

    public static Brain.Provider<Creaking> brainProvider() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<Creaking> makeBrain(Brain<Creaking> brain) {
        CreakingAi.initCoreActivity(brain);
        CreakingAi.initIdleActivity(brain);
        CreakingAi.initFightActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    public static void updateActivity(Creaking creaking) {
        if (!creaking.canMove()) {
            creaking.m_6274_().m_21962_();
        } else {
            creaking.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_37988_, (Object)Activity.f_37979_));
        }
    }
}

