/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.worldgen.features;

import com.blackgear.platform.common.worldgen.WorldGenRegistry;
import com.blackgear.vanillabackport.common.level.features.FallenTreeConfiguration;
import com.blackgear.vanillabackport.common.registries.ModBlocks;
import com.blackgear.vanillabackport.common.registries.ModFeatures;
import com.blackgear.vanillabackport.common.worldgen.treedecorators.AttachedToLogsDecorator;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TrunkVineDecorator;

public class SpringToLifeFeatures {
    public static final WorldGenRegistry<ConfiguredFeature<?, ?>> FEATURES = WorldGenRegistry.of((ResourceKey)Registries.f_256911_, (String)"minecraft");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_BUSH = FEATURES.create("patch_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_FIREFLY_BUSH = FEATURES.create("patch_firefly_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILDFLOWERS_BIRCH_FOREST = FEATURES.create("wildflowers_birch_forest");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILDFLOWERS_MEADOW = FEATURES.create("wildflowers_meadow");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_DRY_GRASS = FEATURES.create("patch_dry_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_LEAF_LITTER = FEATURES.create("patch_leaf_litter");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LEAF_LITTER = FEATURES.create("leaf_litter");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_OAK_TREE = FEATURES.create("fallen_oak_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_BIRCH_TREE = FEATURES.create("fallen_birch_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_SUPER_BIRCH_TREE = FEATURES.create("fallen_super_birch_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_JUNGLE_TREE = FEATURES.create("fallen_jungle_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_SPRUCE_TREE = FEATURES.create("fallen_spruce_tree");

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        FEATURES.register(context, PATCH_BUSH, Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(25, 5, 3, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)ModBlocks.BUSH.get())))));
        FEATURES.register(context, PATCH_FIREFLY_BUSH, Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(20, 4, 3, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)ModBlocks.FIREFLY_BUSH.get())))));
        FEATURES.register(context, WILDFLOWERS_BIRCH_FOREST, Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(64, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SpringToLifeFeatures.flowerBedPatchBuilder(ModBlocks.WILDFLOWERS.get()))))));
        FEATURES.register(context, WILDFLOWERS_MEADOW, Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(8, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SpringToLifeFeatures.flowerBedPatchBuilder(ModBlocks.WILDFLOWERS.get()))))));
        FEATURES.register(context, PATCH_DRY_GRASS, Feature.f_65763_, (FeatureConfiguration)SpringToLifeFeatures.grassPatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)ModBlocks.SHORT_DRY_GRASS.get().m_49966_(), 1).m_146271_((Object)ModBlocks.TALL_DRY_GRASS.get().m_49966_(), 1).m_146270_()), 64));
        FEATURES.register(context, PATCH_LEAF_LITTER, Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206470_((int)32, (Holder)PlacementUtils.m_206498_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SpringToLifeFeatures.leafLitterPatchBuilder(1, 3))), (BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.f_190393_, (BlockPredicate)BlockPredicate.m_224774_((Vec3i)Direction.DOWN.m_122436_(), (Block[])new Block[]{Blocks.f_50440_})))));
        FEATURES.register(context, FALLEN_OAK_TREE, ModFeatures.FALLEN_TREE.get(), (FeatureConfiguration)SpringToLifeFeatures.createFallenOak().build());
        FEATURES.register(context, FALLEN_BIRCH_TREE, ModFeatures.FALLEN_TREE.get(), (FeatureConfiguration)SpringToLifeFeatures.createFallenBirch(8).build());
        FEATURES.register(context, FALLEN_SUPER_BIRCH_TREE, ModFeatures.FALLEN_TREE.get(), (FeatureConfiguration)SpringToLifeFeatures.createFallenBirch(15).build());
        FEATURES.register(context, FALLEN_JUNGLE_TREE, ModFeatures.FALLEN_TREE.get(), (FeatureConfiguration)SpringToLifeFeatures.createFallenJungle().build());
        FEATURES.register(context, FALLEN_SPRUCE_TREE, ModFeatures.FALLEN_TREE.get(), (FeatureConfiguration)SpringToLifeFeatures.createFallenSpruce().build());
        FEATURES.register(context, LEAF_LITTER, ModFeatures.LEAF_LITTER.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_);
    }

    private static RandomPatchConfiguration grassPatch(BlockStateProvider provider, int tries) {
        return FeatureUtils.m_206470_((int)tries, (Holder)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration(provider)));
    }

    private static SimpleWeightedRandomList.Builder<BlockState> flowerBedPatchBuilder(Block block) {
        return SpringToLifeFeatures.segmentedBlockPatchBuilder(block, 1, 4, PinkPetalsBlock.f_271373_, (EnumProperty<Direction>)PinkPetalsBlock.f_271347_);
    }

    private static SimpleWeightedRandomList.Builder<BlockState> leafLitterPatchBuilder(int min, int max) {
        return SpringToLifeFeatures.segmentedBlockPatchBuilder(ModBlocks.LEAF_LITTER.get(), min, max, PinkPetalsBlock.f_271373_, (EnumProperty<Direction>)PinkPetalsBlock.f_271347_);
    }

    private static SimpleWeightedRandomList.Builder<BlockState> segmentedBlockPatchBuilder(Block block, int min, int max, IntegerProperty amount, EnumProperty<Direction> facing) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
        for (int i = min; i <= max; ++i) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                builder.m_146271_((Object)((BlockState)((BlockState)block.m_49966_().m_61124_((Property)amount, (Comparable)Integer.valueOf(i))).m_61124_(facing, (Comparable)direction)), 1);
            }
        }
        return builder;
    }

    private static FallenTreeConfiguration.FallenTreeConfigurationBuilder createFallenOak() {
        return SpringToLifeFeatures.createFallenTrees(Blocks.f_49999_, 4, 7).stumpDecorators((List<TreeDecorator>)ImmutableList.of((Object)TrunkVineDecorator.f_70056_));
    }

    private static FallenTreeConfiguration.FallenTreeConfigurationBuilder createFallenBirch(int i) {
        return SpringToLifeFeatures.createFallenTrees(Blocks.f_50001_, 5, i);
    }

    private static FallenTreeConfiguration.FallenTreeConfigurationBuilder createFallenJungle() {
        return SpringToLifeFeatures.createFallenTrees(Blocks.f_50002_, 4, 11).stumpDecorators((List<TreeDecorator>)ImmutableList.of((Object)TrunkVineDecorator.f_70056_));
    }

    private static FallenTreeConfiguration.FallenTreeConfigurationBuilder createFallenSpruce() {
        return SpringToLifeFeatures.createFallenTrees(Blocks.f_50000_, 6, 10);
    }

    private static FallenTreeConfiguration.FallenTreeConfigurationBuilder createFallenTrees(Block block, int minLength, int maxLength) {
        return new FallenTreeConfiguration.FallenTreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)block), (IntProvider)UniformInt.m_146622_((int)minLength, (int)maxLength)).logDecorators((List<TreeDecorator>)ImmutableList.of((Object)((Object)new AttachedToLogsDecorator(0.1f, (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50073_.m_49966_(), 2).m_146271_((Object)Blocks.f_50072_.m_49966_(), 1)), List.of(Direction.UP)))));
    }
}

