/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.mixin.client;

import com.blackgear.vanillabackport.common.api.bundle.BundleFeatures;
import com.blackgear.vanillabackport.core.VanillaBackport;
import com.blackgear.vanillabackport.core.data.tags.ModItemTags;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin<T extends AbstractContainerMenu>
extends Screen
implements MenuAccess<T> {
    @Shadow
    protected int f_97726_;
    @Unique
    private static final ResourceLocation BUNDLE_OPEN_BACK = VanillaBackport.vanilla("textures/item/bundle_open_back.png");
    @Unique
    private static final ResourceLocation BUNDLE_OPEN_FRONT = VanillaBackport.vanilla("textures/item/bundle_open_front.png");

    protected AbstractContainerScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"renderSlot"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$renderBundleContents(GuiGraphics graphics, Slot slot, CallbackInfo ci) {
        ItemStack selectedItem;
        ItemStack stack = slot.m_7993_();
        if (stack.m_204117_(ModItemTags.BUNDLES) && !(selectedItem = BundleFeatures.getSelectedItemStack(stack)).m_41619_()) {
            ResourceLocation backTexture = BUNDLE_OPEN_BACK;
            ResourceLocation frontTexture = BUNDLE_OPEN_FRONT;
            for (DyeColor color : DyeColor.values()) {
                if (!stack.m_150930_(BundleFeatures.getByColor(color)) || stack.m_150930_(Items.f_151058_)) continue;
                backTexture = VanillaBackport.vanilla("textures/item/" + color.m_41065_() + "_bundle_open_back.png");
                frontTexture = VanillaBackport.vanilla("textures/item/" + color.m_41065_() + "_bundle_open_front.png");
                break;
            }
            PoseStack pose = graphics.m_280168_();
            int slotX = slot.f_40220_;
            int slotY = slot.f_40221_;
            pose.m_85836_();
            pose.m_252880_(0.0f, 0.0f, 100.0f);
            graphics.m_280163_(backTexture, slotX, slotY, 0.0f, 0.0f, 16, 16, 16, 16);
            graphics.m_280256_(selectedItem, slotX, slotY, slot.f_40220_ + slot.f_40221_ * this.f_97726_);
            pose.m_85836_();
            pose.m_252880_(0.0f, 0.0f, 200.0f);
            graphics.m_280163_(frontTexture, slotX, slotY, 0.0f, 0.0f, 16, 16, 16, 16);
            graphics.m_280370_(this.f_96547_, stack, slotX, slotY);
            pose.m_85849_();
            pose.m_85849_();
            ci.cancel();
        }
    }
}

