/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.mixin.client.entities.renderer;

import com.blackgear.vanillabackport.client.level.entities.variant.ChickenVariantRenderer;
import com.blackgear.vanillabackport.core.ModChecker;
import com.blackgear.vanillabackport.core.mixin.client.entities.renderer.MobRendererMixin;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ChickenRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChickenRenderer.class})
public abstract class ChickenRendererMixin
extends MobRendererMixin<Chicken, ChickenModel<Chicken>> {
    @Unique
    private ChickenVariantRenderer renderer;

    public ChickenRendererMixin(EntityRendererProvider.Context context, ChickenModel<Chicken> model, float shadowRadius) {
        super(context, model, shadowRadius);
    }

    @Unique
    private ChickenVariantRenderer renderer() {
        if (this.renderer == null) {
            this.renderer = new ChickenVariantRenderer(this.context);
        }
        return this.renderer;
    }

    @Inject(method={"getTextureLocation(Lnet/minecraft/world/entity/animal/Chicken;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$getTextureLocation(Chicken entity, CallbackInfoReturnable<ResourceLocation> cir) {
        if (this.renderer().getTexture(entity) != null) {
            cir.setReturnValue((Object)this.renderer().getTexture(entity));
        }
    }

    public void render(Chicken entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (!ModChecker.MIXED_LITTER_LOADED) {
            this.f_115290_ = (EntityModel)this.renderer().getModel(entity).orElseGet(() -> (ChickenModel)this.defaultModel);
        }
        super.m_7392_((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }
}

