/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.util.codec;

import com.blackgear.vanillabackport.core.util.ColorUtils;
import com.blackgear.vanillabackport.core.util.codec.HolderSetCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import org.joml.Vector4f;

public class AdditionalCodecs {
    public static final Codec<MinMaxBounds.Doubles> DOUBLES = AdditionalCodecs.createCodec(Codec.DOUBLE, (min, max) -> new MinMaxBounds.Doubles((Double)min.orElse(null), (Double)max.orElse(null)));
    public static final Codec<Vector4f> VECTOR4F = Codec.FLOAT.listOf().comapFlatMap(floats -> Util.m_143795_((List)floats, (int)4).map(values -> new Vector4f(((Float)values.get(0)).floatValue(), ((Float)values.get(1)).floatValue(), ((Float)values.get(2)).floatValue(), ((Float)values.get(3)).floatValue())), vector4f -> List.of(Float.valueOf(vector4f.x()), Float.valueOf(vector4f.y()), Float.valueOf(vector4f.z()), Float.valueOf(vector4f.w())));
    public static final Codec<Integer> RGB_COLOR_CODEC = AdditionalCodecs.withAlternative(Codec.INT, ExtraCodecs.f_252432_, vector -> ColorUtils.colorFromFloat(1.0f, vector.x(), vector.y(), vector.z()));
    public static final Codec<Integer> ARGB_COLOR_CODEC = AdditionalCodecs.withAlternative(Codec.INT, VECTOR4F, vector -> ColorUtils.colorFromFloat(vector.w(), vector.x(), vector.y(), vector.z()));

    private static <T, U> Codec<T> withAlternative(Codec<T> primary, Codec<U> alternative, Function<U, T> converter) {
        return Codec.either(primary, alternative).xmap(either -> either.map(t -> t, converter), Either::left);
    }

    private static <T extends Number, R extends MinMaxBounds<T>> Codec<R> createCodec(Codec<T> codec, BoundsFactory<T, R> factory) {
        Codec builder = RecordCodecBuilder.create(instance -> instance.group((App)codec.optionalFieldOf("min").forGetter(bounds -> Optional.ofNullable(bounds.m_55305_())), (App)codec.optionalFieldOf("max").forGetter(bounds -> Optional.ofNullable(bounds.m_55326_()))).apply((Applicative)instance, factory::create));
        return Codec.either((Codec)builder, codec).xmap(either -> (MinMaxBounds)either.map(bounds -> bounds, number -> factory.create(Optional.of(number), Optional.of(number))), bounds -> {
            Optional<Number> max;
            Optional<Number> min = Optional.ofNullable(bounds.m_55305_());
            Optional<Number> optional = min.equals(max = Optional.ofNullable(bounds.m_55326_())) ? min : Optional.empty();
            return optional.map(Either::right).orElseGet(() -> Either.left((Object)bounds));
        });
    }

    public static <E> Codec<HolderSet<E>> homogeneousList(ResourceKey<? extends Registry<E>> resourceKey, Codec<E> codec) {
        return AdditionalCodecs.homogeneousList(resourceKey, codec, false);
    }

    public static <E> Codec<HolderSet<E>> homogeneousList(ResourceKey<? extends Registry<E>> registryKey, Codec<E> codec, boolean disallowInline) {
        return HolderSetCodec.create(registryKey, RegistryFileCodec.m_135589_(registryKey, codec), disallowInline);
    }

    public static <E> Codec<HolderSet<E>> homogeneousList(ResourceKey<? extends Registry<E>> registryKey) {
        return AdditionalCodecs.homogeneousList(registryKey, false);
    }

    public static <E> Codec<HolderSet<E>> homogeneousList(ResourceKey<? extends Registry<E>> registryKey, boolean disallowInline) {
        return HolderSetCodec.create(registryKey, RegistryFixedCodec.m_206740_(registryKey), disallowInline);
    }

    static interface BoundsFactory<T extends Number, R extends MinMaxBounds<T>> {
        public R create(Optional<T> var1, Optional<T> var2);
    }
}

