/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.v2.emissive.fabric;

import com.blackgear.platform.client.v2.emissive.Emissiveness;
import com.blackgear.platform.client.v2.emissive.fabric.BlockSpriteListener;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4696;
import net.minecraft.class_5819;

public class FabricEmissiveLayerBakedModel
extends ForwardingBakedModel {
    private static RenderMaterial[] emissiveMaterials;
    private static final ConcurrentHashMap<class_2680, Boolean> SOLID_RENDER_TYPE_CACHE;

    public FabricEmissiveLayerBakedModel(class_1087 wrapped) {
        this.wrapped = wrapped;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        this.processQuads(context, () -> super.emitBlockQuads(blockView, state, pos, randomSupplier, context), emitter -> new EmissiveBlockQuadTransform((QuadEmitter)emitter, state, context));
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        this.processQuads(context, () -> super.emitItemQuads(stack, randomSupplier, context), EmissiveItemQuadTransform::new);
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    private static RenderMaterial[] getEmissiveMaterials() {
        if (emissiveMaterials == null) {
            emissiveMaterials = FabricEmissiveLayerBakedModel.createEmissiveMaterials();
        }
        return emissiveMaterials;
    }

    private static RenderMaterial[] createEmissiveMaterials() {
        RenderMaterial[] materials = new RenderMaterial[BlendMode.values().length];
        MaterialFinder finder = RendererAccess.INSTANCE.getRenderer().materialFinder();
        for (BlendMode mode : BlendMode.values()) {
            materials[mode.ordinal()] = finder.emissive(true).disableDiffuse(true).ambientOcclusion(TriState.FALSE).blendMode(mode).find();
        }
        return materials;
    }

    private static boolean isDefaultLayerSolid(class_2680 state) {
        return SOLID_RENDER_TYPE_CACHE.computeIfAbsent(state, s -> class_4696.method_23679((class_2680)s) == class_1921.method_23577());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQuads(RenderContext context, Runnable originalEmitter, Function<QuadEmitter, ? extends EmissiveQuadTransform> factory) {
        MeshBuilder meshBuilder = RendererAccess.INSTANCE.getRenderer().meshBuilder();
        EmissiveQuadTransform transformer = factory.apply(meshBuilder.getEmitter());
        context.pushTransform((RenderContext.QuadTransform)transformer);
        try {
            originalEmitter.run();
        }
        finally {
            context.popTransform();
        }
        if (transformer.didEmit()) {
            meshBuilder.build().outputTo(context.getEmitter());
        }
    }

    private static void interpolateUV(MutableQuadView quad, class_1058 from, class_1058 to) {
        float fromU = from.method_4594();
        float fromV = from.method_4593();
        float toU = to.method_4594();
        float toV = to.method_4593();
        float scaleU = (to.method_4577() - toU) / (from.method_4577() - fromU);
        float scaleV = (to.method_4575() - toV) / (from.method_4575() - fromV);
        quad.uv(0, toU + (quad.u(0) - fromU) * scaleU, toV + (quad.v(0) - fromV) * scaleV);
        quad.uv(1, toU + (quad.u(1) - fromU) * scaleU, toV + (quad.v(1) - fromV) * scaleV);
        quad.uv(2, toU + (quad.u(2) - fromU) * scaleU, toV + (quad.v(2) - fromV) * scaleV);
        quad.uv(3, toU + (quad.u(3) - fromU) * scaleU, toV + (quad.v(3) - fromV) * scaleV);
    }

    static {
        SOLID_RENDER_TYPE_CACHE = new ConcurrentHashMap();
    }

    private static abstract class EmissiveQuadTransform
    implements RenderContext.QuadTransform {
        protected final QuadEmitter emitter;
        private int emittedCount = 0;

        protected EmissiveQuadTransform(QuadEmitter emitter) {
            this.emitter = emitter;
        }

        public final boolean didEmit() {
            return this.emittedCount > 0;
        }

        protected final void emitEmissiveQuad(MutableQuadView quad, class_1058 originalSprite, class_1058 emissiveSprite, RenderMaterial material) {
            this.emitter.copyFrom((QuadView)quad);
            this.emitter.material(material);
            FabricEmissiveLayerBakedModel.interpolateUV((MutableQuadView)this.emitter, originalSprite, emissiveSprite);
            this.emitter.emit();
            ++this.emittedCount;
        }

        protected final void tryEmitEmissiveQuad(MutableQuadView quad, RenderMaterial material) {
            class_1058 originalSprite = BlockSpriteListener.getSprites().find((QuadView)quad);
            if (originalSprite == null) {
                return;
            }
            class_1058 emissiveSprite = Emissiveness.INSTANCE.getEmissiveSprite(originalSprite);
            if (emissiveSprite != null) {
                this.emitEmissiveQuad(quad, originalSprite, emissiveSprite, material);
            }
        }
    }

    private static final class EmissiveBlockQuadTransform
    extends EmissiveQuadTransform {
        private final RenderContext renderContext;
        private final boolean isDefaultLayerSolid;

        private EmissiveBlockQuadTransform(QuadEmitter emitter, class_2680 state, RenderContext renderContext) {
            super(emitter);
            this.renderContext = renderContext;
            this.isDefaultLayerSolid = FabricEmissiveLayerBakedModel.isDefaultLayerSolid(state);
        }

        public boolean transform(MutableQuadView quad) {
            if (this.renderContext.isFaceCulled(quad.cullFace())) {
                return false;
            }
            this.tryEmitEmissiveQuad(quad, this.getEmissiveMaterial(quad.material().blendMode()));
            return true;
        }

        private RenderMaterial getEmissiveMaterial(BlendMode mode) {
            RenderMaterial[] materials = FabricEmissiveLayerBakedModel.getEmissiveMaterials();
            return switch (mode) {
                case BlendMode.DEFAULT -> this.getDefaultEmissiveMaterial(materials);
                case BlendMode.SOLID -> materials[BlendMode.CUTOUT_MIPPED.ordinal()];
                default -> materials[mode.ordinal()];
            };
        }

        private RenderMaterial getDefaultEmissiveMaterial(RenderMaterial[] materials) {
            return this.isDefaultLayerSolid ? materials[BlendMode.CUTOUT_MIPPED.ordinal()] : materials[BlendMode.DEFAULT.ordinal()];
        }
    }

    private static final class EmissiveItemQuadTransform
    extends EmissiveQuadTransform {
        private EmissiveItemQuadTransform(QuadEmitter emitter) {
            super(emitter);
        }

        public boolean transform(MutableQuadView quad) {
            this.tryEmitEmissiveQuad(quad, FabricEmissiveLayerBakedModel.getEmissiveMaterials()[BlendMode.DEFAULT.ordinal()]);
            return true;
        }
    }
}

