/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.level.particles.particleoptions;

import com.blackgear.vanillabackport.core.util.ColorUtils;
import com.blackgear.vanillabackport.core.util.codec.AdditionalCodecs;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import java.util.Locale;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2540;
import net.minecraft.class_5253;
import net.minecraft.class_7923;

public class ColorParticleOption
implements class_2394 {
    public static final class_2394.class_2395<ColorParticleOption> DESERIALIZER = new class_2394.class_2395<ColorParticleOption>(){

        public ColorParticleOption fromCommand(class_2396<ColorParticleOption> type, StringReader reader) throws CommandSyntaxException {
            int color = reader.readInt();
            return new ColorParticleOption(type, color);
        }

        public ColorParticleOption fromNetwork(class_2396<ColorParticleOption> type, class_2540 buffer) {
            return new ColorParticleOption(type, buffer.readInt());
        }
    };
    private final class_2396<ColorParticleOption> type;
    private final int color;

    public static Codec<ColorParticleOption> codec(class_2396<ColorParticleOption> type) {
        return AdditionalCodecs.ARGB_COLOR_CODEC.xmap(integer -> new ColorParticleOption(type, (int)integer), option -> option.color).fieldOf("color").codec();
    }

    public ColorParticleOption(class_2396<ColorParticleOption> type, int color) {
        this.type = type;
        this.color = color;
    }

    public class_2396<?> method_10295() {
        return this.type;
    }

    public void method_10294(class_2540 buffer) {
        buffer.writeInt(this.color);
    }

    public String method_10293() {
        return String.format(Locale.ROOT, "%s %d", class_7923.field_41180.method_10221(this.method_10295()), this.color);
    }

    public float getRed() {
        return (float)class_5253.class_5254.method_27765((int)this.color) / 255.0f;
    }

    public float getGreen() {
        return (float)class_5253.class_5254.method_27766((int)this.color) / 255.0f;
    }

    public float getBlue() {
        return (float)class_5253.class_5254.method_27767((int)this.color) / 255.0f;
    }

    public float getAlpha() {
        return (float)class_5253.class_5254.method_27762((int)this.color) / 255.0f;
    }

    public static ColorParticleOption create(class_2396<ColorParticleOption> type, int color) {
        return new ColorParticleOption(type, color);
    }

    public static ColorParticleOption create(class_2396<ColorParticleOption> type, float red, float green, float blue) {
        return new ColorParticleOption(type, ColorUtils.colorFromFloat(1.0f, red, green, blue));
    }
}

