/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common;

import com.blackgear.platform.common.data.LootModifier;
import com.blackgear.platform.common.integration.BlockIntegration;
import com.blackgear.platform.common.integration.MobIntegration;
import com.blackgear.platform.common.integration.MobInteraction;
import com.blackgear.platform.common.integration.TradeIntegration;
import com.blackgear.platform.common.worldgen.modifier.BiomeManager;
import com.blackgear.platform.common.worldgen.placement.BiomePlacement;
import com.blackgear.platform.core.ParallelDispatch;
import com.blackgear.platform.core.events.DataLifecycleEvents;
import com.blackgear.platform.core.events.ResourceReloadManager;
import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.LootIntegrations;
import com.blackgear.vanillabackport.common.api.leash.LeashIntegration;
import com.blackgear.vanillabackport.common.level.dispenser.PaleOakBoatDispenseBehavior;
import com.blackgear.vanillabackport.common.level.entities.armadillo.Armadillo;
import com.blackgear.vanillabackport.common.level.entities.creaking.Creaking;
import com.blackgear.vanillabackport.common.level.entities.happyghast.HappyGhast;
import com.blackgear.vanillabackport.common.registries.ModBlocks;
import com.blackgear.vanillabackport.common.registries.ModEntities;
import com.blackgear.vanillabackport.common.registries.ModItems;
import com.blackgear.vanillabackport.common.resource.ChickenVariantReloadListener;
import com.blackgear.vanillabackport.common.resource.CowVariantReloadListener;
import com.blackgear.vanillabackport.common.resource.PigVariantReloadListener;
import com.blackgear.vanillabackport.common.resource.WolfSoundVariantReloadListener;
import com.blackgear.vanillabackport.common.resource.WolfVariantReloadListener;
import com.blackgear.vanillabackport.common.worldgen.BiomeGeneration;
import com.blackgear.vanillabackport.common.worldgen.WorldGeneration;
import com.blackgear.vanillabackport.core.VanillaBackport;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1317;
import net.minecraft.class_1338;
import net.minecraft.class_1453;
import net.minecraft.class_1628;
import net.minecraft.class_1935;
import net.minecraft.class_2347;
import net.minecraft.class_2357;
import net.minecraft.class_2902;
import net.minecraft.class_3302;
import net.minecraft.class_3853;

public class CommonSetup {
    public static void setup() {
        DataLifecycleEvents.DATA_RELOAD.register(VanillaBackport::onDataReload);
        ResourceReloadManager.registerServer(event -> {
            event.register(VanillaBackport.resource("wolf_sound_variants"), (class_3302)WolfSoundVariantReloadListener.INSTANCE);
            event.register(VanillaBackport.resource("wolf_variants"), (class_3302)new WolfVariantReloadListener());
            event.register(VanillaBackport.resource("cow_variants"), (class_3302)new CowVariantReloadListener());
            event.register(VanillaBackport.resource("chicken_variants"), (class_3302)new ChickenVariantReloadListener());
            event.register(VanillaBackport.resource("pig_variants"), (class_3302)new PigVariantReloadListener());
        });
        MobIntegration.registerIntegrations(CommonSetup::mobIntegrations);
    }

    public static void asyncSetup(ParallelDispatch dispatch) {
        dispatch.enqueueWork(() -> {
            BiomeManager.add(WorldGeneration::bootstrap);
            BiomePlacement.registerBiomePlacements(BiomeGeneration::bootstrap);
            BlockIntegration.registerIntegrations(CommonSetup::blockIntegrations);
            TradeIntegration.registerVillagerTrades(CommonSetup::tradeIntegrations);
            class_1453.field_6822.put(ModEntities.CREAKING.get(), ModSoundEvents.PARROT_IMITATE_CREAKING.get());
        });
        MobIntegration.registerIntegrations(CommonSetup::mobPlacements);
        LootModifier.modify((LootModifier.LootTableModifier)new LootIntegrations());
    }

    public static void blockIntegrations(BlockIntegration.Event event) {
        event.registerFuelItem((class_1935)ModBlocks.SHORT_DRY_GRASS.get(), 100);
        event.registerFuelItem((class_1935)ModBlocks.TALL_DRY_GRASS.get(), 100);
        event.registerFuelItem((class_1935)ModBlocks.LEAF_LITTER.get(), 100);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_PLANKS.get(), 5, 20);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_SLAB.get(), 5, 20);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_FENCE_GATE.get(), 5, 20);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_FENCE.get(), 5, 20);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_STAIRS.get(), 5, 20);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_LOG.get(), 5, 5);
        event.registerFlammableBlock(ModBlocks.STRIPPED_PALE_OAK_LOG.get(), 5, 5);
        event.registerFlammableBlock(ModBlocks.STRIPPED_PALE_OAK_WOOD.get(), 5, 5);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_WOOD.get(), 5, 5);
        event.registerFlammableBlock(ModBlocks.PALE_OAK_LEAVES.get(), 30, 60);
        event.registerFlammableBlock(ModBlocks.PALE_MOSS_BLOCK.get(), 5, 100);
        event.registerFlammableBlock(ModBlocks.PALE_MOSS_CARPET.get(), 5, 100);
        event.registerFlammableBlock(ModBlocks.PALE_HANGING_MOSS.get(), 5, 100);
        event.registerFlammableBlock(ModBlocks.OPEN_EYEBLOSSOM.get(), 60, 100);
        event.registerFlammableBlock(ModBlocks.CLOSED_EYEBLOSSOM.get(), 60, 100);
        event.registerFlammableBlock(ModBlocks.BUSH.get(), 60, 100);
        event.registerFlammableBlock(ModBlocks.FIREFLY_BUSH.get(), 60, 100);
        event.registerFlammableBlock(ModBlocks.WILDFLOWERS.get(), 60, 100);
        event.registerFlammableBlock(ModBlocks.CACTUS_FLOWER.get(), 60, 100);
        event.registerFlammableBlock(ModBlocks.SHORT_DRY_GRASS.get(), 60, 100);
        event.registerFlammableBlock(ModBlocks.TALL_DRY_GRASS.get(), 60, 100);
        event.registerFlammableBlock(ModBlocks.LEAF_LITTER.get(), 60, 100);
        event.registerCompostableItem((class_1935)ModBlocks.PALE_OAK_LEAVES.get(), 0.3f);
        event.registerCompostableItem((class_1935)ModBlocks.PALE_OAK_SAPLING.get(), 0.3f);
        event.registerCompostableItem((class_1935)ModBlocks.PALE_MOSS_CARPET.get(), 0.3f);
        event.registerCompostableItem((class_1935)ModBlocks.PALE_HANGING_MOSS.get(), 0.3f);
        event.registerCompostableItem((class_1935)ModBlocks.PALE_MOSS_BLOCK.get(), 0.3f);
        event.registerCompostableItem((class_1935)ModBlocks.BUSH.get(), 0.3f);
        event.registerCompostableItem((class_1935)ModBlocks.LEAF_LITTER.get(), 0.3f);
        event.registerCompostableItem((class_1935)ModBlocks.FIREFLY_BUSH.get(), 0.3f);
        event.registerCompostableItem((class_1935)ModBlocks.WILDFLOWERS.get(), 0.3f);
        event.registerCompostableItem((class_1935)ModBlocks.CACTUS_FLOWER.get(), 0.3f);
        event.registerCompostableItem((class_1935)ModBlocks.SHORT_DRY_GRASS.get(), 0.3f);
        event.registerCompostableItem((class_1935)ModBlocks.TALL_DRY_GRASS.get(), 0.3f);
        event.registerCompostableItem((class_1935)ModBlocks.OPEN_EYEBLOSSOM.get(), 0.65f);
        event.registerCompostableItem((class_1935)ModBlocks.CLOSED_EYEBLOSSOM.get(), 0.65f);
        event.registerStrippableBlock(ModBlocks.PALE_OAK_LOG.get(), ModBlocks.STRIPPED_PALE_OAK_LOG.get());
        event.registerStrippableBlock(ModBlocks.PALE_OAK_WOOD.get(), ModBlocks.STRIPPED_PALE_OAK_WOOD.get());
        event.registerDispenserBehavior((class_1935)ModItems.PALE_OAK_BOAT.get(), (class_2357)new PaleOakBoatDispenseBehavior());
        event.registerDispenserBehavior((class_1935)ModItems.PALE_OAK_CHEST_BOAT.get(), (class_2357)new PaleOakBoatDispenseBehavior(true));
        event.registerDispenserBehavior((class_1935)ModItems.BLUE_EGG.get(), (class_2357)new class_2347());
        event.registerDispenserBehavior((class_1935)ModItems.BROWN_EGG.get(), (class_2357)new class_2347());
    }

    public static void tradeIntegrations(TradeIntegration.Event event) {
        if (((Boolean)VanillaBackport.COMMON_CONFIG.hasPaleTrades.get()).booleanValue()) {
            event.registerWandererTrade(false, new class_3853.class_1652[]{new class_3853.class_4165(ModBlocks.PALE_OAK_LOG.get(), 1, 8, 4, 1)});
            event.registerWandererTrade(true, new class_3853.class_1652[]{new class_3853.class_4165(ModBlocks.OPEN_EYEBLOSSOM.get(), 1, 1, 7, 1), new class_3853.class_4165(ModBlocks.PALE_OAK_SAPLING.get(), 5, 1, 8, 1), new class_3853.class_4165(ModBlocks.PALE_HANGING_MOSS.get(), 1, 3, 4, 1), new class_3853.class_4165(ModBlocks.PALE_MOSS_BLOCK.get(), 1, 2, 5, 1)});
        }
        if (((Boolean)VanillaBackport.COMMON_CONFIG.hasSpringTrades.get()).booleanValue()) {
            event.registerWandererTrade(true, new class_3853.class_1652[]{new class_3853.class_4165(ModBlocks.WILDFLOWERS.get(), 1, 1, 12, 1), new class_3853.class_4165(ModBlocks.TALL_DRY_GRASS.get(), 1, 1, 12, 1), new class_3853.class_4165(ModBlocks.FIREFLY_BUSH.get(), 3, 1, 12, 1)});
        }
    }

    public static void mobIntegrations(MobIntegration.Event event) {
        event.registerMobInteraction((MobInteraction)new LeashIntegration());
        event.registerAttributes(ModEntities.ARMADILLO, Armadillo::createAttributes);
        event.registerAttributes(ModEntities.CREAKING, Creaking::createAttributes);
        event.registerAttributes(ModEntities.HAPPY_GHAST, HappyGhast::createAttributes);
        event.registerGoal(class_1299.field_6117, 1, mob -> new class_1338((class_1314)mob, Creaking.class, 8.0f, 0.6, 1.2));
        event.registerGoal(class_1299.field_6105, 1, mob -> new class_1338((class_1314)mob, Creaking.class, 8.0f, 0.6, 1.2));
        event.registerGoal(class_1299.field_6065, 3, mob -> new class_1338((class_1314)mob, Creaking.class, 8.0f, 0.6, 1.2));
        event.registerGoal(class_1299.field_6090, 3, mob -> new class_1338((class_1314)mob, Creaking.class, 8.0f, 0.6, 1.2));
        event.registerGoal(mob -> mob instanceof class_1628, 2, mob -> new class_1338((class_1314)mob, Armadillo.class, 6.0f, 1.0, 1.2, entity -> !((Armadillo)((Object)((Object)entity))).isScared()));
    }

    public static void mobPlacements(MobIntegration.Event event) {
        event.registerPlacement(ModEntities.ARMADILLO, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, Armadillo::checkArmadilloSpawnRules);
    }
}

