/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.api.variant;

import com.blackgear.platform.core.BuiltInCoreRegistry;
import com.blackgear.vanillabackport.common.api.variant.PriorityProvider;
import com.blackgear.vanillabackport.common.api.variant.SpawnContext;
import com.blackgear.vanillabackport.common.api.variant.VariantHolder;
import com.blackgear.vanillabackport.core.ModChecker;
import com.blackgear.vanillabackport.core.VanillaBackport;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5425;

public class VariantUtils {
    public static final String VARIANT_KEY = "variant";

    public static <T> T getDefault(BuiltInCoreRegistry<T> registry, class_5321<T> key) {
        return (T)registry.getOrThrow(key);
    }

    public static <T> T getVariant(BuiltInCoreRegistry<T> registry, String id) {
        return (T)registry.get(class_2960.method_12829((String)id));
    }

    public static <T> String getID(BuiltInCoreRegistry<T> registry, T value) {
        return registry.getKey(value).toString();
    }

    public static <T> String getDefaultID(BuiltInCoreRegistry<T> registry, class_5321<T> value) {
        return VariantUtils.getID(registry, VariantUtils.getDefault(registry, value));
    }

    public static <T> boolean matches(BuiltInCoreRegistry<T> registry, T variant, class_5321<T> value) {
        return variant == registry.get(value);
    }

    public static <T> void addVariantSaveData(VariantHolder<T> entity, class_2487 tag, BuiltInCoreRegistry<T> registry) {
        tag.method_10582(VARIANT_KEY, registry.getKey(entity.vb$getVariant()).toString());
    }

    public static <T> void readVariantSaveData(VariantHolder<T> entity, class_2487 tag, BuiltInCoreRegistry<T> registry) {
        Object variant = registry.get(class_2960.method_12829((String)tag.method_10558(VARIANT_KEY)));
        if (variant != null) {
            entity.vb$setVariant(variant);
        }
    }

    public static <T extends PriorityProvider<SpawnContext, ?>> Optional<T> selectVariantToSpawn(SpawnContext context, BuiltInCoreRegistry<T> registry) {
        class_5425 level = context.level();
        return PriorityProvider.pick(registry.values().stream(), entry -> entry, level.method_8409(), context);
    }

    public static <T extends PriorityProvider<SpawnContext, ?>> Optional<T> selectFarmAnimalVariantToSpawn(SpawnContext context, BuiltInCoreRegistry<T> registry, class_5321<T> fallback) {
        if (!((Boolean)VanillaBackport.COMMON_CONFIG.hasFarmAnimalVariants.get()).booleanValue() || ModChecker.MIXED_LITTER_LOADED) {
            return Optional.of((PriorityProvider)registry.getOrThrow(fallback));
        }
        return VariantUtils.selectVariantToSpawn(context, registry);
    }

    public static <T extends PriorityProvider<SpawnContext, ?>> Optional<T> selectWolfVariantToSpawn(SpawnContext context, BuiltInCoreRegistry<T> registry, class_5321<T> fallback) {
        if (ModChecker.BACKPORTED_WOLVES_LOADED || !((Boolean)VanillaBackport.COMMON_CONFIG.hasWolfVariants.get()).booleanValue()) {
            return Optional.of((PriorityProvider)registry.getOrThrow(fallback));
        }
        return VariantUtils.selectVariantToSpawn(context, registry);
    }
}

