/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.entities.armadillo;

import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.level.entities.armadillo.ArmadilloAi;
import com.blackgear.vanillabackport.common.level.entities.armadillo.ArmadilloState;
import com.blackgear.vanillabackport.common.registries.ModBuiltInLootTables;
import com.blackgear.vanillabackport.common.registries.ModEntities;
import com.blackgear.vanillabackport.common.registries.ModEntityDataSerializers;
import com.blackgear.vanillabackport.common.registries.ModItems;
import com.blackgear.vanillabackport.common.registries.ModMemoryModules;
import com.blackgear.vanillabackport.core.data.tags.ModBlockTags;
import com.blackgear.vanillabackport.core.data.tags.ModItemTags;
import com.blackgear.vanillabackport.core.util.AnimationUtils;
import com.blackgear.vanillabackport.core.util.MobUtils;
import com.blackgear.vanillabackport.core.util.TimeUtils;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1330;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1856;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class Armadillo
extends class_1429 {
    public static final class_2940<ArmadilloState> ARMADILLO_STATE = class_2945.method_12791(Armadillo.class, ModEntityDataSerializers.ARMADILLO_STATE);
    public static final class_1856 IS_FOOD = class_1856.method_8106(ModItemTags.ARMADILLO_FOOD);
    private long inStateTicks = 0L;
    public final class_7094 rollOutAnimationState = new class_7094();
    public final class_7094 rollUpAnimationState = new class_7094();
    public final class_7094 peekAnimationState = new class_7094();
    private int scuteTime;
    private boolean peekReceivedClient = false;

    public Armadillo(class_1299<? extends class_1429> entityType, class_1937 level) {
        super(entityType, level);
        this.method_5942().method_6354(true);
        this.scuteTime = this.pickNextScuteDropTime();
    }

    @Nullable
    public class_1296 method_5613(class_3218 level, class_1296 otherParent) {
        return (class_1296)ModEntities.ARMADILLO.get().method_5883((class_1937)level);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 12.0).method_26868(class_5134.field_23719, 0.14);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ARMADILLO_STATE, (Object)ArmadilloState.IDLE);
    }

    public boolean isScared() {
        return this.getState() != ArmadilloState.IDLE;
    }

    public boolean shouldHideInShell() {
        return this.getState().shouldHideInShell(this.inStateTicks);
    }

    public boolean shouldSwitchToScaredState() {
        return this.getState() == ArmadilloState.ROLLING && this.inStateTicks > (long)ArmadilloState.ROLLING.animationDuration();
    }

    public ArmadilloState getState() {
        return (ArmadilloState)((Object)this.field_6011.method_12789(ARMADILLO_STATE));
    }

    public void switchToState(ArmadilloState state) {
        this.field_6011.method_12778(ARMADILLO_STATE, (Object)state);
    }

    public void method_5674(class_2940<?> key) {
        if (ARMADILLO_STATE.equals(key)) {
            this.inStateTicks = 0L;
        }
        super.method_5674(key);
    }

    public class_4095<Armadillo> method_18868() {
        return super.method_18868();
    }

    protected class_4095.class_5303<Armadillo> method_28306() {
        return ArmadilloAi.brainProvider();
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return ArmadilloAi.makeBrain((class_4095<Armadillo>)this.method_28306().method_28335(dynamic));
    }

    protected void method_5958() {
        class_3218 level = (class_3218)this.method_37908();
        class_3695 profiler = level.method_16107();
        profiler.method_15396("armadilloBrain");
        this.method_18868().method_19542(level, (class_1309)this);
        profiler.method_15405("armadilloActivityUpdate");
        ArmadilloAi.updateActivity(this);
        profiler.method_15407();
        if (this.method_5805() && !this.method_6109() && --this.scuteTime <= 0) {
            if (this.dropFromGiftLootTable(level, ModBuiltInLootTables.ARMADILLO_SHED, (serverLevel, stack) -> this.method_5775((class_1799)stack))) {
                this.method_5783(ModSoundEvents.ARMADILLO_SCUTE_DROP.get(), 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
                this.method_32876(class_5712.field_28738);
            }
            this.scuteTime = this.pickNextScuteDropTime();
        }
        super.method_5958();
    }

    private int pickNextScuteDropTime() {
        return this.field_5974.method_43048(20 * TimeUtils.SECONDS_PER_MINUTE * 5) + 20 * TimeUtils.SECONDS_PER_MINUTE * 5;
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.setupAnimationStates();
        }
        if (this.isScared()) {
            float f = this.method_5986();
            float g = this.method_5791();
            float h = class_3532.method_15393((float)(this.field_6283 - g));
            float i = class_3532.method_15363((float)class_3532.method_15393((float)(this.field_6283 - g)), (float)(-f), (float)f);
            float j = g + h - i;
            this.method_5847(j);
        }
        ++this.inStateTicks;
    }

    public float method_17825() {
        return this.method_6109() ? 0.6f : 1.0f;
    }

    private void setupAnimationStates() {
        switch (this.getState()) {
            case IDLE: {
                this.rollOutAnimationState.method_41325();
                this.rollUpAnimationState.method_41325();
                this.peekAnimationState.method_41325();
                break;
            }
            case ROLLING: {
                this.rollOutAnimationState.method_41325();
                this.rollUpAnimationState.method_41324(this.field_6012);
                this.peekAnimationState.method_41325();
                break;
            }
            case SCARED: {
                this.rollOutAnimationState.method_41325();
                this.rollUpAnimationState.method_41325();
                if (this.peekReceivedClient) {
                    this.peekAnimationState.method_41325();
                    this.peekReceivedClient = false;
                }
                if (this.inStateTicks == 0L) {
                    this.peekAnimationState.method_41322(this.field_6012);
                    AnimationUtils.fastForward(this.peekAnimationState, ArmadilloState.SCARED.animationDuration(), 1.0f);
                    break;
                }
                this.peekAnimationState.method_41324(this.field_6012);
                break;
            }
            case UNROLLING: {
                this.rollOutAnimationState.method_41324(this.field_6012);
                this.rollUpAnimationState.method_41325();
                this.peekAnimationState.method_41325();
            }
        }
    }

    public void method_5711(byte id) {
        if (id == 64 && this.method_37908().field_9236) {
            this.peekReceivedClient = true;
            this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), ModSoundEvents.ARMADILLO_PEEK.get(), this.method_5634(), 1.0f, 1.0f, false);
        } else {
            super.method_5711(id);
        }
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(ModItemTags.ARMADILLO_FOOD);
    }

    public static boolean checkArmadilloSpawnRules(class_1299<Armadillo> type, class_1936 level, class_3730 spawnType, class_2338 pos, class_5819 random) {
        return level.method_8320(pos.method_10074()).method_26164(ModBlockTags.ARMADILLO_SPAWNABLE_ON) && Armadillo.method_39448((class_1920)level, (class_2338)pos);
    }

    public boolean isScaredBy(class_1309 entity) {
        if (!this.method_5829().method_1009(7.0, 2.0, 7.0).method_994(entity.method_5829())) {
            return false;
        }
        if (entity.method_6046() == class_1310.field_6289) {
            return true;
        }
        if (this.method_6065() == entity) {
            return true;
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return !player.method_7325() && (player.method_5624() || player.method_5765());
        }
        return false;
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10582("state", this.getState().method_15434());
        compound.method_10569("scute_time", this.scuteTime);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.switchToState(ArmadilloState.fromName(compound.method_10558("state")));
        if (compound.method_10545("scute_time")) {
            this.scuteTime = compound.method_10550("scute_time");
        }
    }

    public void rollUp() {
        if (!this.isScared()) {
            this.stopInPlace();
            this.method_6477();
            this.method_32876(class_5712.field_28725);
            this.method_43077(ModSoundEvents.ARMADILLO_ROLL.get());
            this.switchToState(ArmadilloState.ROLLING);
        }
    }

    public void rollOut() {
        if (this.isScared()) {
            this.method_32876(class_5712.field_28725);
            this.method_43077(ModSoundEvents.ARMADILLO_UNROLL_FINISH.get());
            this.switchToState(ArmadilloState.IDLE);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.isScared()) {
            amount = (amount - 1.0f) / 2.0f;
        }
        return super.method_5643(source, amount);
    }

    protected void method_6074(class_1282 damageSource, float damageAmount) {
        super.method_6074(damageSource, damageAmount);
        if (!this.method_5987() && !this.method_29504()) {
            if (damageSource.method_5529() instanceof class_1309) {
                this.method_18868().method_24525(ModMemoryModules.DANGER_DETECTED_RECENTLY.get(), (Object)true, 80L);
                if (this.canStayRolledUp()) {
                    this.rollUp();
                }
            } else if (this.method_40071() || this.method_5809()) {
                this.rollOut();
            }
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_31574(class_1802.field_42716) && this.brushOffScute()) {
            stack.method_7956(16, (class_1309)player, p -> p.method_20236(hand));
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return this.isScared() ? class_1269.field_5814 : super.method_5992(player, hand);
    }

    public boolean brushOffScute() {
        if (this.method_6109()) {
            return false;
        }
        this.method_5775(new class_1799((class_1935)ModItems.ARMADILLO_SCUTE.get()));
        this.method_32876(class_5712.field_28725);
        this.method_43077(ModSoundEvents.ARMADILLO_BRUSH.get());
        return true;
    }

    public boolean canStayRolledUp() {
        return !MobUtils.isPanicking((class_1314)this) && !this.method_5816() && !this.method_5771() && !this.method_5934() && !this.method_5765() && !this.method_5782();
    }

    public boolean method_6482() {
        return super.method_6482() && !this.isScared();
    }

    public class_3414 method_18869(class_1799 stack) {
        return ModSoundEvents.ARMADILLO_EAT.get();
    }

    @Nullable
    protected class_3414 method_5994() {
        return this.isScared() ? null : ModSoundEvents.ARMADILLO_AMBIENT.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return ModSoundEvents.ARMADILLO_DEATH.get();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return this.isScared() ? ModSoundEvents.ARMADILLO_HURT_REDUCED.get() : ModSoundEvents.ARMADILLO_HURT.get();
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(ModSoundEvents.ARMADILLO_STEP.get(), 0.15f, 1.0f);
    }

    public int method_5986() {
        return this.isScared() ? 0 : 32;
    }

    protected class_1330 method_5963() {
        return new class_1330((class_1308)this){

            public void method_6224() {
                if (!Armadillo.this.isScared()) {
                    super.method_6224();
                }
            }
        };
    }

    public void stopInPlace() {
        this.method_5942().method_6340();
        this.method_5938(0.0f);
        this.method_5976(0.0f);
        this.method_6125(0.0f);
    }

    private boolean dropFromGiftLootTable(class_3218 level, class_2960 key, BiConsumer<class_3218, class_1799> consumer) {
        return this.dropFromLootTable(level, key, builder -> builder.method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1226, (Object)this).method_51875(class_173.field_16235), consumer);
    }

    private boolean dropFromLootTable(class_3218 level, class_2960 key, Function<class_8567.class_8568, class_8567> function, BiConsumer<class_3218, class_1799> consumer) {
        class_8567 lootParams;
        class_52 lootTable = level.method_8503().method_3857().getLootTable(key);
        ObjectArrayList list = lootTable.method_51878(lootParams = function.apply(new class_8567.class_8568(level)));
        if (!list.isEmpty()) {
            list.forEach(stack -> consumer.accept(level, (class_1799)stack));
            return true;
        }
        return false;
    }

    public float method_18381(class_4050 pose) {
        return 0.26f;
    }
}

