/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.entities.armadillo;

import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.level.entities.armadillo.Armadillo;
import com.blackgear.vanillabackport.common.level.entities.armadillo.ArmadilloState;
import com.blackgear.vanillabackport.common.registries.ModEntities;
import com.blackgear.vanillabackport.common.registries.ModMemoryModules;
import com.blackgear.vanillabackport.common.registries.ModSensorTypes;
import com.blackgear.vanillabackport.core.mixin.access.AnimalMakeLoveAccessor;
import com.blackgear.vanillabackport.core.util.TimeUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1429;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4101;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4120;
import net.minecraft.class_4125;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4215;
import net.minecraft.class_4806;
import net.minecraft.class_4818;
import net.minecraft.class_5355;
import net.minecraft.class_5753;
import net.minecraft.class_5754;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6028;
import net.minecraft.class_7687;
import net.minecraft.class_7894;
import net.minecraft.class_7895;
import net.minecraft.class_7898;

public class ArmadilloAi {
    private static final class_6019 ADULT_FOLLOW_RANGE = class_6019.method_35017((int)5, (int)16);
    private static final ImmutableList<class_4149<? extends class_4148<? super Armadillo>>> SENSOR_TYPES = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18469, ModSensorTypes.ARMADILLO_TEMPTATIONS.get(), (Object)class_4149.field_25362, ModSensorTypes.ARMADILLO_SCARE_DETECTED.get());
    private static final ImmutableList<class_4140<?>> MEMORY_TYPES = ImmutableList.of((Object)class_4140.field_39408, (Object)class_4140.field_18451, (Object)class_4140.field_18452, (Object)class_4140.field_18445, (Object)class_4140.field_18446, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_18442, (Object)class_4140.field_28325, (Object)class_4140.field_28326, (Object)class_4140.field_40127, (Object)class_4140.field_28327, (Object[])new class_4140[]{class_4140.field_18448, class_4140.field_25359, ModMemoryModules.DANGER_DETECTED_RECENTLY.get()});
    private static final class_7894<Armadillo> ARMADILLO_ROLLING_OUT = class_7898.method_47224(instance -> instance.group((App)instance.method_47245(ModMemoryModules.DANGER_DETECTED_RECENTLY.get())).apply((Applicative)instance, accessor -> (level, armadillo, gameTime) -> {
        if (armadillo.isScared()) {
            armadillo.rollOut();
            return true;
        }
        return false;
    }));

    public static class_4095.class_5303<Armadillo> brainProvider() {
        return class_4095.method_28311(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected static class_4095<?> makeBrain(class_4095<Armadillo> brain) {
        ArmadilloAi.initCoreActivity(brain);
        ArmadilloAi.initIdleActivity(brain);
        ArmadilloAi.initScaredActivity(brain);
        brain.method_18890(Set.of(class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    private static void initCoreActivity(class_4095<Armadillo> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4125(0.8f), (Object)((Object)new ArmadilloPanic(2.0f)), (Object)new class_4110(45, 90), (Object)new class_4112(){

            protected boolean method_18978(class_3218 level, class_1308 owner) {
                return !((Armadillo)owner).isScared() && super.method_18978(level, owner);
            }
        }, (Object)new class_5753(class_4140.field_28326), (Object)new class_5753(class_4140.field_40127), ARMADILLO_ROLLING_OUT));
    }

    private static void initIdleActivity(class_4095<Armadillo> brain) {
        brain.method_18881(class_4168.field_18595, ImmutableList.of((Object)Pair.of((Object)0, (Object)class_7895.method_47069((class_1299)class_1299.field_6097, (float)6.0f, (class_6019)class_6019.method_35017((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)((Object)new ArmadilloMakeLove(ModEntities.ARMADILLO.get(), 1.0f, 1))), (Object)Pair.of((Object)2, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)new class_5754(entity -> Float.valueOf(1.25f), entity -> entity.method_6109() ? 1.0 : 2.0), (Object)1), (Object)Pair.of((Object)class_5355.method_46896((class_6019)ADULT_FOLLOW_RANGE, (float)1.25f), (Object)1)))), (Object)Pair.of((Object)3, (Object)new class_7687((class_6017)class_6019.method_35017((int)150, (int)250), 30.0f, 0.0f, 0.0f)), (Object)Pair.of((Object)4, (Object)new class_4118((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18457), (List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47014((float)1.0f), (Object)1), (Object)Pair.of((Object)class_4120.method_47104((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1))))));
    }

    private static void initScaredActivity(class_4095<Armadillo> brain) {
        brain.method_24529(class_4168.field_18599, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new ArmadilloBallUp()))), Set.of(Pair.of(ModMemoryModules.DANGER_DETECTED_RECENTLY.get(), (Object)class_4141.field_18456), Pair.of((Object)class_4140.field_39408, (Object)class_4141.field_18457)));
    }

    public static void updateActivity(Armadillo armadillo) {
        armadillo.method_18868().method_24531((List)ImmutableList.of((Object)class_4168.field_18599, (Object)class_4168.field_18595));
    }

    public static class ArmadilloPanic
    extends class_6028 {
        public ArmadilloPanic(float speedMultiplier) {
            super(speedMultiplier, mob -> mob.method_5809() || mob.method_40071());
        }

        protected void method_35064(class_3218 level, class_1314 entity, long gameTime) {
            ((Armadillo)entity).rollOut();
            super.method_35064(level, entity, gameTime);
        }
    }

    public static class ArmadilloMakeLove
    extends class_4806 {
        private final int closeEnoughDistance;

        public ArmadilloMakeLove(class_1299<? extends Armadillo> entityType, float speedModifier, int closeEnoughDistance) {
            super(entityType, speedModifier);
            this.closeEnoughDistance = closeEnoughDistance;
        }

        protected void method_24544(class_3218 level, class_1429 entity, long gameTime) {
            class_1429 animal = ((AnimalMakeLoveAccessor)((Object)this)).callFindValidBreedPartner(entity).get();
            entity.method_18868().method_18878(class_4140.field_18448, (Object)animal);
            animal.method_18868().method_18878(class_4140.field_18448, (Object)entity);
            ArmadilloMakeLove.lockGazeAndWalkToEachOther((class_1309)entity, (class_1309)animal, ((AnimalMakeLoveAccessor)((Object)this)).getSpeedModifier(), this.closeEnoughDistance);
            int i = 60 + entity.method_6051().method_43048(50);
            ((AnimalMakeLoveAccessor)((Object)this)).setSpawnChildAtTime(gameTime + (long)i);
        }

        public static void lockGazeAndWalkToEachOther(class_1309 firstEntity, class_1309 secondEntity, float speed, int distance) {
            ArmadilloMakeLove.lookAtEachOther(firstEntity, secondEntity);
            ArmadilloMakeLove.setWalkAndLookTargetMemoriesToEachOther(firstEntity, secondEntity, speed, distance);
        }

        private static void lookAtEachOther(class_1309 firstEntity, class_1309 secondEntity) {
            class_4215.method_19554((class_1309)firstEntity, (class_1309)secondEntity);
            class_4215.method_19554((class_1309)secondEntity, (class_1309)firstEntity);
        }

        private static void setWalkAndLookTargetMemoriesToEachOther(class_1309 firstEntity, class_1309 secondEntity, float speed, int distance) {
            class_4215.method_24557((class_1309)firstEntity, (class_1297)secondEntity, (float)speed, (int)distance);
            class_4215.method_24557((class_1309)secondEntity, (class_1297)firstEntity, (float)speed, (int)distance);
        }
    }

    public static class ArmadilloBallUp
    extends class_4097<Armadillo> {
        static final int BALL_UP_STAY_IN_STATE = 5 * TimeUtils.SECONDS_PER_MINUTE * 20;
        int nextPeekTimer = 0;
        boolean dangerWasAround;

        public ArmadilloBallUp() {
            super(Map.of(), BALL_UP_STAY_IN_STATE);
        }

        protected void tick(class_3218 level, Armadillo armadillo, long gameTime) {
            super.method_18924(level, (class_1309)armadillo, gameTime);
            if (this.nextPeekTimer > 0) {
                --this.nextPeekTimer;
            }
            if (armadillo.shouldSwitchToScaredState()) {
                armadillo.switchToState(ArmadilloState.SCARED);
                if (armadillo.method_24828()) {
                    armadillo.method_43077(ModSoundEvents.ARMADILLO_LAND.get());
                }
            } else {
                boolean bl;
                ArmadilloState state = armadillo.getState();
                long l = armadillo.method_18868().method_36978(ModMemoryModules.DANGER_DETECTED_RECENTLY.get());
                boolean bl2 = bl = l > 75L;
                if (bl != this.dangerWasAround) {
                    this.nextPeekTimer = this.pickNextPeekTimer(armadillo);
                }
                this.dangerWasAround = bl;
                if (state == ArmadilloState.SCARED) {
                    if (this.nextPeekTimer == 0 && armadillo.method_24828() && bl) {
                        level.method_8421((class_1297)armadillo, (byte)64);
                        this.nextPeekTimer = this.pickNextPeekTimer(armadillo);
                    }
                    if (l < (long)ArmadilloState.UNROLLING.animationDuration()) {
                        armadillo.method_43077(ModSoundEvents.ARMADILLO_UNROLL_START.get());
                        armadillo.switchToState(ArmadilloState.UNROLLING);
                    }
                } else if (state == ArmadilloState.UNROLLING && l > (long)ArmadilloState.UNROLLING.animationDuration()) {
                    armadillo.switchToState(ArmadilloState.SCARED);
                }
            }
        }

        private int pickNextPeekTimer(Armadillo armadillo) {
            return ArmadilloState.SCARED.animationDuration() + armadillo.method_6051().method_39332(100, 400);
        }

        protected boolean checkExtraStartConditions(class_3218 level, Armadillo armadillo) {
            return armadillo.method_24828();
        }

        protected boolean canStillUse(class_3218 level, Armadillo armadillo, long gameTime) {
            return armadillo.getState().isThreatened();
        }

        protected void start(class_3218 level, Armadillo armadillo, long gameTime) {
            armadillo.rollUp();
        }

        protected void stop(class_3218 level, Armadillo armadillo, long gameTime) {
            if (!armadillo.canStayRolledUp()) {
                armadillo.rollOut();
            }
        }
    }
}

