/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.mixin.common.items;

import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.api.bundle.BundleFeatures;
import com.blackgear.vanillabackport.common.api.bundle.BundleSelectionTooltip;
import com.blackgear.vanillabackport.core.util.ColorUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_5536;
import net.minecraft.class_5537;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_5537.class})
public abstract class BundleItemMixin {
    @Unique
    private static final int FULL_BAR_COLOR = ColorUtils.colorFromFloat(1.0f, 1.0f, 0.33f, 0.33f);
    @Unique
    private static final int BAR_COLOR = ColorUtils.colorFromFloat(1.0f, 0.44f, 0.53f, 1.0f);

    @Shadow
    protected abstract void method_38076(class_1297 var1);

    @Shadow
    protected abstract void method_38074(class_1297 var1);

    @Inject(method={"overrideStackedOnOther"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$onOverrideStackedOnOther(class_1799 stack, class_1735 slot, class_5536 action, class_1657 player, CallbackInfoReturnable<Boolean> cir) {
        if (!BundleFeatures.onBundleUpdate()) {
            return;
        }
        class_1799 itemInSlot = slot.method_7677();
        if (action == class_5536.field_27013 && !itemInSlot.method_7960()) {
            if (BundleFeatures.tryTransfer(stack, slot, player) > 0) {
                this.method_38076((class_1297)player);
            } else {
                this.playInsertFailSound((class_1297)player);
            }
            this.broadcastChangesOnContainerMenu(player);
            cir.setReturnValue((Object)true);
        } else if (action == class_5536.field_27014 && itemInSlot.method_7960()) {
            class_1799 removed = BundleFeatures.removeOne(stack);
            if (removed != null) {
                class_1799 inserted = slot.method_32756(removed);
                if (inserted.method_7947() > 0) {
                    BundleFeatures.tryInsert(stack, inserted);
                } else {
                    this.method_38074((class_1297)player);
                }
            }
            this.broadcastChangesOnContainerMenu(player);
            cir.setReturnValue((Object)true);
        } else {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"overrideOtherStackedOnMe"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$onOverrideOtherStackedOnMe(class_1799 stack, class_1799 other, class_1735 slot, class_5536 action, class_1657 player, class_5630 slotAccess, CallbackInfoReturnable<Boolean> cir) {
        if (!BundleFeatures.onBundleUpdate()) {
            return;
        }
        if (action == class_5536.field_27013 && other.method_7960()) {
            BundleFeatures.toggleSelectedItem(stack, -1);
            cir.setReturnValue((Object)false);
        } else if (action == class_5536.field_27013 && !other.method_7960()) {
            if (slot.method_32754(player) && BundleFeatures.tryInsert(stack, other) > 0) {
                this.method_38076((class_1297)player);
            } else {
                this.playInsertFailSound((class_1297)player);
            }
            this.broadcastChangesOnContainerMenu(player);
            cir.setReturnValue((Object)true);
        } else if (action == class_5536.field_27014 && other.method_7960()) {
            class_1799 removed;
            if (slot.method_32754(player) && (removed = BundleFeatures.removeOne(stack)) != null) {
                this.method_38074((class_1297)player);
                slotAccess.method_32332(removed);
            }
            this.broadcastChangesOnContainerMenu(player);
            cir.setReturnValue((Object)true);
        } else {
            BundleFeatures.toggleSelectedItem(stack, -1);
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"dropContents"}, at={@At(value="HEAD")}, cancellable=true)
    private static void vb$dropContents(class_1799 stack, class_1657 player, CallbackInfoReturnable<Boolean> cir) {
        if (!BundleFeatures.onBundleUpdate()) {
            return;
        }
        Optional<class_1799> taken = BundleItemMixin.removeOneFromBundle(stack);
        if (taken.isPresent()) {
            player.method_7328(taken.get(), true);
            cir.setReturnValue((Object)true);
        } else {
            cir.setReturnValue((Object)false);
        }
    }

    @Unique
    private static Optional<class_1799> removeOneFromBundle(class_1799 stack) {
        class_1799 removed = BundleFeatures.removeOne(stack);
        if (removed != null) {
            return Optional.of(removed);
        }
        return Optional.empty();
    }

    @Inject(method={"getBarColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$onGetBarColor(class_1799 stack, CallbackInfoReturnable<Integer> cir) {
        if (!BundleFeatures.onBundleUpdate()) {
            return;
        }
        cir.setReturnValue((Object)(BundleFeatures.getContentWeight(stack) >= 64 ? FULL_BAR_COLOR : BAR_COLOR));
    }

    @Inject(method={"getBarWidth"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$onGetBarWidth(class_1799 stack, CallbackInfoReturnable<Integer> cir) {
        if (!BundleFeatures.onBundleUpdate()) {
            return;
        }
        int weight = BundleFeatures.getContentWeight(stack);
        cir.setReturnValue((Object)Math.min(1 + weight * 12 / 64, 13));
    }

    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$onAppendHoverText(class_1799 stack, class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced, CallbackInfo ci) {
        if (!BundleFeatures.onBundleUpdate()) {
            return;
        }
        ci.cancel();
    }

    @Inject(method={"getTooltipImage"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$onGetTooltipImage(class_1799 stack, CallbackInfoReturnable<Optional<class_5632>> cir) {
        if (!BundleFeatures.onBundleUpdate()) {
            return;
        }
        class_2371 items = class_2371.method_10211();
        BundleFeatures.getContents(stack).forEach(arg_0 -> items.add(arg_0));
        cir.setReturnValue(Optional.of(new BundleSelectionTooltip((class_2371<class_1799>)items, BundleFeatures.getContentWeight(stack), BundleFeatures.getSelectedItem(stack))));
    }

    @Unique
    private void playInsertFailSound(class_1297 entity) {
        entity.method_5783(ModSoundEvents.BUNDLE_INSERT_FAIL.get(), 1.0f, 1.0f);
    }

    @Unique
    private void broadcastChangesOnContainerMenu(class_1657 player) {
        class_1703 menu = player.field_7512;
        if (menu.method_7597(player)) {
            menu.method_7609((class_1263)player.method_31548());
        }
    }
}

