/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.util.codec;

import com.blackgear.vanillabackport.core.util.ColorUtils;
import com.blackgear.vanillabackport.core.util.codec.HolderSetCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_2096;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_5381;
import net.minecraft.class_5699;
import net.minecraft.class_6885;
import net.minecraft.class_6899;
import org.joml.Vector4f;

public class AdditionalCodecs {
    public static final Codec<class_2096.class_2099> DOUBLES = AdditionalCodecs.createCodec(Codec.DOUBLE, (min, max) -> new class_2096.class_2099((Double)min.orElse(null), (Double)max.orElse(null)));
    public static final Codec<Vector4f> VECTOR4F = Codec.FLOAT.listOf().comapFlatMap(floats -> class_156.method_33141((List)floats, (int)4).map(values -> new Vector4f(((Float)values.get(0)).floatValue(), ((Float)values.get(1)).floatValue(), ((Float)values.get(2)).floatValue(), ((Float)values.get(3)).floatValue())), vector4f -> List.of(Float.valueOf(vector4f.x()), Float.valueOf(vector4f.y()), Float.valueOf(vector4f.z()), Float.valueOf(vector4f.w())));
    public static final Codec<Integer> RGB_COLOR_CODEC = AdditionalCodecs.withAlternative(Codec.INT, class_5699.field_40723, vector -> ColorUtils.colorFromFloat(1.0f, vector.x(), vector.y(), vector.z()));
    public static final Codec<Integer> ARGB_COLOR_CODEC = AdditionalCodecs.withAlternative(Codec.INT, VECTOR4F, vector -> ColorUtils.colorFromFloat(vector.w(), vector.x(), vector.y(), vector.z()));

    private static <T, U> Codec<T> withAlternative(Codec<T> primary, Codec<U> alternative, Function<U, T> converter) {
        return Codec.either(primary, alternative).xmap(either -> either.map(t -> t, converter), Either::left);
    }

    private static <T extends Number, R extends class_2096<T>> Codec<R> createCodec(Codec<T> codec, BoundsFactory<T, R> factory) {
        Codec builder = RecordCodecBuilder.create(instance -> instance.group((App)codec.optionalFieldOf("min").forGetter(bounds -> Optional.ofNullable(bounds.method_9038())), (App)codec.optionalFieldOf("max").forGetter(bounds -> Optional.ofNullable(bounds.method_9042()))).apply((Applicative)instance, factory::create));
        return Codec.either((Codec)builder, codec).xmap(either -> (class_2096)either.map(bounds -> bounds, number -> factory.create(Optional.of(number), Optional.of(number))), bounds -> {
            Optional<Number> max;
            Optional<Number> min = Optional.ofNullable(bounds.method_9038());
            Optional<Number> optional = min.equals(max = Optional.ofNullable(bounds.method_9042())) ? min : Optional.empty();
            return optional.map(Either::right).orElseGet(() -> Either.left((Object)bounds));
        });
    }

    public static <E> Codec<class_6885<E>> homogeneousList(class_5321<? extends class_2378<E>> resourceKey, Codec<E> codec) {
        return AdditionalCodecs.homogeneousList(resourceKey, codec, false);
    }

    public static <E> Codec<class_6885<E>> homogeneousList(class_5321<? extends class_2378<E>> registryKey, Codec<E> codec, boolean disallowInline) {
        return HolderSetCodec.create(registryKey, class_5381.method_29749(registryKey, codec), disallowInline);
    }

    public static <E> Codec<class_6885<E>> homogeneousList(class_5321<? extends class_2378<E>> registryKey) {
        return AdditionalCodecs.homogeneousList(registryKey, false);
    }

    public static <E> Codec<class_6885<E>> homogeneousList(class_5321<? extends class_2378<E>> registryKey, boolean disallowInline) {
        return HolderSetCodec.create(registryKey, class_6899.method_40400(registryKey), disallowInline);
    }

    static interface BoundsFactory<T extends Number, R extends class_2096<T>> {
        public R create(Optional<T> var1, Optional<T> var2);
    }
}

