/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.fabric;

import com.blackgear.platform.core.Environment;
import com.blackgear.platform.core.util.config.ConfigBuilder;
import com.blackgear.platform.core.util.config.IConfigSpec;
import com.blackgear.platform.core.util.config.ModConfig;
import com.blackgear.platform.core.util.config.SimpleConfigBuilder;
import com.blackgear.platform.core.util.config.SimpleConfigSpec;
import com.blackgear.platform.fabric.PlatformFabric;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1255;
import net.minecraft.class_310;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;

public class EnvironmentImpl {
    private static final Supplier<Supplier<class_1255<?>>> CLIENT_EXECUTOR = () -> class_310::method_1551;

    public static boolean isClientSide() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public static boolean isProduction() {
        return !FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static boolean hasModLoaded(String modId) {
        Objects.requireNonNull(modId, "Mod ID cannot be null");
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    public static String getModVersion(String modId) {
        Objects.requireNonNull(modId, "Mod ID cannot be null");
        return FabricLoader.getInstance().getModContainer(modId).map(container -> container.getMetadata().getVersion().toString()).orElse(null);
    }

    public static Optional<MinecraftServer> getCurrentServer() {
        return Optional.ofNullable(PlatformFabric.getServer());
    }

    public static class_1255<?> getGameExecutor() {
        if (Environment.isClientSide()) {
            return CLIENT_EXECUTOR.get().get();
        }
        return (class_1255)Environment.getCurrentServer().orElseThrow(() -> new IllegalStateException("No server available"));
    }

    public static Path getGameDir() {
        return FabricLoader.getInstance().getGameDir();
    }

    public static Path getConfigDir() {
        return FabricLoader.getInstance().getConfigDir();
    }

    public static <T> T registerSafeConfig(String modId, ModConfig.Type type, Function<ConfigBuilder, T> spec) {
        Pair<T, SimpleConfigSpec> pair = new SimpleConfigBuilder().configure(spec);
        new ModConfig(type, (IConfigSpec)pair.getRight(), modId);
        return (T)pair.getLeft();
    }

    public static <T> T registerSafeConfig(String modId, ModConfig.Type type, String fileName, Function<ConfigBuilder, T> spec) {
        Pair<T, SimpleConfigSpec> pair = new SimpleConfigBuilder().configure(spec);
        new ModConfig(type, (IConfigSpec)pair.getRight(), modId, fileName);
        return (T)pair.getLeft();
    }

    public static Environment.Loader getLoader() {
        return Environment.Loader.FABRIC;
    }
}

