/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common;

import com.blackgear.platform.core.util.config.ConfigBuilder;

public class CommonConfig {
    public final ConfigBuilder.ConfigValue<Boolean> generateResin;
    public final ConfigBuilder.ConfigValue<Boolean> spawnCreakingFromHearts;
    public final ConfigBuilder.ConfigValue<Boolean> spawnCreakingHeartsFromSaplings;
    public final ConfigBuilder.ConfigValue<Boolean> generatePaleGarden;
    public final ConfigBuilder.ConfigValue<Boolean> paleTradesFromWanderer;
    public final ConfigBuilder.ConfigValue<Boolean> generateDriedGhasts;
    public final ConfigBuilder.ConfigValue<Double> happyGhastSpeedModifier;

    public CommonConfig(ConfigBuilder builder) {
        builder.push("The Garden Awakens");
        this.generateResin = builder.comment("Determine if resin should generate after hitting a creaking").define("generateResin", true);
        this.spawnCreakingFromHearts = builder.comment("Determine if creakings should spawn from creaking hearts").define("spawnCreakingFromHearts", true);
        this.spawnCreakingHeartsFromSaplings = builder.comment("Determine if creaking hearts should spawn from pale oak saplings").define("spawnCreakingHeartsFromSaplings", false);
        this.generatePaleGarden = builder.comment("Determine if Pale Gardens should generate in the overworld").define("generatePaleGarden", true);
        this.paleTradesFromWanderer = builder.comment("Determine if the wandering trader should have trades from the pale garden").define("paleTradesFromWanderer", true);
        builder.pop();
        builder.push("Summer Drop");
        this.generateDriedGhasts = builder.comment("Determine if dried ghasts should generate in Nether Fossils").define("generateDriedGhasts", true);
        this.happyGhastSpeedModifier = builder.comment("Determine the speed of happy ghasts when ridden").defineInRange("happyGhastSpeedModifier", 1.0, 0.0, 10.0);
        builder.pop();
    }
}

