/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.blocks;

import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.level.entities.happyghast.HappyGhast;
import com.blackgear.vanillabackport.common.registries.ModBlockStateProperties;
import com.blackgear.vanillabackport.common.registries.ModEntities;
import net.minecraft.class_10;
import net.minecraft.class_1297;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class DriedGhastBlock
extends class_2383
implements class_3737 {
    public static final int MAX_HYDRATION_LEVEL = 3;
    public static final class_2758 HYDRATION_LEVEL = ModBlockStateProperties.HYDRATION_LEVEL;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final int HYDRATION_TICK_DELAY = 5000;
    private static final class_265 SHAPE = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);

    public DriedGhastBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043)).method_11657((class_2769)HYDRATION_LEVEL, (Comparable)Integer.valueOf(0))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177, HYDRATION_LEVEL, WATERLOGGED});
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        return super.method_9559(state, direction, neighborState, level, pos, neighborPos);
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public int getHydrationLevel(class_2680 state) {
        return (Integer)state.method_11654((class_2769)HYDRATION_LEVEL);
    }

    private boolean isReadyToSpawn(class_2680 state) {
        return this.getHydrationLevel(state) == 3;
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            this.tickWaterlogged(state, level, pos, random);
        } else {
            int hydrationLevel = this.getHydrationLevel(state);
            if (hydrationLevel > 0) {
                level.method_8652(pos, (class_2680)state.method_11657((class_2769)HYDRATION_LEVEL, (Comparable)Integer.valueOf(hydrationLevel - 1)), 2);
            }
        }
    }

    private void tickWaterlogged(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        if (!this.isReadyToSpawn(state)) {
            level.method_8396(null, pos, ModSoundEvents.DRIED_GHAST_TRANSITION.get(), class_3419.field_15245, 1.0f, 1.0f);
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)HYDRATION_LEVEL, (Comparable)Integer.valueOf(this.getHydrationLevel(state) + 1)), 2);
        } else {
            this.spawnGhastling(level, pos, state);
        }
    }

    private void spawnGhastling(class_3218 level, class_2338 pos, class_2680 state) {
        level.method_8650(pos, false);
        HappyGhast ghast = (HappyGhast)ModEntities.HAPPY_GHAST.get().method_5883((class_1937)level);
        if (ghast != null) {
            class_243 center = class_243.method_24955((class_2382)pos);
            ghast.method_7217(true);
            float yRot = DriedGhastBlock.getYRot((class_2350)state.method_11654((class_2769)field_11177));
            ghast.method_5847(yRot);
            ghast.method_23327(center.method_10216(), center.method_10214(), center.method_10215());
            ghast.method_36456(yRot);
            ghast.method_36457(0.0f);
            ghast.method_22862();
            ghast.method_5814(ghast.method_19538().method_10216(), ghast.method_19538().method_10214(), ghast.method_19538().method_10215());
            level.method_8649((class_1297)ghast);
            level.method_43129(null, (class_1297)ghast, ModSoundEvents.GHASTLING_SPAWN.get(), class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    public static float getYRot(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11043 -> 180.0f;
            case class_2350.field_11035 -> 0.0f;
            case class_2350.field_11039 -> 90.0f;
            case class_2350.field_11034 -> -90.0f;
            default -> throw new IllegalStateException("No y-Rot for vertical axis: " + String.valueOf(direction));
        };
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        double x = (double)pos.method_10263() + 0.5;
        double y = (double)pos.method_10264() + 0.5;
        double z = (double)pos.method_10260() + 0.5;
        if (!((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            if (random.method_43048(40) == 0) {
                level.method_8486(x, y, z, ModSoundEvents.DRIED_GHAST_AMBIENT.get(), class_3419.field_15256, 1.0f, 1.0f, false);
            }
            if (random.method_43048(6) == 0) {
                level.method_8406((class_2394)class_2398.field_11251, x, y, z, 0.0, 0.02, 0.0);
            }
        } else {
            if (random.method_43048(40) == 0) {
                level.method_8486(x, y, z, ModSoundEvents.DRIED_GHAST_AMBIENT_WATER.get(), class_3419.field_15256, 1.0f, 1.0f, false);
            }
            if (random.method_43048(6) == 0) {
                level.method_8406((class_2394)class_2398.field_11211, x + (double)((random.method_43057() * 2.0f - 1.0f) / 3.0f), y + 0.4, z + (double)((random.method_43057() * 2.0f - 1.0f) / 3.0f), 0.0, (double)random.method_43057(), 0.0);
            }
        }
    }

    public void method_9514(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        if ((((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue() || (Integer)state.method_11654((class_2769)HYDRATION_LEVEL) > 0) && !level.method_14196().method_8674(pos, (Object)this)) {
            level.method_39279(pos, (class_2248)this, 5000);
        }
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_3610 state = context.method_8045().method_8316(context.method_8037());
        boolean isWaterlogged = state.method_15767(class_3486.field_15517) && state.method_15761() == 8;
        return (class_2680)((class_2680)super.method_9605(context).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged))).method_11657((class_2769)field_11177, (Comparable)context.method_8042().method_10153());
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public boolean method_10310(class_1922 level, class_2338 pos, class_2680 state, class_3611 fluid) {
        return fluid == class_3612.field_15910 || fluid == class_3612.field_15909;
    }

    public boolean method_10311(class_1936 level, class_2338 pos, class_2680 state, class_3610 fluidState) {
        if (!((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue() && fluidState.method_15772() == class_3612.field_15909) {
            if (!level.method_8608()) {
                class_2248.method_9610((class_2680)state, (class_1936)level, (class_2338)pos, null);
                level.method_8652(pos, fluidState.method_15759(), 3);
            }
            return true;
        }
        return super.method_10311(level, pos, state, fluidState);
    }

    public void method_9615(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState, boolean movedByPiston) {
        if ((Integer)state.method_11654((class_2769)HYDRATION_LEVEL) == 0) {
            level.method_8396(null, pos, (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? ModSoundEvents.DRIED_GHAST_PLACE_IN_WATER.get() : ModSoundEvents.DRIED_GHAST_PLACE.get(), class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    public boolean method_9516(class_2680 state, class_1922 level, class_2338 pos, class_10 type) {
        return false;
    }
}

