/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.client.animation.api;

import com.cursedcauldron.wildbackport.client.animation.api.AnimatedModel;
import com.cursedcauldron.wildbackport.client.animation.api.Animation;
import com.cursedcauldron.wildbackport.client.animation.api.Keyframe;
import com.cursedcauldron.wildbackport.client.animation.api.Transformation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1160;
import net.minecraft.class_3532;
import net.minecraft.class_630;

@Environment(value=EnvType.CLIENT)
public class AnimationHelper {
    public static void animate(AnimatedModel<?> model, Animation animation, long runningTime, float speed, class_1160 cache) {
        float runningSeconds = AnimationHelper.getRunningSeconds(animation, runningTime);
        for (Map.Entry<String, List<Transformation>> animations : animation.boneAnimations().entrySet()) {
            Optional<class_630> modelPart = model.getChild(animations.getKey());
            List<Transformation> transformations = animations.getValue();
            modelPart.ifPresent(part -> transformations.forEach(transformation -> {
                Keyframe[] keyframes = transformation.keyframes();
                int start = Math.max(0, class_3532.method_15360((int)0, (int)keyframes.length, i -> runningSeconds <= keyframes[i].timestamp()) - 1);
                int end = Math.min(keyframes.length - 1, start + 1);
                Keyframe frameStart = keyframes[start];
                Keyframe frameEnd = keyframes[end];
                float current = runningSeconds - frameStart.timestamp();
                float delta = class_3532.method_15363((float)(current / (frameEnd.timestamp() - frameStart.timestamp())), (float)0.0f, (float)1.0f);
                frameEnd.interpolation().apply(cache, delta, keyframes, start, end, speed);
                transformation.target().apply((class_630)part, cache);
            }));
        }
    }

    private static float getRunningSeconds(Animation animation, long runningTime) {
        float time = (float)runningTime / 1000.0f;
        return animation.looping() ? time % animation.lengthInSeconds() : time;
    }

    public static class_1160 translate(float x, float y, float z) {
        return new class_1160(x, -y, z);
    }

    public static class_1160 rotation(float x, float y, float z) {
        return new class_1160(x * ((float)Math.PI / 180), y * ((float)Math.PI / 180), z * ((float)Math.PI / 180));
    }

    public static class_1160 scale(double x, double y, double z) {
        return new class_1160((float)(x - 1.0), (float)(y - 1.0), (float)(z - 1.0));
    }
}

