/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.client.animation.api;

import com.cursedcauldron.wildbackport.client.animation.api.Animated;
import com.cursedcauldron.wildbackport.client.animation.api.Keyframe;
import com.cursedcauldron.wildbackport.common.utils.MathUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1160;
import net.minecraft.class_3532;
import net.minecraft.class_630;

@Environment(value=EnvType.CLIENT)
public record Transformation(Target target, Keyframe[] keyframes) {

    public static interface Target {
        public void apply(class_630 var1, class_1160 var2);
    }

    public static interface Interpolation {
        public class_1160 apply(class_1160 var1, float var2, Keyframe[] var3, int var4, int var5, float var6);
    }

    public static class Targets {
        public static final Target TRANSLATE = Animated::translate;
        public static final Target ROTATE = Animated::rotate;
        public static final Target SCALE = Animated::scaleY;
    }

    public static class Interpolations {
        public static final Interpolation LINEAL = (cache, delta, keyframes, start, end, speed) -> {
            class_1160 frameStart = keyframes[start].target();
            class_1160 frameEnd = keyframes[end].target();
            cache.method_4949(class_3532.method_16439((float)delta, (float)frameStart.method_4943(), (float)frameEnd.method_4943()) * speed, class_3532.method_16439((float)delta, (float)frameStart.method_4945(), (float)frameEnd.method_4945()) * speed, class_3532.method_16439((float)delta, (float)frameStart.method_4947(), (float)frameEnd.method_4947()) * speed);
            return cache;
        };
        public static final Interpolation CATMULL = (cache, delta, keyframes, start, end, speed) -> {
            class_1160 frameStartPoint = keyframes[Math.max(0, start - 1)].target();
            class_1160 frameStart = keyframes[start].target();
            class_1160 frameEnd = keyframes[end].target();
            class_1160 frameEndPoint = keyframes[Math.min(keyframes.length - 1, end + 1)].target();
            cache.method_4949(MathUtils.catmullrom(delta, frameStartPoint.method_4943(), frameStart.method_4943(), frameEnd.method_4943(), frameEndPoint.method_4943()) * speed, MathUtils.catmullrom(delta, frameStartPoint.method_4945(), frameStart.method_4945(), frameEnd.method_4945(), frameEndPoint.method_4945()) * speed, MathUtils.catmullrom(delta, frameStartPoint.method_4947(), frameStart.method_4947(), frameEnd.method_4947(), frameEndPoint.method_4947()) * speed);
            return cache;
        };
    }
}

