/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.client.render;

import com.cursedcauldron.wildbackport.client.render.model.ChestBoatModel;
import com.cursedcauldron.wildbackport.common.entities.MangroveBoat;
import com.cursedcauldron.wildbackport.common.entities.access.api.BoatTypes;
import com.google.common.collect.ImmutableMap;
import com.ibm.icu.impl.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5601;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_897;

public class ChestBoatRenderer
extends class_897<MangroveBoat> {
    private final Map<class_1690.class_1692, Pair<class_2960, ChestBoatModel>> boatResources;

    public ChestBoatRenderer(class_5617.class_5618 context, boolean chest) {
        super(context);
        this.field_4673 = 0.8f;
        this.boatResources = (Map)Stream.of(class_1690.class_1692.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)ChestBoatRenderer.getTexture(type, chest), (Object)((Object)this.createModel(context, (class_1690.class_1692)type, chest)))));
    }

    private ChestBoatModel createModel(class_5617.class_5618 context, class_1690.class_1692 type, boolean chest) {
        class_5601 layer = chest ? ChestBoatModel.createChestBoat(type) : class_5602.method_32077((class_1690.class_1692)type);
        return new ChestBoatModel(context.method_32167(layer), chest);
    }

    private static class_2960 getTexture(class_1690.class_1692 type, boolean chested) {
        if (chested) {
            return new class_2960("wildbackport", "textures/entity/chest_boat/" + type.method_7559() + ".png");
        }
        return new class_2960(type == BoatTypes.MANGROVE.get() ? "wildbackport" : "minecraft", "textures/entity/boat/" + type.method_7559() + ".png");
    }

    public void render(MangroveBoat boat, float yaw, float angle, class_4587 stack, class_4597 buffer, int light) {
        float bubbleTilt;
        stack.method_22903();
        stack.method_22904(0.0, 0.375, 0.0);
        stack.method_22907(class_1160.field_20705.method_23214(180.0f - yaw));
        float hurtTilt = (float)boat.method_7533() - angle;
        float damageTilt = boat.method_7554() - angle;
        if (damageTilt < 0.0f) {
            damageTilt = 0.0f;
        }
        if (hurtTilt > 0.0f) {
            stack.method_22907(class_1160.field_20703.method_23214(class_3532.method_15374((float)hurtTilt) * hurtTilt * damageTilt / 10.0f * (float)boat.method_7543()));
        }
        if (!class_3532.method_15347((float)(bubbleTilt = boat.method_7547(angle)), (float)0.0f)) {
            stack.method_22907(new class_1158(new class_1160(1.0f, 0.0f, 1.0f), boat.method_7547(angle), true));
        }
        Pair<class_2960, ChestBoatModel> resource = this.boatResources.get(boat.method_7536());
        class_2960 location = (class_2960)resource.first;
        ChestBoatModel model = (ChestBoatModel)((Object)resource.second);
        stack.method_22905(-1.0f, -1.0f, 1.0f);
        stack.method_22907(class_1160.field_20705.method_23214(90.0f));
        model.setupAnim(boat, angle, 0.0f, -0.1f, 0.0f, 0.0f);
        class_4588 render = buffer.getBuffer(model.method_23500(location));
        model.method_2828(stack, render, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boat.method_5869()) {
            class_4588 waterRender = buffer.getBuffer(class_1921.method_23589());
            model.waterPatch().method_22698(stack, waterRender, light, class_4608.field_21444);
        }
        stack.method_22909();
        super.method_3936((class_1297)boat, yaw, angle, stack, buffer, light);
    }

    public class_2960 getTextureLocation(MangroveBoat boat) {
        return (class_2960)this.boatResources.get((Object)boat.method_7536()).first;
    }
}

