/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.client.render;

import com.cursedcauldron.wildbackport.client.render.model.Drawable;
import com.cursedcauldron.wildbackport.client.render.model.WardenModel;
import com.cursedcauldron.wildbackport.common.entities.Warden;
import com.cursedcauldron.wildbackport.core.mixin.access.RenderStateShardAccessor;
import com.cursedcauldron.wildbackport.core.mixin.access.RenderTypeAccessor;
import java.util.List;
import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_922;

@Environment(value=EnvType.CLIENT)
public class WardenLayerRenderer<T extends Warden, M extends WardenModel<T>>
extends class_3887<T, M> {
    public static final BiFunction<class_2960, Boolean, class_1921> ENTITY_TRANSLUCENT_EMISSIVE = class_156.method_34865((location, create) -> {
        class_1921.class_4688 compositeState = class_1921.class_4688.method_23598().method_34578(RenderStateShardAccessor.getRENDERTYPE_EYES_SHADER()).method_34577((class_4668.class_5939)new class_4668.class_4683(location, false, false)).method_23615(RenderStateShardAccessor.getTRANSLUCENT_TRANSPARENCY()).method_23603(RenderStateShardAccessor.getNO_CULL()).method_23616(RenderStateShardAccessor.getCOLOR_WRITE()).method_23611(RenderStateShardAccessor.getOVERLAY()).method_23617(create.booleanValue());
        return RenderTypeAccessor.callCreate("entity_translucent_emissive", class_290.field_1580, class_293.class_5596.field_27382, 256, true, true, compositeState);
    });
    private final class_2960 texture;
    private final AnimationAngleAdjuster<T> animationAngleAdjuster;
    private final ModelPartVisibility<T, M> modelPartVisibility;

    public WardenLayerRenderer(class_3883<T, M> ctx, class_2960 texture, AnimationAngleAdjuster<T> animationAngleAdjuster, ModelPartVisibility<T, M> modelPartVisibility) {
        super(ctx);
        this.texture = texture;
        this.animationAngleAdjuster = animationAngleAdjuster;
        this.modelPartVisibility = modelPartVisibility;
    }

    public void render(class_4587 stack, class_4597 source, int light, T entity, float angle, float distance, float tickDelta, float animationProgress, float yaw, float pitch) {
        if (!entity.method_5767()) {
            this.updateModelPartVisibility();
            class_4588 consumer = source.getBuffer(ENTITY_TRANSLUCENT_EMISSIVE.apply(this.texture, true));
            ((WardenModel)this.method_17165()).method_2828(stack, consumer, light, class_922.method_23622(entity, (float)0.0f), 1.0f, 1.0f, 1.0f, this.animationAngleAdjuster.apply(entity, tickDelta, animationProgress));
            this.unhideAllModelParts();
        }
    }

    private void updateModelPartVisibility() {
        List<class_630> parts = this.modelPartVisibility.getPartsToDraw((WardenModel)this.method_17165());
        ((WardenModel)this.method_17165()).method_32008().method_32088().forEach(part -> Drawable.of(part).setSkipDraw(true));
        parts.forEach(part -> Drawable.of(part).setSkipDraw(false));
    }

    private void unhideAllModelParts() {
        ((WardenModel)this.method_17165()).method_32008().method_32088().forEach(part -> Drawable.of(part).setSkipDraw(false));
    }

    public static interface AnimationAngleAdjuster<T extends Warden> {
        public float apply(T var1, float var2, float var3);
    }

    public static interface ModelPartVisibility<T extends Warden, M extends class_583<T>> {
        public List<class_630> getPartsToDraw(M var1);
    }
}

