/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.client.render.model;

import com.cursedcauldron.wildbackport.common.entities.MangroveBoat;
import com.google.common.collect.ImmutableList;
import net.minecraft.class_1690;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4595;
import net.minecraft.class_5601;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

public class ChestBoatModel
extends class_4595<MangroveBoat> {
    private final class_630 leftPaddle;
    private final class_630 rightPaddle;
    private final class_630 waterPatch;
    private final ImmutableList<class_630> parts;

    public ChestBoatModel(class_630 root, boolean chest) {
        this.leftPaddle = root.method_32086("left_paddle");
        this.rightPaddle = root.method_32086("right_paddle");
        this.waterPatch = root.method_32086("water_patch");
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object[])new class_630[]{root.method_32086("bottom"), root.method_32086("back"), root.method_32086("front"), root.method_32086("right"), root.method_32086("left"), this.leftPaddle, this.rightPaddle});
        if (chest) {
            builder.add((Object)root.method_32086("chest_bottom"));
            builder.add((Object)root.method_32086("chest_lid"));
            builder.add((Object)root.method_32086("chest_lock"));
        }
        this.parts = builder.build();
    }

    public static class_5607 createBodyModel(boolean chested) {
        class_5609 mesh = new class_5609();
        class_5610 part = mesh.method_32111();
        part.method_32117("bottom", class_5606.method_32108().method_32101(0, 0).method_32097(-14.0f, -9.0f, -3.0f, 28.0f, 16.0f, 3.0f), class_5603.method_32091((float)0.0f, (float)3.0f, (float)1.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        part.method_32117("back", class_5606.method_32108().method_32101(0, 19).method_32097(-13.0f, -7.0f, -1.0f, 18.0f, 6.0f, 2.0f), class_5603.method_32091((float)-15.0f, (float)4.0f, (float)4.0f, (float)0.0f, (float)4.712389f, (float)0.0f));
        part.method_32117("front", class_5606.method_32108().method_32101(0, 27).method_32097(-8.0f, -7.0f, -1.0f, 16.0f, 6.0f, 2.0f), class_5603.method_32091((float)15.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
        part.method_32117("right", class_5606.method_32108().method_32101(0, 35).method_32097(-14.0f, -7.0f, -1.0f, 28.0f, 6.0f, 2.0f), class_5603.method_32091((float)0.0f, (float)4.0f, (float)-9.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        part.method_32117("left", class_5606.method_32108().method_32101(0, 43).method_32097(-14.0f, -7.0f, -1.0f, 28.0f, 6.0f, 2.0f), class_5603.method_32090((float)0.0f, (float)4.0f, (float)9.0f));
        if (chested) {
            part.method_32117("chest_bottom", class_5606.method_32108().method_32101(0, 76).method_32097(0.0f, 0.0f, 0.0f, 12.0f, 8.0f, 12.0f), class_5603.method_32091((float)-2.0f, (float)-5.0f, (float)-6.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f));
            part.method_32117("chest_lid", class_5606.method_32108().method_32101(0, 59).method_32097(0.0f, 0.0f, 0.0f, 12.0f, 4.0f, 12.0f), class_5603.method_32091((float)-2.0f, (float)-9.0f, (float)-6.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f));
            part.method_32117("chest_lock", class_5606.method_32108().method_32101(0, 59).method_32097(0.0f, 0.0f, 0.0f, 2.0f, 4.0f, 1.0f), class_5603.method_32091((float)-1.0f, (float)-6.0f, (float)-1.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f));
        }
        part.method_32117("left_paddle", class_5606.method_32108().method_32101(62, 0).method_32097(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).method_32097(-1.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), class_5603.method_32091((float)3.0f, (float)-5.0f, (float)9.0f, (float)0.0f, (float)0.0f, (float)0.19634955f));
        part.method_32117("right_paddle", class_5606.method_32108().method_32101(62, 20).method_32097(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).method_32097(0.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), class_5603.method_32091((float)3.0f, (float)-5.0f, (float)-9.0f, (float)0.0f, (float)((float)Math.PI), (float)0.19634955f));
        part.method_32117("water_patch", class_5606.method_32108().method_32101(0, 0).method_32097(-14.0f, -9.0f, -3.0f, 28.0f, 16.0f, 3.0f), class_5603.method_32091((float)0.0f, (float)-3.0f, (float)1.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)mesh, (int)128, (int)(chested ? 128 : 64));
    }

    public void setupAnim(MangroveBoat boat, float angle, float distance, float animationProgress, float yaw, float pitch) {
        ChestBoatModel.animatePaddle(boat, 0, this.leftPaddle, angle);
        ChestBoatModel.animatePaddle(boat, 1, this.rightPaddle, angle);
    }

    public ImmutableList<class_630> parts() {
        return this.parts;
    }

    public class_630 waterPatch() {
        return this.waterPatch;
    }

    private static void animatePaddle(MangroveBoat boat, int sigma, class_630 part, float angle) {
        float time = boat.method_7551(sigma, angle);
        part.field_3654 = class_3532.method_37166((float)-1.0471976f, (float)-0.2617994f, (float)((class_3532.method_15374((float)(-time)) + 1.0f) / 2.0f));
        part.field_3675 = class_3532.method_37166((float)-0.7853982f, (float)0.7853982f, (float)((class_3532.method_15374((float)(-time + 1.0f)) + 1.0f) / 2.0f));
        if (sigma == 1) {
            part.field_3675 = (float)Math.PI - part.field_3675;
        }
    }

    public static class_5601 createChestBoat(class_1690.class_1692 type) {
        return new class_5601(new class_2960("wildbackport", "chest_boat/" + type.method_7559()), "main");
    }
}

