/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.client.render.model;

import com.cursedcauldron.wildbackport.client.animation.WardenAnimations;
import com.cursedcauldron.wildbackport.client.animation.api.Animated;
import com.cursedcauldron.wildbackport.client.animation.api.AnimatedModel;
import com.cursedcauldron.wildbackport.common.entities.Warden;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_3532;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

public class WardenModel<T extends Warden>
extends AnimatedModel<T> {
    private final class_630 root;
    protected final class_630 bone;
    protected final class_630 body;
    protected final class_630 head;
    protected final class_630 rightTendril;
    protected final class_630 leftTendril;
    protected final class_630 leftLeg;
    protected final class_630 leftArm;
    protected final class_630 leftRibcage;
    protected final class_630 rightArm;
    protected final class_630 rightLeg;
    protected final class_630 rightRibcage;
    private final List<class_630> tendrils;
    private final List<class_630> justBody;
    private final List<class_630> headAndLimbs;
    private final List<class_630> bodyHeadAndLimbs;

    public WardenModel(class_630 root) {
        super(class_1921::method_23578);
        this.root = root;
        this.bone = root.method_32086("bone");
        this.body = this.bone.method_32086("body");
        this.head = this.body.method_32086("head");
        this.rightLeg = this.bone.method_32086("right_leg");
        this.leftLeg = this.bone.method_32086("left_leg");
        this.rightArm = this.body.method_32086("right_arm");
        this.leftArm = this.body.method_32086("left_arm");
        this.rightTendril = this.head.method_32086("right_tendril");
        this.leftTendril = this.head.method_32086("left_tendril");
        this.rightRibcage = this.body.method_32086("right_ribcage");
        this.leftRibcage = this.body.method_32086("left_ribcage");
        this.tendrils = ImmutableList.of((Object)this.leftTendril, (Object)this.rightTendril);
        this.justBody = ImmutableList.of((Object)this.body);
        this.headAndLimbs = ImmutableList.of((Object)this.head, (Object)this.leftArm, (Object)this.rightArm, (Object)this.leftLeg, (Object)this.rightLeg);
        this.bodyHeadAndLimbs = ImmutableList.of((Object)this.body, (Object)this.head, (Object)this.leftArm, (Object)this.rightArm, (Object)this.leftLeg, (Object)this.rightLeg);
    }

    public static class_5607 createBodyLayer() {
        class_5609 mesh = new class_5609();
        class_5610 root = mesh.method_32111();
        class_5610 bone = root.method_32117("bone", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        class_5610 body = bone.method_32117("body", class_5606.method_32108().method_32101(0, 0).method_32097(-9.0f, -13.0f, -4.0f, 18.0f, 21.0f, 11.0f), class_5603.method_32090((float)0.0f, (float)-21.0f, (float)0.0f));
        body.method_32117("right_ribcage", class_5606.method_32108().method_32101(90, 11).method_32097(-2.0f, -11.0f, -0.1f, 9.0f, 21.0f, 0.0f), class_5603.method_32090((float)-7.0f, (float)-2.0f, (float)-4.0f));
        body.method_32117("left_ribcage", class_5606.method_32108().method_32101(90, 11).method_32096().method_32097(-7.0f, -11.0f, -0.1f, 9.0f, 21.0f, 0.0f).method_32106(false), class_5603.method_32090((float)7.0f, (float)-2.0f, (float)-4.0f));
        class_5610 head = body.method_32117("head", class_5606.method_32108().method_32101(0, 32).method_32097(-8.0f, -16.0f, -5.0f, 16.0f, 16.0f, 10.0f), class_5603.method_32090((float)0.0f, (float)-13.0f, (float)0.0f));
        head.method_32117("right_tendril", class_5606.method_32108().method_32101(52, 32).method_32097(-16.0f, -13.0f, 0.0f, 16.0f, 16.0f, 0.0f), class_5603.method_32090((float)-8.0f, (float)-12.0f, (float)0.0f));
        head.method_32117("left_tendril", class_5606.method_32108().method_32101(58, 0).method_32097(0.0f, -13.0f, 0.0f, 16.0f, 16.0f, 0.0f), class_5603.method_32090((float)8.0f, (float)-12.0f, (float)0.0f));
        body.method_32117("right_arm", class_5606.method_32108().method_32101(44, 50).method_32097(-4.0f, 0.0f, -4.0f, 8.0f, 28.0f, 8.0f), class_5603.method_32090((float)-13.0f, (float)-13.0f, (float)1.0f));
        body.method_32117("left_arm", class_5606.method_32108().method_32101(0, 58).method_32097(-4.0f, 0.0f, -4.0f, 8.0f, 28.0f, 8.0f), class_5603.method_32090((float)13.0f, (float)-13.0f, (float)1.0f));
        bone.method_32117("right_leg", class_5606.method_32108().method_32101(76, 48).method_32097(-3.1f, 0.0f, -3.0f, 6.0f, 13.0f, 6.0f), class_5603.method_32090((float)-5.9f, (float)-13.0f, (float)0.0f));
        bone.method_32117("left_leg", class_5606.method_32108().method_32101(76, 76).method_32097(-2.9f, 0.0f, -3.0f, 6.0f, 13.0f, 6.0f), class_5603.method_32090((float)5.9f, (float)-13.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)mesh, (int)128, (int)128);
    }

    public void setupAnim(T entity, float angle, float distance, float animationProgress, float yaw, float pitch) {
        this.root.method_32088().forEach(Animated::resetToDefault);
        float tickDelta = animationProgress - (float)((Warden)entity).field_6012;
        this.setHeadAngle(yaw, pitch);
        this.setLimbAngles(angle, distance);
        this.setHeadAndBodyAngles(animationProgress);
        this.setTendrilPitches(entity, animationProgress, tickDelta);
        this.animate(((Warden)entity).attackingAnimationState, WardenAnimations.ATTACKING, animationProgress);
        this.animate(((Warden)entity).sonicBoomAnimationState, WardenAnimations.SONIC_BOOM, animationProgress);
        this.animate(((Warden)entity).diggingAnimationState, WardenAnimations.DIGGING, animationProgress);
        this.animate(((Warden)entity).emergingAnimationState, WardenAnimations.EMERGING, animationProgress);
        this.animate(((Warden)entity).roaringAnimationState, WardenAnimations.ROARING, animationProgress);
        this.animate(((Warden)entity).sniffingAnimationState, WardenAnimations.SNIFFING, animationProgress);
    }

    private void setHeadAngle(float yaw, float pitch) {
        this.head.field_3654 = pitch * ((float)Math.PI / 180);
        this.head.field_3675 = yaw * ((float)Math.PI / 180);
    }

    private void setHeadAndBodyAngles(float animationProgress) {
        float angle = animationProgress * 0.1f;
        float cos = class_3532.method_15362((float)angle);
        float sin = class_3532.method_15374((float)angle);
        this.head.field_3674 += 0.06f * cos;
        this.head.field_3654 += 0.06f * sin;
        this.body.field_3674 += 0.025f * sin;
        this.body.field_3654 += 0.025f * cos;
    }

    private void setLimbAngles(float angle, float distance) {
        float roll = Math.min(0.5f, 3.0f * distance);
        float mod = angle * 0.8662f;
        float cos = class_3532.method_15362((float)mod);
        float sin = class_3532.method_15374((float)mod);
        float pitch = Math.min(0.35f, roll);
        this.head.field_3674 += 0.3f * sin * roll;
        this.head.field_3654 += 1.2f * class_3532.method_15362((float)(mod + 1.5707964f)) * pitch;
        this.body.field_3674 = 0.1f * sin * roll;
        this.body.field_3654 = 1.0f * cos * pitch;
        this.leftLeg.field_3654 = 1.0f * cos * roll;
        this.rightLeg.field_3654 = 1.0f * class_3532.method_15362((float)(mod + (float)Math.PI)) * roll;
        this.leftArm.field_3654 = -(0.8f * cos * roll);
        this.leftArm.field_3674 = 0.0f;
        this.rightArm.field_3654 = -(0.8f * sin * roll);
        this.rightArm.field_3674 = 0.0f;
        this.setArmPivots();
    }

    private void setArmPivots() {
        this.leftArm.field_3675 = 0.0f;
        this.leftArm.field_3655 = 1.0f;
        this.leftArm.field_3657 = 13.0f;
        this.leftArm.field_3656 = -13.0f;
        this.rightArm.field_3675 = 0.0f;
        this.rightArm.field_3655 = 1.0f;
        this.rightArm.field_3657 = -13.0f;
        this.rightArm.field_3656 = -13.0f;
    }

    private void setTendrilPitches(T warden, float animationProgress, float tickDelta) {
        float pitch;
        this.leftTendril.field_3654 = pitch = ((Warden)warden).getTendrilPitch(tickDelta) * (float)(Math.cos((double)animationProgress * 2.25) * Math.PI * (double)0.1f);
        this.rightTendril.field_3654 = -pitch;
    }

    public class_630 method_32008() {
        return this.root;
    }

    public List<class_630> getTendrils() {
        return this.tendrils;
    }

    public List<class_630> getBody() {
        return this.justBody;
    }

    public List<class_630> getHeadAndLimbs() {
        return this.headAndLimbs;
    }

    public List<class_630> getBodyHeadAndLimbs() {
        return this.bodyHeadAndLimbs;
    }
}

