/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.blocks;

import com.cursedcauldron.wildbackport.common.blocks.SculkShriekerBlock;
import com.cursedcauldron.wildbackport.common.blocks.SculkSpreadManager;
import com.cursedcauldron.wildbackport.common.blocks.SculkSpreadable;
import com.cursedcauldron.wildbackport.common.registry.WBBlocks;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2431;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4970;

public class SculkBlock
extends class_2431
implements SculkSpreadable {
    public SculkBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    @Override
    public int spread(SculkSpreadManager.Cursor cursor, class_1936 level, class_2338 pos, Random random, SculkSpreadManager manager, boolean shouldConvert) {
        int charge = cursor.getCharge();
        if (charge != 0 && random.nextInt(manager.getSpreadChance()) == 0) {
            class_2338 blockPos = cursor.getPos();
            boolean inRange = blockPos.method_19771((class_2382)pos, (double)manager.getMaxDistance());
            if (!inRange && SculkBlock.shouldNotDecay(level, blockPos)) {
                int chance = manager.getExtraBlockChance();
                if (random.nextInt(chance) < charge) {
                    class_2338 growthPos = blockPos.method_10084();
                    class_2680 state = this.getExtraBlockState(level, growthPos, random, manager.isWorldGen());
                    level.method_8652(growthPos, state, 3);
                    level.method_8396(null, blockPos, state.method_26231().method_10598(), class_3419.field_15245, 1.0f, 1.0f);
                }
                return Math.max(0, charge - chance);
            }
            return random.nextInt(manager.getDecayChance()) != 0 ? charge : charge - (inRange ? 1 : SculkBlock.getDecay(manager, blockPos, pos, charge));
        }
        return charge;
    }

    private static int getDecay(SculkSpreadManager manager, class_2338 source, class_2338 target, int charge) {
        int maxDistance = manager.getMaxDistance();
        float range = class_3532.method_27285((float)((float)Math.sqrt(source.method_10262((class_2382)target)) - (float)maxDistance));
        int distance = class_3532.method_34954((int)(24 - maxDistance));
        float spread = Math.min(1.0f, range / (float)distance);
        return Math.max(1, (int)((float)charge * spread * 0.5f));
    }

    private class_2680 getExtraBlockState(class_1936 level, class_2338 pos, Random random, boolean isWorldGen) {
        class_2680 state = random.nextInt(11) == 0 ? (class_2680)WBBlocks.SCULK_SHRIEKER.get().method_9564().method_11657((class_2769)SculkShriekerBlock.CAN_SUMMON, (Comparable)Boolean.valueOf(isWorldGen)) : class_2246.field_28108.method_9564();
        return state.method_28498((class_2769)class_2741.field_12508) && !level.method_8316(pos).method_15769() ? (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)) : state;
    }

    private static boolean shouldNotDecay(class_1936 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos.method_10084());
        if (state.method_26215() || state.method_27852(class_2246.field_10382) && state.method_26227().method_39360((class_3611)class_3612.field_15910)) {
            int chance = 0;
            for (class_2338 position : class_2338.method_10097((class_2338)pos.method_10069(-4, 0, -4), (class_2338)pos.method_10069(4, 2, 4))) {
                class_2680 growth = level.method_8320(position);
                if (growth.method_27852(class_2246.field_28108) || growth.method_27852(WBBlocks.SCULK_SHRIEKER.get())) {
                    ++chance;
                }
                if (chance <= 2) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void method_9565(class_2680 state, class_3218 level, class_2338 pos, class_1799 stack) {
        if (class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)stack) == 0) {
            this.method_9583(level, pos, 1);
        }
    }

    @Override
    public boolean shouldConvertToSpreadable() {
        return true;
    }
}

