/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.blocks;

import com.cursedcauldron.wildbackport.WildBackport;
import com.cursedcauldron.wildbackport.client.particle.SculkChargeParticleOptions;
import com.cursedcauldron.wildbackport.client.registry.WBParticleTypes;
import com.cursedcauldron.wildbackport.client.registry.WBSoundEvents;
import com.cursedcauldron.wildbackport.common.blocks.SculkSpreadable;
import com.cursedcauldron.wildbackport.common.blocks.SculkVeinBlock;
import com.cursedcauldron.wildbackport.common.tag.WBBlockTags;
import com.cursedcauldron.wildbackport.common.utils.DirectionUtils;
import com.cursedcauldron.wildbackport.common.utils.ModUtils;
import com.cursedcauldron.wildbackport.common.utils.ParticleUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SculkSpreadManager {
    final boolean isWorldGen;
    private final class_6862<class_2248> replaceableBlocks;
    private final int extraBlockChance;
    private final int maxDistance;
    private final int spreadChance;
    private final int decayChance;
    private List<Cursor> cursors = new ArrayList<Cursor>();

    public SculkSpreadManager(boolean isWorldGen, class_6862<class_2248> replaceableBlocks, int extraBlockChance, int maxDistance, int spreadChance, int decayChance) {
        this.isWorldGen = isWorldGen;
        this.replaceableBlocks = replaceableBlocks;
        this.extraBlockChance = extraBlockChance;
        this.maxDistance = maxDistance;
        this.spreadChance = spreadChance;
        this.decayChance = decayChance;
    }

    public static SculkSpreadManager create() {
        return new SculkSpreadManager(false, WBBlockTags.SCULK_REPLACEABLE, 10, 4, 10, 5);
    }

    public static SculkSpreadManager createWorldGen() {
        return new SculkSpreadManager(true, WBBlockTags.SCULK_REPLACEABLE_WORLD_GEN, 50, 1, 5, 10);
    }

    public class_6862<class_2248> getReplaceableBlocks() {
        return this.replaceableBlocks;
    }

    public int getExtraBlockChance() {
        return this.extraBlockChance;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    public int getSpreadChance() {
        return this.spreadChance;
    }

    public int getDecayChance() {
        return this.decayChance;
    }

    public boolean isWorldGen() {
        return this.isWorldGen;
    }

    public void clearCursors() {
        this.cursors.clear();
    }

    public void readTag(class_2487 tag) {
        if (tag.method_10573("cursors", 9)) {
            this.cursors.clear();
            List cursors = Cursor.CODEC.listOf().parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)tag.method_10554("cursors", 10))).resultOrPartial(arg_0 -> ((Logger)WildBackport.LOGGER).error(arg_0)).orElseGet(ArrayList::new);
            int size = Math.min(cursors.size(), 32);
            for (int i = 0; i < size; ++i) {
                this.addCursor((Cursor)cursors.get(i));
            }
        }
    }

    public void writeTag(class_2487 tag) {
        Cursor.CODEC.listOf().encodeStart((DynamicOps)class_2509.field_11560, this.cursors).resultOrPartial(arg_0 -> ((Logger)WildBackport.LOGGER).error(arg_0)).ifPresent(value -> tag.method_10566("cursors", value));
    }

    public void spread(class_2338 pos, int charge) {
        while (charge > 0) {
            int spread = Math.min(charge, 1000);
            this.addCursor(new Cursor(pos, spread));
            charge -= spread;
        }
    }

    private void addCursor(Cursor cursor) {
        if (this.cursors.size() < 32) {
            this.cursors.add(cursor);
        }
    }

    public void tick(class_1936 level, class_2338 pos, Random random, boolean shouldConvert) {
        class_1937 side;
        class_1937 instance;
        class_1937 class_19372 = instance = level instanceof class_1937 ? (side = (class_1937)level) : null;
        if (!this.cursors.isEmpty()) {
            class_2338 position;
            ArrayList<Cursor> cursors = new ArrayList<Cursor>();
            HashMap<class_2338, Cursor> cursorPositions = new HashMap<class_2338, Cursor>();
            Object2IntOpenHashMap positions = new Object2IntOpenHashMap();
            for (Cursor cursor : this.cursors) {
                cursor.spread(level, pos, random, this, shouldConvert);
                if (cursor.charge <= 0) {
                    SculkSpreadManager.applySculkCharge(instance, cursor.getPos(), 0);
                    continue;
                }
                position = cursor.getPos();
                positions.computeInt((Object)position, (blockPos, charge) -> (charge == null ? 0 : charge) + cursor.charge);
                Cursor target = (Cursor)cursorPositions.get(position);
                if (target == null) {
                    cursorPositions.put(position, cursor);
                    cursors.add(cursor);
                    continue;
                }
                if (!this.isWorldGen() && cursor.charge + target.charge <= 1000) {
                    target.merge(cursor);
                    continue;
                }
                cursors.add(cursor);
                if (cursor.charge >= target.charge) continue;
                cursorPositions.put(position, cursor);
            }
            for (Object2IntMap.Entry entry : positions.object2IntEntrySet()) {
                Set<class_2350> directions;
                position = (class_2338)entry.getKey();
                int exp = entry.getIntValue();
                Cursor cursor = (Cursor)cursorPositions.get(position);
                Set<class_2350> set = directions = cursor == null ? null : cursor.getFacings();
                if (exp <= 0 || directions == null) continue;
                int charge2 = (int)(Math.log1p(exp) / (double)2.3f) + 1;
                int data = (charge2 << 6) + SculkVeinBlock.directionsToFlag(directions);
                SculkSpreadManager.applySculkCharge(instance, cursor.getPos(), data);
            }
            this.cursors = cursors;
        }
    }

    public static void applySculkCharge(class_1937 level, class_2338 pos, int data) {
        class_3218 side;
        class_638 side2;
        if (level == null) {
            return;
        }
        Random random = level.method_8409();
        class_638 client = level.method_8608() && level instanceof class_638 ? (side2 = (class_638)level) : null;
        class_3218 server = level instanceof class_3218 ? (side = (class_3218)level) : null;
        int charge = data >> 6;
        if (charge > 0) {
            if (random.nextFloat() < (float)charge * 0.2f) {
                float volume = 0.15f + 0.05f * (float)charge * (float)charge * random.nextFloat();
                float pitch = 0.4f * (float)charge - 0.2f * random.nextFloat();
                if (client != null) {
                    client.method_2947(pos, WBSoundEvents.BLOCK_SCULK_CHARGE, class_3419.field_15245, volume, pitch, false);
                }
            }
            byte facings = (byte)(data & 0x3F);
            class_6019 spread = class_6019.method_35017((int)0, (int)charge);
            Supplier<class_243> velocities = () -> new class_243(class_3532.method_15366((Random)random, (double)-0.005, (double)0.005), class_3532.method_15366((Random)random, (double)-0.005, (double)0.005), class_3532.method_15366((Random)random, (double)-0.005, (double)0.005));
            if (facings == 0) {
                for (class_2350 direction : class_2350.values()) {
                    float roll = direction == class_2350.field_11033 ? (float)Math.PI : 0.0f;
                    double offset = direction == class_2350.field_11036 || direction == class_2350.field_11033 ? 0.32 : 0.57;
                    ParticleUtils.spawnParticles(level, pos, new SculkChargeParticleOptions(roll), (class_6017)spread, direction, velocities, offset);
                }
            } else {
                for (class_2350 direction : DirectionUtils.unpack((byte)data)) {
                    float roll = direction == class_2350.field_11036 ? (float)Math.PI : 0.0f;
                    ParticleUtils.spawnParticles(level, pos, new SculkChargeParticleOptions(roll), (class_6017)spread, direction, velocities, 0.35);
                }
            }
        } else {
            boolean fullBlock;
            if (client != null) {
                client.method_2947(pos, WBSoundEvents.BLOCK_SCULK_CHARGE, class_3419.field_15245, 1.0f, 1.0f, false);
            }
            int tries = (fullBlock = level.method_8320(pos).method_26234((class_1922)level, pos)) ? 40 : 20;
            float spread = fullBlock ? 0.45f : 0.25f;
            for (int i = 0; i < tries; ++i) {
                float x = 2.0f * random.nextFloat() - 1.0f;
                float y = 2.0f * random.nextFloat() - 1.0f;
                float z = 2.0f * random.nextFloat() - 1.0f;
                if (server == null) continue;
                server.method_14199((class_2394)WBParticleTypes.SCULK_CHARGE_POP.get(), (double)pos.method_10263() + 0.5 + (double)(x * spread), (double)pos.method_10264() + 0.5 + (double)(y * spread), (double)pos.method_10260() + 0.5 + (double)(z * spread), 1, (double)(x * 0.07f), (double)(y * 0.07f), (double)(z * 0.07f), 0.0);
            }
        }
    }

    public static class Cursor {
        private static final ObjectArrayList<class_2382> OFFSETS = (ObjectArrayList)class_156.method_654((Object)new ObjectArrayList(18), positions -> class_2338.method_20437((class_2338)new class_2338(-1, -1, -1), (class_2338)new class_2338(1, 1, 1)).filter(pos -> (pos.method_10263() == 0 || pos.method_10264() == 0 || pos.method_10260() == 0) && pos != class_2338.field_10980).map(class_2338::method_10062).forEach(arg_0 -> ((ObjectArrayList)positions).add(arg_0)));
        private class_2338 pos;
        private int charge;
        private int updateDelay;
        private int decayDelay;
        @Nullable
        private Set<class_2350> facings;
        private static final Codec<Set<class_2350>> DIRECTION_SET = class_2350.field_29502.listOf().xmap(directions -> Sets.newEnumSet((Iterable)directions, class_2350.class), Lists::newArrayList);
        public static final Codec<Cursor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("pos").forGetter(Cursor::getPos), (App)Codec.intRange((int)0, (int)1000).fieldOf("charge").orElse((Object)0).forGetter(Cursor::getCharge), (App)Codec.intRange((int)0, (int)1).fieldOf("decay_delay").orElse((Object)1).forGetter(Cursor::getDecayDelay), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("update_delay").orElse((Object)0).forGetter(cursor -> cursor.updateDelay), (App)DIRECTION_SET.optionalFieldOf("facings").forGetter(cursor -> Optional.ofNullable(cursor.getFacings()))).apply((Applicative)instance, Cursor::new));

        private Cursor(class_2338 pos, int charge, int decayDelay, int updateDelay, Optional<Set<class_2350>> facings) {
            this.pos = pos;
            this.charge = charge;
            this.decayDelay = decayDelay;
            this.updateDelay = updateDelay;
            this.facings = facings.orElse(null);
        }

        public Cursor(class_2338 pos, int charge) {
            this(pos, charge, 1, 0, Optional.empty());
        }

        public class_2338 getPos() {
            return this.pos;
        }

        public int getCharge() {
            return this.charge;
        }

        public int getDecayDelay() {
            return this.decayDelay;
        }

        @Nullable
        public Set<class_2350> getFacings() {
            return this.facings;
        }

        private boolean canSpread(class_1936 level, class_2338 pos, boolean isWorldGen) {
            if (this.charge <= 0) {
                return false;
            }
            if (isWorldGen) {
                return true;
            }
            if (level instanceof class_3218) {
                class_3218 server = (class_3218)level;
                return server.method_39425(class_1923.method_37232((class_2338)pos));
            }
            return false;
        }

        public void spread(class_1936 level, class_2338 pos, Random random, SculkSpreadManager spreadManager, boolean shouldConvert) {
            if (this.canSpread(level, pos, spreadManager.isWorldGen)) {
                if (this.updateDelay > 0) {
                    --this.updateDelay;
                } else {
                    class_2680 state = level.method_8320(this.pos);
                    SculkSpreadable spreadable = Cursor.getSpreadable(state);
                    if (shouldConvert && spreadable.spread(level, this.pos, state, this.facings, spreadManager.isWorldGen())) {
                        if (spreadable.shouldConvertToSpreadable()) {
                            state = level.method_8320(this.pos);
                            spreadable = Cursor.getSpreadable(state);
                        }
                        level.method_8396(null, this.pos, WBSoundEvents.BLOCK_SCULK_BREAK, class_3419.field_15245, 1.0f, 1.0f);
                    }
                    this.charge = spreadable.spread(this, level, pos, random, spreadManager, shouldConvert);
                    if (this.charge <= 0) {
                        spreadable.spreadAtSamePosition(level, state, this.pos, random);
                    } else {
                        class_2338 target = Cursor.getSpreadPos(level, this.pos, random);
                        if (target != null) {
                            spreadable.spreadAtSamePosition(level, state, this.pos, random);
                            this.pos = target.method_10062();
                            if (spreadManager.isWorldGen() && !this.pos.method_19771(new class_2382(pos.method_10263(), this.pos.method_10264(), pos.method_10260()), 15.0)) {
                                this.charge = 0;
                                return;
                            }
                            state = level.method_8320(target);
                        }
                        if (state.method_26204() instanceof SculkSpreadable) {
                            this.facings = SculkVeinBlock.collectDirections(state);
                        }
                        this.decayDelay = spreadable.getDecay(this.decayDelay);
                        this.updateDelay = spreadable.getUpdate();
                    }
                }
            }
        }

        void merge(Cursor cursor) {
            this.charge += cursor.charge;
            cursor.charge = 0;
            this.updateDelay = Math.min(this.updateDelay, cursor.updateDelay);
        }

        private static SculkSpreadable getSpreadable(class_2680 state) {
            SculkSpreadable spreadable;
            class_2248 class_22482 = state.method_26204();
            return class_22482 instanceof SculkSpreadable ? (spreadable = (SculkSpreadable)class_22482) : SculkSpreadable.DEFAULT;
        }

        private static List<class_2382> shuffleOffsets(Random random) {
            return ModUtils.copyShuffled(OFFSETS, random);
        }

        @Nullable
        private static class_2338 getSpreadPos(class_1936 level, class_2338 pos, Random random) {
            class_2338.class_2339 target = pos.method_25503();
            class_2338.class_2339 source = pos.method_25503();
            for (class_2382 offset : Cursor.shuffleOffsets(random)) {
                source.method_35831((class_2382)pos, offset);
                class_2680 state = level.method_8320((class_2338)source);
                if (!(state.method_26204() instanceof SculkSpreadable) || !Cursor.canSpread(level, pos, (class_2338)source)) continue;
                target.method_10101((class_2382)source);
                if (!SculkVeinBlock.veinCoversSculkReplaceable(level, state, (class_2338)source)) continue;
                break;
            }
            return target.equals((Object)pos) ? null : target;
        }

        private static boolean canSpread(class_1936 level, class_2338 source, class_2338 target) {
            if (source.method_19455((class_2382)target) == 1) {
                return true;
            }
            class_2338 pos = target.method_10059((class_2382)target);
            class_2350 xAxis = class_2350.method_10169((class_2350.class_2351)class_2350.class_2351.field_11048, (class_2350.class_2352)(pos.method_10263() < 0 ? class_2350.class_2352.field_11060 : class_2350.class_2352.field_11056));
            class_2350 yAxis = class_2350.method_10169((class_2350.class_2351)class_2350.class_2351.field_11052, (class_2350.class_2352)(pos.method_10264() < 0 ? class_2350.class_2352.field_11060 : class_2350.class_2352.field_11056));
            class_2350 zAxis = class_2350.method_10169((class_2350.class_2351)class_2350.class_2351.field_11051, (class_2350.class_2352)(pos.method_10260() < 0 ? class_2350.class_2352.field_11060 : class_2350.class_2352.field_11056));
            if (pos.method_10263() == 0) {
                return Cursor.canSpread(level, source, yAxis) || Cursor.canSpread(level, source, zAxis);
            }
            if (pos.method_10264() == 0) {
                return Cursor.canSpread(level, source, xAxis) || Cursor.canSpread(level, source, zAxis);
            }
            return Cursor.canSpread(level, source, xAxis) || Cursor.canSpread(level, source, yAxis);
        }

        private static boolean canSpread(class_1936 level, class_2338 pos, class_2350 direction) {
            class_2338 facing = pos.method_10093(direction);
            return !level.method_8320(facing).method_26206((class_1922)level, facing, direction.method_10153());
        }
    }
}

