/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.blocks;

import com.cursedcauldron.wildbackport.client.registry.WBSoundEvents;
import com.cursedcauldron.wildbackport.common.blocks.SculkSpreadManager;
import com.cursedcauldron.wildbackport.common.blocks.SculkSpreadable;
import com.cursedcauldron.wildbackport.common.registry.WBBlocks;
import com.cursedcauldron.wildbackport.common.tag.WBBlockTags;
import com.cursedcauldron.wildbackport.common.utils.DirectionUtils;
import com.cursedcauldron.wildbackport.common.worldgen.VeinGrower;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5778;
import net.minecraft.class_6862;

public class SculkVeinBlock
extends class_5778
implements SculkSpreadable,
class_3737 {
    private static final class_2746 WATERLOGGED = class_2741.field_12508;
    public final VeinGrower allGrowTypeGrower = new VeinGrower(new SculkVeinGrowChecker(VeinGrower.GROW_TYPES));
    private final VeinGrower samePositionOnlyGrower = new VeinGrower(new SculkVeinGrowChecker(VeinGrower.GrowType.SAME_POSITION));

    public SculkVeinBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VeinGrower getAllGrowTypeGrower() {
        return this.allGrowTypeGrower;
    }

    public VeinGrower getSamePositionOnlyGrower() {
        return this.samePositionOnlyGrower;
    }

    public static boolean place(class_1936 level, class_2338 pos, class_2680 state, Collection<class_2350> directions) {
        boolean canPlace = false;
        class_2680 veinState = WBBlocks.SCULK_VEIN.get().method_9564();
        for (class_2350 direction : directions) {
            class_2338 blockPos;
            if (!SculkVeinBlock.canGrowOn((class_1922)level, direction, blockPos = pos.method_10093(direction), level.method_8320(blockPos))) continue;
            veinState = (class_2680)veinState.method_11657((class_2769)SculkVeinBlock.method_33374((class_2350)direction), (Comparable)Boolean.valueOf(true));
            canPlace = true;
        }
        if (!canPlace) {
            return false;
        }
        if (!state.method_26227().method_15769()) {
            veinState = (class_2680)veinState.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        level.method_8652(pos, veinState, 3);
        return true;
    }

    @Override
    public void spreadAtSamePosition(class_1936 level, class_2680 state, class_2338 pos, Random random) {
        if (state.method_27852((class_2248)this)) {
            for (class_2350 direction : field_28421) {
                class_2746 property = SculkVeinBlock.method_33374((class_2350)direction);
                if (!((Boolean)state.method_11654((class_2769)property)).booleanValue() || !level.method_8320(pos.method_10093(direction)).method_27852(WBBlocks.SCULK.get())) continue;
                state = (class_2680)state.method_11657((class_2769)property, (Comparable)Boolean.valueOf(false));
            }
            if (!SculkVeinBlock.method_33381((class_2680)state)) {
                class_3610 fluid = level.method_8316(pos);
                state = (fluid.method_15769() ? class_2246.field_10124 : class_2246.field_10382).method_9564();
            }
            level.method_8652(pos, state, 3);
            SculkSpreadable.super.spreadAtSamePosition(level, state, pos, random);
        }
    }

    @Override
    public int spread(SculkSpreadManager.Cursor cursor, class_1936 level, class_2338 pos, Random random, SculkSpreadManager spreadManager, boolean shouldConvert) {
        if (shouldConvert && this.convertToBlock(spreadManager, level, cursor.getPos(), random)) {
            return cursor.getCharge() - 1;
        }
        return random.nextInt(spreadManager.getSpreadChance()) == 0 ? class_3532.method_15375((float)((float)cursor.getCharge() * 0.5f)) : cursor.getCharge();
    }

    private boolean convertToBlock(SculkSpreadManager spreadManager, class_1936 level, class_2338 pos, Random random) {
        class_2680 state = level.method_8320(pos);
        class_6862<class_2248> replaceable = spreadManager.getReplaceableBlocks();
        for (class_2350 direction : DirectionUtils.shuffle(random)) {
            class_2338 blockPos;
            class_2680 blockState;
            if (!SculkVeinBlock.hasFace(state, direction) || !(blockState = level.method_8320(blockPos = pos.method_10093(direction))).method_26164(replaceable)) continue;
            class_2680 sculk = WBBlocks.SCULK.get().method_9564();
            level.method_8652(blockPos, sculk, 3);
            if (level instanceof class_3218) {
                class_3218 server = (class_3218)level;
                class_2248.method_9582((class_2680)blockState, (class_2680)sculk, (class_1937)server, (class_2338)pos);
            }
            level.method_8396(null, blockPos, WBSoundEvents.BLOCK_SCULK_SPREAD, class_3419.field_15245, 1.0f, 1.0f);
            this.allGrowTypeGrower.grow(sculk, level, blockPos, spreadManager.isWorldGen());
            class_2350 opposite = direction.method_10153();
            for (class_2350 towards : field_28421) {
                class_2338 targetPos;
                class_2680 targetState;
                if (towards == opposite || !(targetState = level.method_8320(targetPos = blockPos.method_10093(towards))).method_27852((class_2248)this)) continue;
                this.spreadAtSamePosition(level, targetState, targetPos, random);
            }
            return true;
        }
        return false;
    }

    public static boolean veinCoversSculkReplaceable(class_1936 level, class_2680 state, class_2338 pos) {
        if (state.method_27852(WBBlocks.SCULK_VEIN.get())) {
            for (class_2350 direction : field_28421) {
                if (!SculkVeinBlock.hasFace(state, direction) || !level.method_8320(pos.method_10093(direction)).method_26164(WBBlockTags.SCULK_REPLACEABLE)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canGrowWithDirection(class_1922 getter, class_2680 state, class_2338 pos, class_2350 direction) {
        if (!(!this.method_33369(direction) || state.method_27852((class_2248)this) && SculkVeinBlock.hasFace(state, direction))) {
            class_2338 blockPos = pos.method_10093(direction);
            return SculkVeinBlock.canGrowOn(getter, direction, blockPos, getter.method_8320(blockPos));
        }
        return false;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{WATERLOGGED});
    }

    public boolean method_9616(class_2680 state, class_1750 context) {
        return !context.method_8041().method_31574(WBBlocks.SCULK_VEIN.get().method_8389()) || super.method_9616(state, context);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_3619 method_9527(class_2680 p_60584_) {
        return class_3619.field_15971;
    }

    public static byte directionsToFlag(Collection<class_2350> directions) {
        byte flag = 0;
        for (class_2350 direction : directions) {
            flag = (byte)(flag | 1 << direction.ordinal());
        }
        return flag;
    }

    public static Set<class_2350> collectDirections(class_2680 state) {
        if (!(state.method_26204() instanceof class_5778)) {
            return Set.of();
        }
        EnumSet<class_2350> directions = EnumSet.noneOf(class_2350.class);
        for (class_2350 direction : field_28421) {
            if (!SculkVeinBlock.hasFace(state, direction)) continue;
            directions.add(direction);
        }
        return directions;
    }

    public static boolean canGrowOn(class_1922 getter, class_2350 direction, class_2338 pos, class_2680 state) {
        return class_2248.method_9501((class_265)state.method_26222(getter, pos), (class_2350)direction.method_10153()) || class_2248.method_9501((class_265)state.method_26220(getter, pos), (class_2350)direction.method_10153());
    }

    public static boolean hasFace(class_2680 state, class_2350 direction) {
        class_2746 booleanProperty = class_5778.method_33374((class_2350)direction);
        return state.method_28498((class_2769)booleanProperty) && (Boolean)state.method_11654((class_2769)booleanProperty) != false;
    }

    class SculkVeinGrowChecker
    extends VeinGrower.VeinGrowChecker {
        private final VeinGrower.GrowType[] growTypes;

        public SculkVeinGrowChecker(VeinGrower.GrowType ... growTypes) {
            super(SculkVeinBlock.this);
            this.growTypes = growTypes;
        }

        @Override
        public boolean canGrow(class_1922 getter, class_2338 pos, class_2338 growPos, class_2350 direction, class_2680 state) {
            class_2338 blockPos;
            boolean flag;
            class_2680 blockState = getter.method_8320(growPos.method_10093(direction));
            boolean bl = flag = blockState.method_27852(WBBlocks.SCULK.get()) || blockState.method_27852(WBBlocks.SCULK_CATALYST.get()) || blockState.method_27852(class_2246.field_10008);
            if (flag) {
                return false;
            }
            if (pos.method_19455((class_2382)growPos) == 2 && getter.method_8320(blockPos = pos.method_10093(direction.method_10153())).method_26206(getter, blockPos, direction)) {
                return false;
            }
            class_3610 fluidState = state.method_26227();
            if (!fluidState.method_15769() && !fluidState.method_39360((class_3611)class_3612.field_15910)) {
                return false;
            }
            return state.method_26207().method_15800() || super.canGrow(getter, pos, growPos, direction, state);
        }

        @Override
        public VeinGrower.GrowType[] getGrowTypes() {
            return this.growTypes;
        }

        @Override
        public boolean canGrow(class_2680 state) {
            return !state.method_27852(WBBlocks.SCULK_VEIN.get());
        }
    }
}

