/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.blocks.entity;

import com.cursedcauldron.wildbackport.WildBackport;
import com.cursedcauldron.wildbackport.client.particle.ShriekParticleOptions;
import com.cursedcauldron.wildbackport.client.registry.WBSoundEvents;
import com.cursedcauldron.wildbackport.common.blocks.SculkShriekerBlock;
import com.cursedcauldron.wildbackport.common.entities.Warden;
import com.cursedcauldron.wildbackport.common.entities.warden.VibrationHandler;
import com.cursedcauldron.wildbackport.common.entities.warden.WardenSpawnHelper;
import com.cursedcauldron.wildbackport.common.entities.warden.WardenSpawnTracker;
import com.cursedcauldron.wildbackport.common.registry.WBBlockEntities;
import com.cursedcauldron.wildbackport.common.registry.WBGameEvents;
import com.cursedcauldron.wildbackport.common.registry.WBGameRules;
import com.cursedcauldron.wildbackport.common.registry.entity.WBEntityTypes;
import com.cursedcauldron.wildbackport.common.tag.WBGameEventTags;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.OptionalInt;
import java.util.Random;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1676;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5707;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SculkShriekerBlockEntity
extends class_2586
implements VibrationHandler.VibrationConfig {
    private static final Int2ObjectMap<class_3414> SOUND_BY_LEVEL = (Int2ObjectMap)class_156.method_654((Object)new Int2ObjectOpenHashMap(), map -> {
        map.put(1, (Object)WBSoundEvents.WARDEN_NEARBY_CLOSE);
        map.put(2, (Object)WBSoundEvents.WARDEN_NEARBY_CLOSER);
        map.put(3, (Object)WBSoundEvents.WARDEN_NEARBY_CLOSEST);
        map.put(4, (Object)WBSoundEvents.WARDEN_LISTENING_ANGRY);
    });
    private int warningLevel;
    private VibrationHandler listener;

    public SculkShriekerBlockEntity(class_2338 pos, class_2680 state) {
        super(WBBlockEntities.SCULK_SHRIEKER.get(), pos, state);
        this.listener = new VibrationHandler((class_5716)new class_5707(this.field_11867), 8, this, null, 0.0f, 0);
    }

    public VibrationHandler getListener() {
        return this.listener;
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10573("warning_level", 99)) {
            this.warningLevel = tag.method_10550("warning_level");
        }
        if (tag.method_10573("listener", 10)) {
            VibrationHandler.codec(this).parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)tag.method_10562("listener"))).resultOrPartial(arg_0 -> ((Logger)WildBackport.LOGGER).error(arg_0)).ifPresent(listener -> {
                this.listener = listener;
            });
        }
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("warning_level", this.warningLevel);
        VibrationHandler.codec(this).encodeStart((DynamicOps)class_2509.field_11560, (Object)this.listener).resultOrPartial(arg_0 -> ((Logger)WildBackport.LOGGER).error(arg_0)).ifPresent(listener -> tag.method_10566("listener", listener));
    }

    @Override
    public class_6862<class_5712> getListenableEvents() {
        return WBGameEventTags.SHRIEKER_CAN_LISTEN;
    }

    @Override
    public boolean shouldListen(class_3218 level, class_5714 listener, class_2338 pos, class_5712 event, @Nullable class_1297 entity) {
        return !this.method_11015() && (Boolean)this.method_11010().method_11654((class_2769)SculkShriekerBlock.SHRIEKING) == false && SculkShriekerBlockEntity.tryGetPlayer(entity) != null;
    }

    @Nullable
    public static class_3222 tryGetPlayer(@Nullable class_1297 entity) {
        class_1676 projectile;
        class_1297 owner;
        class_1297 passenger;
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            return player;
        }
        if (entity != null && (passenger = entity.method_5642()) instanceof class_3222) {
            class_3222 player = (class_3222)passenger;
            return player;
        }
        if (entity instanceof class_1676 && (owner = (projectile = (class_1676)entity).method_24921()) instanceof class_3222) {
            class_3222 player = (class_3222)owner;
            return player;
        }
        return null;
    }

    @Override
    public void onSignalReceive(class_3218 level, class_5714 listener, class_2338 pos, class_5712 event, @Nullable class_1297 entity, @Nullable class_1297 source, float distance) {
        this.tryShriek(level, SculkShriekerBlockEntity.tryGetPlayer(source != null ? source : entity));
    }

    public void tryShriek(class_3218 level, @Nullable class_3222 player) {
        class_2680 state;
        if (player != null && !((Boolean)(state = this.method_11010()).method_11654((class_2769)SculkShriekerBlock.SHRIEKING)).booleanValue()) {
            this.warningLevel = 0;
            if (!this.canRespond(level) || this.tryToWarn(level, player)) {
                this.shriek(level, (class_1297)player);
            }
        }
    }

    private boolean tryToWarn(class_3218 level, class_3222 player) {
        OptionalInt warning = WardenSpawnTracker.tryWarn(level, this.method_11016(), player);
        warning.ifPresent(warningLevel -> {
            this.warningLevel = warningLevel;
        });
        return warning.isPresent();
    }

    private void shriek(class_3218 level, @Nullable class_1297 entity) {
        class_2338 pos = this.method_11016();
        class_2680 state = this.method_11010();
        level.method_8652(pos, (class_2680)state.method_11657((class_2769)SculkShriekerBlock.SHRIEKING, (Comparable)Boolean.valueOf(true)), 2);
        level.method_39279(pos, state.method_26204(), 90);
        level.method_8465(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), WBSoundEvents.BLOCK_SCULK_SHRIEKER_SHRIEK, class_3419.field_15245, 2.0f, 0.6f + level.field_9229.nextFloat() * 0.4f);
        for (int i = 0; i < 10; ++i) {
            int delay = i * 5;
            level.method_14199((class_2394)new ShriekParticleOptions(delay), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + SculkShriekerBlock.TOP_Y, (double)pos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        level.method_32888(entity, WBGameEvents.SHRIEK.get(), pos);
    }

    private boolean canRespond(class_3218 level) {
        return (Boolean)this.method_11010().method_11654((class_2769)SculkShriekerBlock.CAN_SUMMON) != false && level.method_8407() != class_1267.field_5801 && level.method_8450().method_8355(WBGameRules.DO_WARDEN_SPAWNING);
    }

    public void tryRespond(class_3218 level) {
        if (this.canRespond(level) && this.warningLevel > 0) {
            if (!this.trySummonWarden(level)) {
                this.playWardenReplySound();
            }
            Warden.addDarknessToClosePlayers(level, class_243.method_24953((class_2382)this.method_11016()), null, 40);
        }
    }

    private void playWardenReplySound() {
        class_3414 sound = (class_3414)SOUND_BY_LEVEL.get(this.warningLevel);
        if (sound != null && this.field_11863 != null) {
            class_2338 pos = this.method_11016();
            int x = pos.method_10263() + class_3532.method_32751((Random)this.field_11863.field_9229, (int)-10, (int)10);
            int y = pos.method_10264() + class_3532.method_32751((Random)this.field_11863.field_9229, (int)-10, (int)10);
            int z = pos.method_10260() + class_3532.method_32751((Random)this.field_11863.field_9229, (int)-10, (int)10);
            this.field_11863.method_8465(null, (double)x, (double)y, (double)z, sound, class_3419.field_15251, 5.0f, 1.0f);
        }
    }

    private boolean trySummonWarden(class_3218 level) {
        return this.warningLevel >= 4 && WardenSpawnHelper.trySpawnMob(WBEntityTypes.WARDEN.get(), class_3730.field_16461, level, this.method_11016(), 20, 5, 6).isPresent();
    }

    @Override
    public void onSignalSchedule() {
        this.method_5431();
    }
}

